/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cloud.http.restemplate;

import cn.hutool.core.util.ObjectUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.violet.common.cloud.feign.header.VioletFeignHeadersProperties;

public class RestTemplateHeaderInterceptor
implements ClientHttpRequestInterceptor {
    private final VioletFeignHeadersProperties properties;

    public ClientHttpResponse intercept(HttpRequest request, byte[] bytes, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders httpHeaders = request.getHeaders();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (httpServletRequest == null) {
            return execution.execute(request, bytes);
        }
        HttpHeaders headers = request.getHeaders();
        headers.forEach((key, values) -> {
            String value = httpServletRequest.getHeader(key);
            if (ObjectUtil.isNotEmpty((Object)value)) {
                httpHeaders.add(key, value);
            }
        });
        return execution.execute(request, bytes);
    }

    @Generated
    public RestTemplateHeaderInterceptor(VioletFeignHeadersProperties properties) {
        this.properties = properties;
    }
}

