package org.violet.common.bootstrap.handler.adapter;

import com.google.auto.service.AutoService;
import org.violet.common.launch.entity.JsonResult;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.violet.common.bootstrap.handler.ExceptionAdapter;

@AutoService(ExceptionAdapter.class)
public class HttpFileExceptionAdapter implements ExceptionAdapter {
    public HttpFileExceptionAdapter() {
    }

    public String[] supportExceptions() {
        return new String[]{MultipartException.class.getName(), MissingServletRequestPartException.class.getName()};
    }

    public JsonResult adapter(Throwable e) {
        JsonResult result = JsonResult.ERROR("文件上传异常");
        return result;
    }
}