package org.violet.common.bootstrap.handler.adapter;

import com.google.auto.service.AutoService;
import org.violet.common.launch.entity.JsonResult;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.violet.common.bootstrap.handler.ExceptionAdapter;

@AutoService(ExceptionAdapter.class)
public class HttpCommonExceptionAdapter implements ExceptionAdapter {
    public HttpCommonExceptionAdapter() {
    }

    public String[] supportExceptions() {
        return new String[]{HttpRequestMethodNotSupportedException.class.getName(), HttpMessageNotReadableException.class.getName(), HttpMediaTypeNotSupportedException.class.getName(), IllegalArgumentException.class.getName(), NoHandlerFoundException.class.getName()};
    }

    public JsonResult adapter(Throwable e) {
        JsonResult result = JsonResult.ERROR("请求异常");
        if (e instanceof IllegalArgumentException) {
            result.msg(e.getMessage());
        } else if (e instanceof NoHandlerFoundException) {
            result.msg("未知的请求地址");
        }

        return result;
    }
}