package org.violet.common.bootstrap.handler.adapter;

import com.google.auto.service.AutoService;
import org.violet.common.launch.entity.JsonResult;
import org.violet.common.bootstrap.handler.ExceptionAdapter;
import org.violet.common.core.exception.BizException;

@AutoService(ExceptionAdapter.class)
public class BizExceptionAdapter implements ExceptionAdapter {
    public BizExceptionAdapter() {
    }

    public String[] supportExceptions() {
        return new String[]{BizException.class.getName()};
    }

    public JsonResult adapter(Throwable e) {
        JsonResult result = JsonResult.ERROR("权限认证异常");
        if (e instanceof BizException) {
            BizException exception = (BizException) e;
            result.msg(exception.getMessage());
        }

        return result;
    }
}