/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.sugarcrm;

import com.sugarcrm.ws.soap.SelectFields;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.metamodel.schema.Column;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

final class SugarCrmXmlHelper {
    SugarCrmXmlHelper() {
    }

    public static SelectFields createSelectFields(List<Column> columns) {
        Document document;
        SelectFields selectFields = new SelectFields();
        selectFields.setArrayType("xsd:string[]");
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        List<Object> fieldList = selectFields.getAny();
        for (Column column : columns) {
            String fieldName = column.getName();
            Element elem = document.createElement("v");
            elem.appendChild(document.createTextNode(fieldName));
            fieldList.add(elem);
        }
        return selectFields;
    }

    public static Element getChildElement(Node node, String childName) {
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        int i = 0;
        while (i < length) {
            Node item = childNodes.item(i);
            if (item instanceof Element && item.getNodeName().equals(childName)) {
                return (Element)item;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getChildElements(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node instanceof Element) {
                list.add((Element)node);
            }
            ++i;
        }
        return list;
    }

    public static String getTextContent(Element element) {
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node instanceof Text) {
                String textContent = ((Text)node).getWholeText();
                textContent = textContent.trim();
                return textContent;
            }
            ++i;
        }
        return null;
    }

    public static String getChildElementText(Node node, String childName) {
        Element child = SugarCrmXmlHelper.getChildElement(node, childName);
        if (child != null) {
            return SugarCrmXmlHelper.getTextContent(child);
        }
        return null;
    }
}

