/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.utils;

import cn.com.syan.jcee.utils.codec.binary.Base64;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class StringFormatHelper {
    static final String separator = System.getProperty("line.separator");
    static final String PKCS7_HEADER = "-----BEGIN PKCS7 REQUEST-----";
    static final String PKCS7_END = "-----END PKCS7 REQUEST-----";
    static final String PKCS10_HEADER = "-----BEGIN CERTIFICATE REQUEST-----";
    static final String PKCS10_END = "-----END CERTIFICATE REQUEST-----";
    static final String CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    static final String CERTIFICATE_END = "-----END CERTIFICATE-----";
    static final String ENCRYPTED_KEY_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    static final String ENCRYPTED_KEY_END = "-----END ENCRYPTED PRIVATE KEY-----";
    static final String RSA_PRIVATE_KEY_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    static final String RSA_PRIVATE_KEY_END = "-----END RSA PRIVATE KEY-----";
    static final String EC_PRIVATE_KEY_HEADER = "-----BEGIN EC PRIVATE KEY-----";
    static final String EC_PRIVATE_KEY_END = "-----END EC PRIVATE KEY-----";
    public static final int PKCS10 = 0;
    public static final int CERTIFICATE = 1;
    public static final int PKCS7 = 2;
    public static final int ENCRYPTED_KEY = 3;
    public static final int RSA_PRIVATE_KEY = 4;
    public static final int EC_PRIVATE_KEY = 5;

    public static String toPEMString(String base64Data, int type) throws IOException {
        String pem = "";
        switch (type) {
            case 0: {
                pem = StringFormatHelper.format(base64Data, PKCS10_HEADER, PKCS10_END);
                break;
            }
            case 1: {
                pem = StringFormatHelper.format(base64Data, CERTIFICATE_HEADER, CERTIFICATE_END);
                break;
            }
            case 2: {
                pem = StringFormatHelper.format(base64Data, PKCS7_HEADER, PKCS7_END);
                break;
            }
            case 3: {
                pem = StringFormatHelper.format(base64Data, ENCRYPTED_KEY_HEADER, ENCRYPTED_KEY_END);
                break;
            }
            case 4: {
                pem = StringFormatHelper.format(base64Data, RSA_PRIVATE_KEY_HEADER, RSA_PRIVATE_KEY_END);
                break;
            }
            case 5: {
                pem = StringFormatHelper.format(base64Data, EC_PRIVATE_KEY_HEADER, EC_PRIVATE_KEY_END);
                break;
            }
        }
        return pem;
    }

    public static String toPEMString(byte[] data, int type) throws IOException {
        String base64Data = new String(Base64.encodeBase64(data));
        return StringFormatHelper.toPEMString(base64Data, type);
    }

    public static String toBase64String(byte[] data) {
        return Base64.encodeBase64String(data);
    }

    public byte[] fromBase64String(String data) {
        return Base64.decodeBase64(data);
    }

    public static String toPEMString(X509Certificate x509Certificate) throws CertificateEncodingException {
        String base64Data = new String(Base64.encodeBase64(x509Certificate.getEncoded()));
        return StringFormatHelper.format(base64Data, CERTIFICATE_HEADER, CERTIFICATE_END);
    }

    private static String format(String base64Data, String header, String end) {
        StringBuilder builder = new StringBuilder(header);
        builder.append(separator);
        int tag = 64;
        int lines = base64Data.length() / tag;
        for (int i = 0; i < lines; ++i) {
            builder.append(base64Data.substring(i * tag, (i + 1) * tag));
            builder.append(separator);
        }
        if (base64Data.length() != lines * tag) {
            builder.append(base64Data.substring(lines * tag));
            builder.append(separator);
        }
        builder.append(end);
        builder.append(separator);
        return builder.toString();
    }
}

