/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.utils;

import cn.com.syan.jcee.utils.StringConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestUtil {
    private static String ALGORITHM = "MD5";

    public static String digest(byte[] _mess, String _algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = _algorithm != null ? MessageDigest.getInstance(_algorithm) : MessageDigest.getInstance(ALGORITHM);
        md.update(_mess);
        byte[] mess = md.digest();
        return StringConverter.toHexadecimal(mess);
    }

    public static byte[] digestToBinary(byte[] _mess, String _algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = _algorithm != null ? MessageDigest.getInstance(_algorithm) : MessageDigest.getInstance(ALGORITHM);
        md.update(_mess);
        return md.digest();
    }

    public static String digest(String content) {
        String encryption = null;
        try {
            encryption = MessageDigestUtil.digest(content.getBytes("UTF-8"), null);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return encryption;
    }

    public static byte[] digest(byte[] content, int length, int algoType) {
        String algo;
        byte[] digest = null;
        switch (algoType) {
            case 0: {
                algo = "MD2";
                break;
            }
            case 1: {
                algo = "MD5";
                break;
            }
            case 2: {
                algo = "SHA-1";
                break;
            }
            default: {
                algo = "SHA-1";
            }
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            md.update(content, 0, length);
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        return digest;
    }

    public static byte[] digest(InputStream _stream, String _algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(_algorithm);
        DigestInputStream dis = new DigestInputStream(_stream, md);
        while (dis.read() != -1) {
        }
        byte[] _mess = md.digest();
        _stream.close();
        dis.close();
        return _mess;
    }

    public static String digestAndRevert(String _content) throws NoSuchAlgorithmException {
        String str = MessageDigestUtil.digest(_content);
        StringBuilder builder = new StringBuilder(str);
        return builder.reverse().toString();
    }
}

