/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.utils;

import cn.com.syan.jcee.common.base.util.DateTimeConverter;
import cn.com.syan.jcee.utils.MessageDigestUtil;
import cn.com.syan.jcee.utils.StringConverter;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class CertificateUtil {
    public static String getSubject(X509Certificate certificate) {
        return certificate.getSubjectDN().toString();
    }

    public static String getIssuer(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().toString();
    }

    public static String getValidity(X509Certificate certificate) {
        Date nb = certificate.getNotBefore();
        Date na = certificate.getNotAfter();
        String pattern = "yyyy-MM-dd HH:mm:ss";
        StringBuilder builder = new StringBuilder(DateTimeConverter.formatDate(nb, pattern));
        builder.append("\nTo\n");
        builder.append(DateTimeConverter.formatDate(na, pattern));
        return builder.toString();
    }

    public static boolean isCA(X509Certificate certificate) {
        return -1 != certificate.getBasicConstraints();
    }

    public static String getFingerprint(X509Certificate certificate, String hashAlgo) {
        String fingerprint = null;
        try {
            byte[] data = certificate.getEncoded();
            fingerprint = StringConverter.toHexadecimal(MessageDigestUtil.digestToBinary(data, hashAlgo));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fingerprint;
    }

    public static String fromPEMToBase64String(String pemCertificate) {
        String clearData = pemCertificate.trim().replace("\n", "").replace("\r", "");
        if (Base64.isBase64((String)pemCertificate)) {
            return clearData;
        }
        String sep = "-----";
        String header = "-----BEGIN CERTIFICATE-----";
        if (!clearData.contains(header)) {
            throw new IllegalArgumentException("invalid pem certificate");
        }
        String[] values = clearData.split(sep);
        if (4 != values.length) {
            throw new IllegalArgumentException("invalid pem certificate");
        }
        return values[2];
    }
}

