/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.base.http;

import java.nio.charset.CodingErrorAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class XHttpPoolingHttpClientConnectionManager {
    private static PoolingHttpClientConnectionManager phcm = null;
    private static HttpClientBuilder httpClientBuilder = null;
    private static final int MAX_TOTAL_CONNECTIONS = 1000;
    private static final int MAX_ROUTE_CONNECTIONS = 200;
    private static final int WAIT_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 30000;
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;

    public static CloseableHttpClient getCloseableHttpClient() {
        return httpClientBuilder.build();
    }

    private static void createPoolingHttpClientConnectionManager() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            phcm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            phcm.setMaxTotal(1000);
            phcm.setDefaultMaxPerRoute(200);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)phcm);
            httpClientBuilder.setDefaultRequestConfig(defaultRequestConfig);
            phcm.setDefaultConnectionConfig(connectionConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        httpClientBuilder = HttpClients.custom();
        XHttpPoolingHttpClientConnectionManager.createPoolingHttpClientConnectionManager();
    }
}

