/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.base.http;

import cn.com.syan.jcee.common.base.http.HttpException;
import cn.com.syan.jcee.common.base.http.XHttpPoolingHttpClientConnectionManager;
import cn.com.syan.jcee.common.base.http.XHttpRequest;
import cn.com.syan.jcee.common.base.http.XHttpRequestGet;
import cn.com.syan.jcee.common.base.http.XHttpRequestPost;
import cn.com.syan.jcee.common.base.http.XHttpResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHttpClientV2 {
    CloseableHttpClient httpClient = null;
    final int SUCCESS = 200;

    public XHttpClientV2() {
    }

    public XHttpClientV2(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public XHttpResponse execute(XHttpRequest request) throws HttpException {
        if (request.getMethod().equals("post")) {
            return this.post((XHttpRequestPost)request);
        }
        return this.get((XHttpRequestGet)request);
    }

    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = XHttpPoolingHttpClientConnectionManager.getCloseableHttpClient();
        }
        return this.httpClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XHttpResponse doPost(String url, Map parameters, int responseDataType) throws HttpException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        XHttpResponse xHttpResponse = null;
        CloseableHttpResponse httpResponse = null;
        HttpEntity httpResponseEntity = null;
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            Map paraMap = parameters;
            for (String key : paraMap.keySet()) {
                Object value = paraMap.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        params.add(new BasicNameValuePair(key, (String)value));
                        continue;
                    }
                    if (!(value instanceof byte[])) continue;
                    ByteArrayEntity byteArrayEntity = new ByteArrayEntity((byte[])value);
                    httpPost.setEntity((HttpEntity)byteArrayEntity);
                    continue;
                }
                params.add(new BasicNameValuePair(key, ""));
            }
            if (params.size() >= 1) {
                UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(params, "UTF-8");
                httpPost.setEntity((HttpEntity)httpEntity);
            }
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpPost);
            int status = httpResponse.getStatusLine().getStatusCode();
            xHttpResponse = new XHttpResponse(status);
            if (status == 200) {
                httpResponseEntity = httpResponse.getEntity();
                if (responseDataType == 0) {
                    xHttpResponse.setBinaryResponse(EntityUtils.toByteArray((HttpEntity)httpResponseEntity));
                } else if (responseDataType == 1) {
                    xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)httpResponseEntity));
                }
            }
            if (null == httpResponseEntity) return xHttpResponse;
        }
        catch (Exception ex) {
            try {
                throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                if (null == httpResponseEntity) throw throwable;
                EntityUtils.consumeQuietly(httpResponseEntity);
                httpPost.abort();
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        httpPost.abort();
        return xHttpResponse;
    }

    public XHttpResponse post(String url, Map parameters) throws HttpException {
        return this.doPost(url, parameters, 1);
    }

    public XHttpResponse post(String url, Map parameters, int responseDataType) throws HttpException {
        return this.doPost(url, parameters, responseDataType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XHttpResponse post(String url, Map<String, Object> paraMap, String fileParameterName, byte[] fileParameterBinary, int responseDataType) throws HttpException {
        HttpPost httpPost = new HttpPost(url);
        XHttpResponse xHttpResponse = null;
        CloseableHttpResponse httpResponse = null;
        HttpEntity httpResponseEntity = null;
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Consts.UTF_8);
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        StringBody content = null;
        for (String key : paraMap.keySet()) {
            Object value = paraMap.get(key);
            if (value == null || !(value instanceof String)) continue;
            content = new StringBody((String)value, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
            builder.addPart(key, (ContentBody)content);
        }
        if (null != fileParameterBinary) {
            builder.addBinaryBody(fileParameterName, fileParameterBinary);
        }
        httpPost.setEntity(builder.build());
        try {
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpPost);
            int status = httpResponse.getStatusLine().getStatusCode();
            xHttpResponse = new XHttpResponse(status);
            if (status == 200) {
                httpResponseEntity = httpResponse.getEntity();
                if (responseDataType == 0) {
                    xHttpResponse.setBinaryResponse(EntityUtils.toByteArray((HttpEntity)httpResponseEntity));
                } else {
                    xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)httpResponseEntity));
                }
            }
            if (null == httpResponseEntity) return xHttpResponse;
        }
        catch (Exception ex) {
            try {
                throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                if (null == httpResponseEntity) throw throwable;
                EntityUtils.consumeQuietly(httpResponseEntity);
                httpPost.abort();
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        httpPost.abort();
        return xHttpResponse;
    }

    public XHttpResponse post(XHttpRequestPost postRequest) throws HttpException {
        return this.doPost(postRequest.getUrl(), postRequest.getParameters(), postRequest.getRequestDataType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XHttpResponse get(XHttpRequestGet getRequest) throws HttpException {
        XHttpResponse xHttpResponse;
        HttpGet httpGet;
        block6: {
            CloseableHttpResponse httpResponse = null;
            httpGet = new HttpGet(getRequest.getUrl());
            xHttpResponse = null;
            HttpEntity httpEntity = null;
            try {
                httpResponse = this.getHttpClient().execute((HttpUriRequest)httpGet);
                int status = httpResponse.getStatusLine().getStatusCode();
                xHttpResponse = new XHttpResponse(status);
                if (status == 200) {
                    httpEntity = httpResponse.getEntity();
                    xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)httpEntity));
                }
                if (null == httpResponse) break block6;
            }
            catch (Exception ex) {
                try {
                    throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    if (null != httpResponse) {
                        EntityUtils.consumeQuietly(httpEntity);
                    }
                    httpGet.abort();
                    throw throwable;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        }
        httpGet.abort();
        return xHttpResponse;
    }

    public XHttpResponse get(String url, Map parameters) throws HttpException {
        return this.doGet(url, parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XHttpResponse doGet(String url, Map parameters) throws HttpException {
        XHttpResponse xHttpResponse;
        HttpGet httpGet;
        block7: {
            CloseableHttpResponse httpResponse = null;
            XHttpRequestGet requestGet = new XHttpRequestGet(url);
            if (null != parameters) {
                requestGet.setParameters(parameters);
            }
            httpGet = new HttpGet(requestGet.getUrl());
            xHttpResponse = null;
            HttpEntity httpEntity = null;
            try {
                httpResponse = this.getHttpClient().execute((HttpUriRequest)httpGet);
                int status = httpResponse.getStatusLine().getStatusCode();
                xHttpResponse = new XHttpResponse(status);
                if (200 == status) {
                    httpEntity = httpResponse.getEntity();
                    xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)httpEntity));
                }
                if (null == httpEntity) break block7;
            }
            catch (Exception ex) {
                try {
                    throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
                }
                catch (Throwable throwable) {
                    if (null != httpEntity) {
                        EntityUtils.consumeQuietly(httpEntity);
                    }
                    httpGet.abort();
                    throw throwable;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        }
        httpGet.abort();
        return xHttpResponse;
    }
}

