/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.base.http;

import cn.com.syan.jcee.common.base.http.scheme.SchemeRegistryFactory;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionManagerFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.VersionInfo;

public class XHttpClientManager {
    private static final int MAX_TOTAL_CONNECTIONS = 200000;
    private static final int MAX_ROUTE_CONNECTIONS = 20000;
    private static final int WAIT_TIMEOUT = 30000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;
    private static final int SOCKET_BUFFER_SIZE = 10240;
    private static int defaultSSLPort = 443;
    private static ClientConnectionManager connectionManager;

    public static void enableSSL(int port) {
        defaultSSLPort = port;
        try {
            AllTrustedX509TrustManager tm = new AllTrustedX509TrustManager();
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry sr = connectionManager.getSchemeRegistry();
            sr.register(new Scheme("https", port, (SchemeSocketFactory)ssf));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public static HttpClient getDefaultHttpClient() {
        return new DefaultHttpClient(connectionManager);
    }

    public static HttpClient getSSLHttpClient(int port) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        AllTrustedX509TrustManager tm = new AllTrustedX509TrustManager();
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", port, (SchemeSocketFactory)ssf));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return httpClient;
    }

    private static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)HTTP.DEF_CONTENT_CHARSET.name());
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)("Apache-HttpClient/" + release + " (java 1.5)"));
    }

    private static HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        XHttpClientManager.setDefaultHttpParams((HttpParams)params);
        return params;
    }

    private static ClientConnectionManager createClientConnectionManager() {
        SchemeRegistry registry = SchemeRegistryFactory.createDefault();
        Object connManager = null;
        HttpParams params = XHttpClientManager.createHttpParams();
        ClientConnectionManagerFactory factory = null;
        String className = (String)params.getParameter("http.connection-manager.factory-class-name");
        if (className != null) {
            try {
                Class<?> ex = Class.forName(className);
                factory = (ClientConnectionManagerFactory)ex.newInstance();
            }
            catch (ClassNotFoundException var7) {
                throw new IllegalStateException("Invalid class name: " + className);
            }
            catch (IllegalAccessException var8) {
                throw new IllegalAccessError(var8.getMessage());
            }
            catch (InstantiationException var9) {
                throw new InstantiationError(var9.getMessage());
            }
        }
        connManager = factory != null ? factory.newInstance(params, registry) : new BasicClientConnectionManager(registry);
        return connManager;
    }

    static {
        if (connectionManager == null) {
            connectionManager = XHttpClientManager.createClientConnectionManager();
        }
        XHttpClientManager.enableSSL(defaultSSLPort);
    }

    static class AllTrustedX509TrustManager
    extends X509ExtendedTrustManager {
        AllTrustedX509TrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

