/*
 * Decompiled with CFR 0.152.
 */
package cn.com.syan.jcee.common.base.http;

import cn.com.syan.jcee.common.base.http.HttpException;
import cn.com.syan.jcee.common.base.http.URLParser;
import cn.com.syan.jcee.common.base.http.XHttpClientManager;
import cn.com.syan.jcee.common.base.http.XHttpRequest;
import cn.com.syan.jcee.common.base.http.XHttpRequestGet;
import cn.com.syan.jcee.common.base.http.XHttpRequestPost;
import cn.com.syan.jcee.common.base.http.XHttpResponse;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class XHttpClient {
    HttpClient httpClient = null;

    public XHttpClient() {
    }

    public XHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public XHttpResponse execute(XHttpRequest request) throws HttpException {
        if (request.getMethod().equals("post")) {
            return this.post((XHttpRequestPost)request);
        }
        return this.get((XHttpRequestGet)request);
    }

    private XHttpResponse doPost(String url, Map parameters, int responseDataType) throws HttpException {
        DefaultHttpClient httpClient = (DefaultHttpClient)XHttpClientManager.getDefaultHttpClient();
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        httpClient.setCookieStore((CookieStore)new BasicCookieStore());
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        XHttpResponse xHttpResponse = null;
        CloseableHttpResponse httpResponse = null;
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            Map paraMap = parameters;
            for (String key : paraMap.keySet()) {
                Object value = paraMap.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        params.add(new BasicNameValuePair(key, (String)value));
                        continue;
                    }
                    if (!(value instanceof byte[])) continue;
                    ByteArrayEntity byteArrayEntity = new ByteArrayEntity((byte[])value);
                    httpPost.setEntity((HttpEntity)byteArrayEntity);
                    continue;
                }
                params.add(new BasicNameValuePair(key, ""));
            }
            if (params.size() >= 1) {
                UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(params, "UTF-8");
                httpPost.setEntity((HttpEntity)httpEntity);
            }
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int status = httpResponse.getStatusLine().getStatusCode();
            xHttpResponse = new XHttpResponse(status);
            if (status == 200) {
                HttpEntity re = httpResponse.getEntity();
                if (responseDataType == 0) {
                    xHttpResponse.setBinaryResponse(EntityUtils.toByteArray((HttpEntity)re));
                    re = null;
                } else if (responseDataType == 1) {
                    xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)re));
                }
            }
        }
        catch (Exception ex) {
            throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
        }
        finally {
            if (null != httpResponse) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                httpPost.abort();
                httpClient.close();
            }
        }
        return xHttpResponse;
    }

    public XHttpResponse jsonPost(String url, String jsonParam) throws HttpException {
        HttpResponse httpResponse = null;
        if (this.httpClient == null) {
            URLParser parser = new URLParser(url);
            int port = parser.getPort();
            this.httpClient = parser.getScheme().equalsIgnoreCase("https") ? XHttpClientManager.getSSLHttpClient(port) : XHttpClientManager.getDefaultHttpClient();
        }
        this.httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        HttpPost httpPost = new HttpPost(url);
        XHttpResponse xHttpResponse = null;
        try {
            StringEntity entity = new StringEntity(jsonParam, "utf-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            int status = httpResponse.getStatusLine().getStatusCode();
            xHttpResponse = new XHttpResponse(status);
            if (status == 200) {
                HttpEntity re = httpResponse.getEntity();
                xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)re));
            }
        }
        catch (Exception ex) {
            throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
        }
        finally {
            if (null != httpResponse) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
        return xHttpResponse;
    }

    public XHttpResponse post(String url, Map parameters) throws HttpException {
        return this.doPost(url, parameters, 1);
    }

    public XHttpResponse post(String url, Map parameters, int responseDataType) throws HttpException {
        return this.doPost(url, parameters, responseDataType);
    }

    public XHttpResponse post(XHttpRequestPost postRequest) throws HttpException {
        return this.doPost(postRequest.getUrl(), postRequest.getParameters(), postRequest.getRequestDataType());
    }

    public XHttpResponse get(XHttpRequestGet getRequest) throws HttpException {
        HttpResponse httpResponse = null;
        HttpClient httpClient = XHttpClientManager.getDefaultHttpClient();
        HttpGet httpGet = new HttpGet(getRequest.getUrl());
        XHttpResponse xHttpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            int status = httpResponse.getStatusLine().getStatusCode();
            xHttpResponse = new XHttpResponse(status);
            if (status == 200) {
                HttpEntity re = httpResponse.getEntity();
                xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)re));
                re = null;
            }
        }
        catch (Exception ex) {
            throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
        }
        finally {
            if (null != httpResponse) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
        return xHttpResponse;
    }

    public XHttpResponse get(String url, Map parameters) throws HttpException {
        return this.doGet(url, parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized XHttpResponse doGet(String url, Map parameters) throws HttpException {
        CloseableHttpResponse httpResponse = null;
        DefaultHttpClient httpClient = (DefaultHttpClient)XHttpClientManager.getDefaultHttpClient();
        XHttpRequestGet requestGet = new XHttpRequestGet(url);
        requestGet.setParameters(parameters);
        HttpGet httpGet = new HttpGet(requestGet.getUrl());
        XHttpResponse xHttpResponse = null;
        HttpEntity httpEntity = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            int status = httpResponse.getStatusLine().getStatusCode();
            xHttpResponse = new XHttpResponse(status);
            if (status == 200) {
                httpEntity = httpResponse.getEntity();
                xHttpResponse.setResponse(EntityUtils.toString((HttpEntity)httpEntity));
            }
            if (null == httpEntity) return xHttpResponse;
        }
        catch (Exception ex) {
            try {
                throw new HttpException("Http \u8bf7\u6c42\u5f02\u5e38\uff1a" + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                if (null == httpEntity) throw throwable;
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return xHttpResponse;
    }
}

