/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.constant.SqlConnector;
import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.query.BaseQueryWrapper;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.Joiner;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryConditionBuilder;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryOrderByBuilder;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.RawQueryColumn;
import com.mybatisflex.core.query.RawQueryCondition;
import com.mybatisflex.core.query.RawQueryOrderBy;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.query.SqlOperators;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.query.With;
import com.mybatisflex.core.query.WithBuilder;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class QueryWrapper
extends BaseQueryWrapper<QueryWrapper> {
    public static QueryWrapper create() {
        return new QueryWrapper();
    }

    public static QueryWrapper create(Object entity) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass((Class)ClassUtil.getUsefulClass(entity.getClass()));
        return tableInfo.buildQueryWrapper(entity, (SqlOperators)null);
    }

    public static QueryWrapper create(Object entity, SqlOperators operators) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass((Class)ClassUtil.getUsefulClass(entity.getClass()));
        return tableInfo.buildQueryWrapper(entity, operators);
    }

    public static QueryWrapper create(Map map) {
        return QueryWrapper.create().where(map);
    }

    public static QueryWrapper create(Map map, SqlOperators operators) {
        return QueryWrapper.create().where(map, operators);
    }

    public boolean hasCondition() {
        QueryCondition c = this.whereQueryCondition;
        return c != null && (c.checkEffective() || c.getNextEffectiveCondition() != null);
    }

    public <Q extends QueryWrapper> WithBuilder<Q> with(String name) {
        if (this.with == null) {
            this.with = new With();
        }
        return new WithBuilder(this, this.with, name);
    }

    public <Q extends QueryWrapper> WithBuilder<Q> with(String name, String ... params) {
        if (this.with == null) {
            this.with = new With();
        }
        return new WithBuilder(this, this.with, name, Arrays.asList(params));
    }

    public <Q extends QueryWrapper> WithBuilder<Q> withRecursive(String name) {
        if (this.with == null) {
            this.with = new With(true);
        }
        return new WithBuilder(this, this.with, name);
    }

    public <Q extends QueryWrapper> WithBuilder<Q> withRecursive(String name, String ... params) {
        if (this.with == null) {
            this.with = new With(true);
        }
        return new WithBuilder(this, this.with, name, Arrays.asList(params));
    }

    public QueryWrapper select() {
        return this;
    }

    public QueryWrapper select(String ... columns) {
        String[] var2 = columns;
        int var3 = columns.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String column = var2[var4];
            this.addSelectColumn((QueryColumn)new RawQueryColumn((Object)column, new Object[0]));
        }
        return this;
    }

    public <T> QueryWrapper select(LambdaGetter<T> ... lambdaGetters) {
        LambdaGetter<T>[] var2 = lambdaGetters;
        int var3 = lambdaGetters.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            LambdaGetter<T> lambdaGetter = var2[var4];
            QueryColumn queryColumn = LambdaUtil.getQueryColumn(lambdaGetter);
            this.addSelectColumn(queryColumn);
        }
        return this;
    }

    public QueryWrapper select(QueryColumn ... queryColumns) {
        QueryColumn[] var2 = queryColumns;
        int var3 = queryColumns.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            QueryColumn column = var2[var4];
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public QueryWrapper select(Iterable<QueryColumn> queryColumns) {
        for (QueryColumn column : queryColumns) {
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public QueryWrapper select(QueryColumn[] ... queryColumns) {
        QueryColumn[][] var2 = queryColumns;
        int var3 = queryColumns.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            QueryColumn[] columnArray = var2[var4];
            if (columnArray == null) continue;
            QueryColumn[] var6 = columnArray;
            int var7 = columnArray.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                QueryColumn column = var6[var8];
                if (column == null) continue;
                this.addSelectColumn(column);
            }
        }
        return this;
    }

    public QueryWrapper select(QueryColumn[] queryColumns, QueryColumn ... queryColumns2) {
        QueryColumn column;
        int var5;
        QueryColumn[] var3 = queryColumns;
        int var4 = queryColumns.length;
        for (var5 = 0; var5 < var4; ++var5) {
            column = var3[var5];
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        var3 = queryColumns2;
        var4 = queryColumns2.length;
        for (var5 = 0; var5 < var4; ++var5) {
            column = var3[var5];
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public QueryWrapper from(Class<?> ... entityClasses) {
        Class<?>[] var2 = entityClasses;
        int var3 = entityClasses.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            Class<?> entityClass = var2[var4];
            TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
            this.from(new QueryTable(tableInfo.getSchema(), tableInfo.getTableName()));
        }
        return this;
    }

    public QueryWrapper from(String ... tables) {
        String[] var2 = tables;
        int var3 = tables.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String table = var2[var4];
            if (StringUtil.noText((String)table)) {
                throw new IllegalArgumentException("table must not be null or blank.");
            }
            this.from(new QueryTable(table));
        }
        return this;
    }

    public QueryWrapper from(QueryTable ... tables) {
        if (CollectionUtil.isEmpty((Collection)this.queryTables)) {
            this.queryTables = new ArrayList();
            this.queryTables.addAll(Arrays.asList(tables));
        } else {
            QueryTable[] var2 = tables;
            int var3 = tables.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                QueryTable table = var2[var4];
                boolean contains = false;
                for (QueryTable queryTable : this.queryTables) {
                    if (!queryTable.isSameTable(table)) continue;
                    contains = true;
                }
                if (contains) continue;
                this.queryTables.add(table);
            }
        }
        return this;
    }

    public QueryWrapper from(QueryWrapper queryWrapper) {
        return this.from(new QueryTable[]{new SelectQueryTable(queryWrapper)});
    }

    public QueryWrapper as(String alias) {
        if (CollectionUtil.isEmpty((Collection)this.queryTables)) {
            throw new IllegalArgumentException("query table must not be empty.");
        }
        int index = this.queryTables.size() - 1;
        this.queryTables.set(index, ((QueryTable)this.queryTables.get(index)).as(alias));
        return this;
    }

    public QueryWrapper where(QueryCondition queryCondition) {
        this.addWhereQueryCondition(queryCondition);
        return this;
    }

    public QueryWrapper where(String sql) {
        this.addWhereQueryCondition((QueryCondition)new RawQueryCondition(sql));
        return this;
    }

    public QueryWrapper where(String sql, Object ... params) {
        this.addWhereQueryCondition((QueryCondition)new RawQueryCondition(sql, params));
        return this;
    }

    public QueryWrapper where(Map<String, Object> whereConditions) {
        return this.and(whereConditions);
    }

    public QueryWrapper where(Map<String, Object> whereConditions, SqlOperators operators) {
        return this.and(whereConditions, operators);
    }

    public <T> QueryConditionBuilder<? extends QueryWrapper> where(LambdaGetter<T> fn) {
        return new QueryConditionBuilder(this, LambdaUtil.getQueryColumn(fn), SqlConnector.AND);
    }

    public QueryWrapper where(Consumer<QueryWrapper> consumer) {
        return this.and(consumer);
    }

    public QueryWrapper and(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.AND);
    }

    public QueryWrapper and(String sql) {
        this.addWhereQueryCondition((QueryCondition)new RawQueryCondition(sql), SqlConnector.AND);
        return this;
    }

    public QueryWrapper and(String sql, Object ... params) {
        this.addWhereQueryCondition((QueryCondition)new RawQueryCondition(sql, params), SqlConnector.AND);
        return this;
    }

    public <T> QueryConditionBuilder<? extends QueryWrapper> and(LambdaGetter<T> fn) {
        return new QueryConditionBuilder(this, LambdaUtil.getQueryColumn(fn), SqlConnector.AND);
    }

    public QueryWrapper and(Consumer<QueryWrapper> consumer) {
        return this.and(consumer, true);
    }

    public QueryWrapper and(Consumer<QueryWrapper> consumer, boolean condition) {
        if (!condition) {
            return this;
        }
        QueryWrapper newWrapper = new QueryWrapper();
        consumer.accept(newWrapper);
        QueryCondition whereQueryCondition = newWrapper.whereQueryCondition;
        if (whereQueryCondition != null) {
            this.and((QueryCondition)new Brackets(whereQueryCondition));
        }
        return this;
    }

    public QueryWrapper and(Map<String, Object> whereConditions) {
        return this.and(whereConditions, SqlOperators.empty());
    }

    public QueryWrapper and(Map<String, Object> whereConditions, SqlOperators operators) {
        return this.connectMap(whereConditions, operators, SqlConnector.AND, SqlConnector.AND);
    }

    public QueryWrapper and(Map<String, Object> whereConditions, SqlOperators operators, SqlConnector innerConnector) {
        return this.connectMap(whereConditions, operators, SqlConnector.AND, innerConnector);
    }

    public QueryWrapper or(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.OR);
    }

    public QueryWrapper or(String sql) {
        this.addWhereQueryCondition((QueryCondition)new RawQueryCondition(sql), SqlConnector.OR);
        return this;
    }

    public QueryWrapper or(String sql, Object ... params) {
        this.addWhereQueryCondition((QueryCondition)new RawQueryCondition(sql, params), SqlConnector.OR);
        return this;
    }

    public <T> QueryConditionBuilder<? extends QueryWrapper> or(LambdaGetter<T> fn) {
        return new QueryConditionBuilder(this, LambdaUtil.getQueryColumn(fn), SqlConnector.OR);
    }

    public QueryWrapper or(Consumer<QueryWrapper> consumer) {
        return this.or(consumer, true);
    }

    public QueryWrapper or(Consumer<QueryWrapper> consumer, boolean condition) {
        if (!condition) {
            return this;
        }
        QueryWrapper newWrapper = new QueryWrapper();
        consumer.accept(newWrapper);
        QueryCondition whereQueryCondition = newWrapper.whereQueryCondition;
        if (whereQueryCondition != null) {
            this.or((QueryCondition)new Brackets(whereQueryCondition));
        }
        return this;
    }

    public QueryWrapper or(Map<String, Object> whereConditions) {
        return this.or(whereConditions, SqlOperators.empty());
    }

    public QueryWrapper or(Map<String, Object> whereConditions, SqlOperators operators) {
        return this.connectMap(whereConditions, operators, SqlConnector.OR, SqlConnector.AND);
    }

    public QueryWrapper or(Map<String, Object> whereConditions, SqlOperators operators, SqlConnector innerConnector) {
        return this.connectMap(whereConditions, operators, SqlConnector.OR, innerConnector);
    }

    protected QueryWrapper connectMap(Map<String, Object> mapConditions, SqlOperators operators, SqlConnector outerConnector, SqlConnector innerConnector) {
        if (operators == null) {
            operators = SqlOperators.empty();
        }
        if (mapConditions != null) {
            QueryTable table = null;
            if (CollectionUtil.isNotEmpty((Collection)this.queryTables)) {
                table = (QueryTable)this.queryTables.get(0);
            }
            QueryCondition condition = null;
            Iterator<Map.Entry<String, Object>> var7 = mapConditions.entrySet().iterator();
            while (true) {
                if (!var7.hasNext()) {
                    this.addWhereQueryCondition(condition, outerConnector);
                    return this;
                }
                Map.Entry<String, Object> entry = var7.next();
                SqlOperator operator = (SqlOperator)operators.get((Object)entry.getKey());
                if (operator == null) {
                    operator = SqlOperator.EQUALS;
                } else if (operator == SqlOperator.IGNORE) continue;
                Object value = entry.getValue();
                if (operator != SqlOperator.LIKE && operator != SqlOperator.NOT_LIKE) {
                    if (operator != SqlOperator.LIKE_LEFT && operator != SqlOperator.NOT_LIKE_LEFT) {
                        if (operator == SqlOperator.LIKE_RIGHT || operator == SqlOperator.NOT_LIKE_RIGHT) {
                            value = "%" + value;
                        }
                    } else {
                        value = value + "%";
                    }
                } else {
                    value = "%" + value + "%";
                }
                QueryCondition cond = QueryCondition.create((QueryColumn)new QueryColumn(table, entry.getKey()), (SqlOperator)operator, (Object)value);
                if (condition == null) {
                    condition = cond;
                    continue;
                }
                if (innerConnector == SqlConnector.AND) {
                    condition.and(cond);
                    continue;
                }
                condition.or(cond);
            }
        }
        return this;
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(QueryTable table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(String table) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(String table, boolean when) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(Class<?> entityClass) {
        return this.joining(" LEFT JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(Class<?> entityClass, boolean when) {
        return this.joining(" LEFT JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(QueryWrapper table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(QueryWrapper table, boolean when) {
        return this.joining(" LEFT JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(QueryTable table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(String table) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(String table, boolean when) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(Class<?> entityClass) {
        return this.joining(" RIGHT JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(Class<?> entityClass, boolean when) {
        return this.joining(" RIGHT JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(QueryWrapper table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(QueryWrapper table, boolean when) {
        return this.joining(" RIGHT JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(QueryTable table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(String table) {
        return this.joining(" INNER JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(String table, boolean when) {
        return this.joining(" INNER JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(Class<?> entityClass) {
        return this.joining(" INNER JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(Class<?> entityClass, boolean when) {
        return this.joining(" INNER JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(QueryWrapper table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(QueryWrapper table, boolean when) {
        return this.joining(" INNER JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(QueryTable table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(String table) {
        return this.joining(" FULL JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(String table, boolean when) {
        return this.joining(" FULL JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(Class<?> entityClass) {
        return this.joining(" FULL JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(Class<?> entityClass, boolean when) {
        return this.joining(" FULL JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(QueryWrapper table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(QueryWrapper table, boolean when) {
        return this.joining(" FULL JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(QueryTable table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(String table) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(String table, boolean when) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(Class<?> entityClass) {
        return this.joining(" CROSS JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(Class<?> entityClass, boolean when) {
        return this.joining(" CROSS JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(QueryWrapper table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(QueryWrapper table, boolean when) {
        return this.joining(" CROSS JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(QueryTable table) {
        return this.joining(" JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(String table) {
        return this.joining(" JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(String table, boolean when) {
        return this.joining(" JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(Class<?> entityClass) {
        return this.joining(" JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(Class<?> entityClass, boolean when) {
        return this.joining(" JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(QueryWrapper table) {
        return this.joining(" JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(QueryWrapper table, boolean when) {
        return this.joining(" JOIN ", table, when);
    }

    public QueryWrapper union(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.union((QueryWrapper)unionQuery));
        return this;
    }

    public QueryWrapper unionAll(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.unionAll((QueryWrapper)unionQuery));
        return this;
    }

    public QueryWrapper forUpdate() {
        this.addEndFragment("FOR UPDATE");
        return this;
    }

    public QueryWrapper forUpdateNoWait() {
        this.addEndFragment("FOR UPDATE NOWAIT");
        return this;
    }

    protected <T extends QueryWrapper> Joiner<T> joining(String type, QueryTable table, boolean when) {
        Join join = new Join(type, table, when);
        this.addJoinTable(join.getQueryTable());
        return new Joiner((QueryWrapper)this.addJoin(join), join);
    }

    protected <T extends QueryWrapper> Joiner<T> joining(String type, Class<?> entityClass, boolean when) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        QueryTable queryTable = new QueryTable(tableInfo.getSchema(), tableInfo.getTableName());
        return this.joining(type, queryTable, when);
    }

    protected <T extends QueryWrapper> Joiner<T> joining(String type, QueryWrapper queryWrapper, boolean when) {
        Join join = new Join(type, queryWrapper, when);
        this.addJoinTable(join.getQueryTable());
        return new Joiner((QueryWrapper)this.addJoin(join), join);
    }

    public QueryWrapper groupBy(String name) {
        this.addGroupByColumns((QueryColumn)new RawQueryColumn((Object)name, new Object[0]));
        return this;
    }

    public QueryWrapper groupBy(String ... names) {
        String[] var2 = names;
        int var3 = names.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String name = var2[var4];
            this.groupBy(name);
        }
        return this;
    }

    public QueryWrapper groupBy(QueryColumn column) {
        this.addGroupByColumns(column);
        return this;
    }

    public QueryWrapper groupBy(QueryColumn ... columns) {
        QueryColumn[] var2 = columns;
        int var3 = columns.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            QueryColumn column = var2[var4];
            this.groupBy(column);
        }
        return this;
    }

    public <T> QueryWrapper groupBy(LambdaGetter<T> column) {
        this.addGroupByColumns(LambdaUtil.getQueryColumn(column));
        return this;
    }

    public <T> QueryWrapper groupBy(LambdaGetter<T> ... columns) {
        LambdaGetter<T>[] var2 = columns;
        int var3 = columns.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            LambdaGetter<T> column = var2[var4];
            this.groupBy(LambdaUtil.getQueryColumn(column));
        }
        return this;
    }

    public QueryWrapper having(QueryCondition queryCondition) {
        this.addHavingQueryCondition(queryCondition, SqlConnector.AND);
        return this;
    }

    public QueryWrapper orderBy(QueryColumn column, Boolean asc) {
        if (asc != null) {
            if (asc.booleanValue()) {
                this.addOrderBy(column.asc());
            } else {
                this.addOrderBy(column.desc());
            }
        }
        return this;
    }

    public QueryWrapper orderBy(QueryOrderBy ... orderBys) {
        QueryOrderBy[] var2 = orderBys;
        int var3 = orderBys.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            QueryOrderBy queryOrderBy = var2[var4];
            this.addOrderBy(queryOrderBy);
        }
        return this;
    }

    public <T> QueryWrapper orderBy(LambdaGetter<T> column, Boolean asc) {
        if (asc != null) {
            if (asc.booleanValue()) {
                this.addOrderBy(LambdaUtil.getQueryColumn(column).asc());
            } else {
                this.addOrderBy(LambdaUtil.getQueryColumn(column).desc());
            }
        }
        return this;
    }

    public <T> QueryOrderByBuilder<? extends QueryWrapper> orderBy(LambdaGetter<T> getter) {
        return new QueryOrderByBuilder(this, getter);
    }

    public QueryWrapper orderBy(String column, Boolean asc) {
        if (asc != null) {
            if (asc.booleanValue()) {
                this.addOrderBy(new RawQueryColumn((Object)column, new Object[0]).asc());
            } else {
                this.addOrderBy(new RawQueryColumn((Object)column, new Object[0]).desc());
            }
        }
        return this;
    }

    public QueryWrapper orderBy(String ... orderBys) {
        if (orderBys != null && orderBys[0] != null) {
            String[] var2 = orderBys;
            int var3 = orderBys.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String queryOrderBy = var2[var4];
                if (!StringUtil.hasText((String)queryOrderBy)) continue;
                this.addOrderBy((QueryOrderBy)new RawQueryOrderBy(queryOrderBy));
            }
            return this;
        }
        return this;
    }

    public QueryWrapper orderByUnSafely(String ... rawOrderBy) {
        if (rawOrderBy != null && rawOrderBy[0] != null) {
            String[] var2 = rawOrderBy;
            int var3 = rawOrderBy.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String queryOrderBy = var2[var4];
                if (!StringUtil.hasText((String)queryOrderBy)) continue;
                this.addOrderBy((QueryOrderBy)new RawQueryOrderBy(queryOrderBy, false));
            }
            return this;
        }
        return this;
    }

    public QueryWrapper limit(Number rows) {
        if (rows != null) {
            this.setLimitRows(rows.longValue());
        } else {
            this.setLimitRows(null);
        }
        return this;
    }

    public QueryWrapper offset(Number offset) {
        if (offset != null) {
            this.setLimitOffset(offset.longValue());
        } else {
            this.setLimitOffset(null);
        }
        return this;
    }

    public QueryWrapper limit(Number offset, Number rows) {
        this.offset(offset);
        this.limit(rows);
        return this;
    }

    public QueryWrapper datasource(String datasource) {
        this.setDataSource(datasource);
        return this;
    }

    public QueryWrapper hint(String hint) {
        this.setHint(hint);
        return this;
    }

    public QueryWrapper eq(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).eq(value));
        return this;
    }

    public <T> QueryWrapper eq(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).eq(value));
        return this;
    }

    public QueryWrapper eq(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).eq_(value));
        }
        return this;
    }

    public <T> QueryWrapper eq(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).eq_(value));
        }
        return this;
    }

    public <V> QueryWrapper eq(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).eq_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper eq(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).eq_(value));
        }
        return this;
    }

    public QueryWrapper ne(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).ne(value));
        return this;
    }

    public <T> QueryWrapper ne(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).ne(value));
        return this;
    }

    public QueryWrapper ne(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).ne_(value));
        }
        return this;
    }

    public <T> QueryWrapper ne(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).ne_(value));
        }
        return this;
    }

    public <V> QueryWrapper ne(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).ne_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper ne(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).ne_(value));
        }
        return this;
    }

    public QueryWrapper gt(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).gt(value));
        return this;
    }

    public <T> QueryWrapper gt(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).gt(value));
        return this;
    }

    public QueryWrapper gt(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).gt_(value));
        }
        return this;
    }

    public <T> QueryWrapper gt(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).gt_(value));
        }
        return this;
    }

    public <V> QueryWrapper gt(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).gt_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper gt(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).gt_(value));
        }
        return this;
    }

    public QueryWrapper ge(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).ge(value));
        return this;
    }

    public <T> QueryWrapper ge(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).ge(value));
        return this;
    }

    public QueryWrapper ge(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).ge_(value));
        }
        return this;
    }

    public <T> QueryWrapper ge(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).ge_(value));
        }
        return this;
    }

    public <V> QueryWrapper ge(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).ge_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper ge(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).ge_(value));
        }
        return this;
    }

    public QueryWrapper lt(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).lt(value));
        return this;
    }

    public <T> QueryWrapper lt(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).lt(value));
        return this;
    }

    public QueryWrapper lt(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).lt_(value));
        }
        return this;
    }

    public <T> QueryWrapper lt(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).lt_(value));
        }
        return this;
    }

    public <V> QueryWrapper lt(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).lt_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper lt(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).lt_(value));
        }
        return this;
    }

    public QueryWrapper le(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).le(value));
        return this;
    }

    public <T> QueryWrapper le(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).le(value));
        return this;
    }

    public QueryWrapper le(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).le_(value));
        }
        return this;
    }

    public <T> QueryWrapper le(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).le_(value));
        }
        return this;
    }

    public <V> QueryWrapper le(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).le_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper le(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).le_(value));
        }
        return this;
    }

    public QueryWrapper in(String column, Object ... values) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).in(values));
        return this;
    }

    public <T> QueryWrapper in(LambdaGetter<T> column, Object ... values) {
        this.and(QueryMethods.column(column).in(values));
        return this;
    }

    public QueryWrapper in(String column, QueryWrapper queryWrapper) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).in(queryWrapper));
        return this;
    }

    public <T> QueryWrapper in(LambdaGetter<T> column, QueryWrapper queryWrapper) {
        this.and(QueryMethods.column(column).in(queryWrapper));
        return this;
    }

    public QueryWrapper in(String column, Collection<?> values) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).in(values));
        return this;
    }

    public <T> QueryWrapper in(LambdaGetter<T> column, Collection<?> values) {
        this.and(QueryMethods.column(column).in(values));
        return this;
    }

    public QueryWrapper in(String column, Object[] values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).in_(values));
        }
        return this;
    }

    public <T> QueryWrapper in(LambdaGetter<T> column, Object[] values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).in_(values));
        }
        return this;
    }

    public QueryWrapper in(String column, Collection<?> values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).in_(values));
        }
        return this;
    }

    public <T> QueryWrapper in(LambdaGetter<T> column, Collection<?> values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).in_(values));
        }
        return this;
    }

    public QueryWrapper in(String column, QueryWrapper queryWrapper, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).in_(queryWrapper));
        }
        return this;
    }

    public <T> QueryWrapper in(LambdaGetter<T> column, QueryWrapper queryWrapper, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).in_(queryWrapper));
        }
        return this;
    }

    public QueryWrapper in(String column, QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).in_(queryWrapper));
        }
        return this;
    }

    public <T> QueryWrapper in(LambdaGetter<T> column, QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column(column).in_(queryWrapper));
        }
        return this;
    }

    public QueryWrapper notIn(String column, Object ... values) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notIn(values));
        return this;
    }

    public <T> QueryWrapper notIn(LambdaGetter<T> column, Object ... values) {
        this.and(QueryMethods.column(column).notIn(values));
        return this;
    }

    public QueryWrapper notIn(String column, QueryWrapper queryWrapper) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notIn(queryWrapper));
        return this;
    }

    public <T> QueryWrapper notIn(LambdaGetter<T> column, QueryWrapper queryWrapper) {
        this.and(QueryMethods.column(column).notIn(queryWrapper));
        return this;
    }

    public QueryWrapper notIn(String column, Collection<?> values) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notIn(values));
        return this;
    }

    public <T> QueryWrapper notIn(LambdaGetter<T> column, Collection<?> values) {
        this.and(QueryMethods.column(column).notIn(values));
        return this;
    }

    public QueryWrapper notIn(String column, Object[] values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notIn_(values));
        }
        return this;
    }

    public <T> QueryWrapper notIn(LambdaGetter<T> column, Object[] values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).notIn_(values));
        }
        return this;
    }

    public QueryWrapper notIn(String column, Collection<?> values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notIn_(values));
        }
        return this;
    }

    public <T> QueryWrapper notIn(LambdaGetter<T> column, Collection<?> values, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).notIn_(values));
        }
        return this;
    }

    public QueryWrapper notIn(String column, QueryWrapper queryWrapper, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notIn_(queryWrapper));
        }
        return this;
    }

    public <T> QueryWrapper notIn(LambdaGetter<T> column, QueryWrapper queryWrapper, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).notIn_(queryWrapper));
        }
        return this;
    }

    public QueryWrapper notIn(String column, QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notIn_(queryWrapper));
        }
        return this;
    }

    public <T> QueryWrapper notIn(LambdaGetter<T> column, QueryWrapper queryWrapper, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column(column).notIn_(queryWrapper));
        }
        return this;
    }

    public QueryWrapper between(String column, Object start, Object end) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).between(start, end));
        return this;
    }

    public <T> QueryWrapper between(LambdaGetter<T> column, Object start, Object end) {
        this.and(QueryMethods.column(column).between(start, end));
        return this;
    }

    public QueryWrapper between(String column, Object start, Object end, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).between_(start, end));
        }
        return this;
    }

    public <T> QueryWrapper between(LambdaGetter<T> column, Object start, Object end, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).between_(start, end));
        }
        return this;
    }

    public QueryWrapper between(String column, Object start, Object end, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).between_(start, end));
        }
        return this;
    }

    public <T> QueryWrapper between(LambdaGetter<T> column, Object start, Object end, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column(column).between_(start, end));
        }
        return this;
    }

    public QueryWrapper notBetween(String column, Object start, Object end) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notBetween(start, end));
        return this;
    }

    public <T> QueryWrapper notBetween(LambdaGetter<T> column, Object start, Object end) {
        this.and(QueryMethods.column(column).notBetween(start, end));
        return this;
    }

    public QueryWrapper notBetween(String column, Object start, Object end, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notBetween_(start, end));
        }
        return this;
    }

    public <T> QueryWrapper notBetween(LambdaGetter<T> column, Object start, Object end, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).notBetween_(start, end));
        }
        return this;
    }

    public QueryWrapper notBetween(String column, Object start, Object end, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notBetween_(start, end));
        }
        return this;
    }

    public <T> QueryWrapper notBetween(LambdaGetter<T> column, Object start, Object end, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and(QueryMethods.column(column).notBetween_(start, end));
        }
        return this;
    }

    public QueryWrapper like(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).like(value));
        return this;
    }

    public <T> QueryWrapper like(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).like(value));
        return this;
    }

    public QueryWrapper like(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).like_(value));
        }
        return this;
    }

    public <T> QueryWrapper like(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).like_(value));
        }
        return this;
    }

    public <V> QueryWrapper like(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).like_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper like(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).like_(value));
        }
        return this;
    }

    public QueryWrapper likeLeft(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).likeLeft(value));
        return this;
    }

    public <T> QueryWrapper likeLeft(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).likeLeft(value));
        return this;
    }

    public QueryWrapper likeLeft(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).likeLeft_(value));
        }
        return this;
    }

    public <T> QueryWrapper likeLeft(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).likeLeft_(value));
        }
        return this;
    }

    public <V> QueryWrapper likeLeft(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).likeLeft_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper likeLeft(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).likeLeft_(value));
        }
        return this;
    }

    public QueryWrapper likeRight(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).likeRight(value));
        return this;
    }

    public <T> QueryWrapper likeRight(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).likeRight(value));
        return this;
    }

    public QueryWrapper likeRight(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).likeRight_(value));
        }
        return this;
    }

    public <T> QueryWrapper likeRight(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).likeRight_(value));
        }
        return this;
    }

    public <V> QueryWrapper likeRight(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).likeRight_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper likeRight(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).likeRight_(value));
        }
        return this;
    }

    public QueryWrapper notLike(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLike(value));
        return this;
    }

    public <T> QueryWrapper notLike(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).notLike(value));
        return this;
    }

    public QueryWrapper notLike(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLike_(value));
        }
        return this;
    }

    public <T> QueryWrapper notLike(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).notLike_(value));
        }
        return this;
    }

    public <V> QueryWrapper notLike(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLike_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper notLike(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).notLike_(value));
        }
        return this;
    }

    public QueryWrapper notLikeLeft(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLikeLeft(value));
        return this;
    }

    public <T> QueryWrapper notLikeLeft(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).notLikeLeft(value));
        return this;
    }

    public QueryWrapper notLikeLeft(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLikeLeft_(value));
        }
        return this;
    }

    public <T> QueryWrapper notLikeLeft(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).notLikeLeft_(value));
        }
        return this;
    }

    public <V> QueryWrapper notLikeLeft(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLikeLeft_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper notLikeLeft(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).notLikeLeft_(value));
        }
        return this;
    }

    public QueryWrapper notLikeRight(String column, Object value) {
        this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLikeRight(value));
        return this;
    }

    public <T> QueryWrapper notLikeRight(LambdaGetter<T> column, Object value) {
        this.and(QueryMethods.column(column).notLikeRight(value));
        return this;
    }

    public QueryWrapper notLikeRight(String column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLikeRight_(value));
        }
        return this;
    }

    public <T> QueryWrapper notLikeRight(LambdaGetter<T> column, Object value, boolean isEffective) {
        if (isEffective) {
            this.and(QueryMethods.column(column).notLikeRight_(value));
        }
        return this;
    }

    public <V> QueryWrapper notLikeRight(String column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column((String)column, (Object[])new Object[0]).notLikeRight_(value));
        }
        return this;
    }

    public <T, V> QueryWrapper notLikeRight(LambdaGetter<T> column, V value, Predicate<V> isEffective) {
        if (isEffective.test(value)) {
            this.and(QueryMethods.column(column).notLikeRight_(value));
        }
        return this;
    }

    public QueryWrapper isNull(String column) {
        this.and((QueryCondition)QueryMethods.column((String)column, (Object[])new Object[0]).isNull());
        return this;
    }

    public <T> QueryWrapper isNull(LambdaGetter<T> column) {
        this.and((QueryCondition)QueryMethods.column(column).isNull());
        return this;
    }

    public QueryWrapper isNull(String column, boolean isEffective) {
        if (isEffective) {
            this.and((QueryCondition)QueryMethods.column((String)column, (Object[])new Object[0]).isNull());
        }
        return this;
    }

    public <T> QueryWrapper isNull(LambdaGetter<T> column, boolean isEffective) {
        if (isEffective) {
            this.and((QueryCondition)QueryMethods.column(column).isNull());
        }
        return this;
    }

    public QueryWrapper isNull(String column, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and((QueryCondition)QueryMethods.column((String)column, (Object[])new Object[0]).isNull());
        }
        return this;
    }

    public <T> QueryWrapper isNull(LambdaGetter<T> column, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and((QueryCondition)QueryMethods.column(column).isNull());
        }
        return this;
    }

    public QueryWrapper isNotNull(String column) {
        this.and((QueryCondition)QueryMethods.column((String)column, (Object[])new Object[0]).isNotNull());
        return this;
    }

    public <T> QueryWrapper isNotNull(LambdaGetter<T> column) {
        this.and((QueryCondition)QueryMethods.column(column).isNotNull());
        return this;
    }

    public QueryWrapper isNotNull(String column, boolean isEffective) {
        if (isEffective) {
            this.and((QueryCondition)QueryMethods.column((String)column, (Object[])new Object[0]).isNotNull());
        }
        return this;
    }

    public <T> QueryWrapper isNotNull(LambdaGetter<T> column, boolean isEffective) {
        if (isEffective) {
            this.and((QueryCondition)QueryMethods.column(column).isNotNull());
        }
        return this;
    }

    public QueryWrapper isNotNull(String column, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and((QueryCondition)QueryMethods.column((String)column, (Object[])new Object[0]).isNotNull());
        }
        return this;
    }

    public <T> QueryWrapper isNotNull(LambdaGetter<T> column, BooleanSupplier isEffective) {
        if (isEffective.getAsBoolean()) {
            this.and((QueryCondition)QueryMethods.column(column).isNotNull());
        }
        return this;
    }

    Object[] getAllValueArray() {
        Object[] valueArray;
        Object[] tableValueArray;
        Object[] paramValues;
        ArrayList<Object> withValues = null;
        if (this.with != null && ArrayUtil.isNotEmpty((Object[])(paramValues = this.with.getParamValues()))) {
            withValues = new ArrayList<Object>(Arrays.asList(paramValues));
        }
        ArrayList<Object> columnValues = null;
        List selectColumns = this.getSelectColumns();
        if (CollectionUtil.isNotEmpty((Collection)selectColumns)) {
            for (QueryColumn selectColumn : selectColumns) {
                Object[] paramValues2;
                if (!(selectColumn instanceof HasParamsColumn) || !ArrayUtil.isNotEmpty((Object[])(paramValues2 = ((HasParamsColumn)selectColumn).getParamValues()))) continue;
                if (columnValues == null) {
                    columnValues = new ArrayList<Object>(paramValues2.length);
                }
                columnValues.addAll(Arrays.asList(paramValues2));
            }
        }
        ArrayList<Object> tableValues = null;
        List queryTables = this.getQueryTables();
        if (CollectionUtil.isNotEmpty((Collection)queryTables)) {
            for (QueryTable queryTable : queryTables) {
                tableValueArray = queryTable.getValueArray();
                if (tableValueArray.length <= 0) continue;
                if (tableValues == null) {
                    tableValues = new ArrayList<Object>(tableValueArray.length);
                }
                tableValues.addAll(Arrays.asList(tableValueArray));
            }
        }
        ArrayList<Object> joinValues = null;
        List joins = this.getJoins();
        if (CollectionUtil.isNotEmpty((Collection)joins)) {
            for (Join join : joins) {
                QueryCondition onCondition;
                Object[] values;
                QueryTable joinTable = join.getQueryTable();
                valueArray = joinTable.getValueArray();
                if (valueArray.length > 0) {
                    if (joinValues == null) {
                        joinValues = new ArrayList<Object>(valueArray.length);
                    }
                    joinValues.addAll(Arrays.asList(valueArray));
                }
                if ((values = WrapperUtil.getValues((QueryCondition)(onCondition = join.getOnCondition()))).length <= 0) continue;
                if (joinValues == null) {
                    joinValues = new ArrayList(values.length);
                }
                joinValues.addAll(Arrays.asList(values));
            }
        }
        tableValueArray = WrapperUtil.getValues((QueryCondition)this.whereQueryCondition);
        Object[] havingValues = WrapperUtil.getValues((QueryCondition)this.havingQueryCondition);
        Object[] paramValues3 = ArrayUtil.concat((Object[])tableValueArray, (Object[])havingValues);
        if (CollectionUtil.isNotEmpty((Collection)this.orderBys)) {
            for (QueryOrderBy orderBy : this.orderBys) {
                QueryColumn orderByColumn = orderBy.queryColumn;
                if (orderByColumn == null || !(orderByColumn instanceof HasParamsColumn)) continue;
                paramValues3 = ArrayUtil.concat((Object[])paramValues3, (Object[])((HasParamsColumn)orderByColumn).getParamValues());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)this.unions)) {
            for (UnionWrapper union : this.unions) {
                QueryWrapper queryWrapper = union.getQueryWrapper();
                paramValues3 = ArrayUtil.concat((Object[])paramValues3, (Object[])queryWrapper.getAllValueArray());
            }
        }
        valueArray = withValues == null ? FlexConsts.EMPTY_ARRAY : withValues.toArray();
        valueArray = columnValues != null ? ArrayUtil.concat((Object[])valueArray, (Object[])columnValues.toArray()) : valueArray;
        valueArray = tableValues != null ? ArrayUtil.concat((Object[])valueArray, (Object[])tableValues.toArray()) : valueArray;
        valueArray = joinValues != null ? ArrayUtil.concat((Object[])valueArray, (Object[])joinValues.toArray()) : valueArray;
        valueArray = ArrayUtil.concat((Object[])valueArray, (Object[])paramValues3);
        return valueArray;
    }

    Object[] getJoinValueArray() {
        ArrayList<Object> joinValues = null;
        List joins = this.getJoins();
        if (CollectionUtil.isNotEmpty((Collection)joins)) {
            for (Join join : joins) {
                QueryCondition onCondition;
                Object[] values;
                QueryTable joinTable = join.getQueryTable();
                Object[] valueArray = joinTable.getValueArray();
                if (valueArray.length > 0) {
                    if (joinValues == null) {
                        joinValues = new ArrayList<Object>(valueArray.length);
                    }
                    joinValues.addAll(Arrays.asList(valueArray));
                }
                if ((values = WrapperUtil.getValues((QueryCondition)(onCondition = join.getOnCondition()))).length <= 0) continue;
                if (joinValues == null) {
                    joinValues = new ArrayList(values.length);
                }
                joinValues.addAll(Arrays.asList(values));
            }
        }
        return joinValues == null ? FlexConsts.EMPTY_ARRAY : joinValues.toArray();
    }

    Object[] getConditionValueArray() {
        Object[] whereValues = WrapperUtil.getValues((QueryCondition)this.whereQueryCondition);
        Object[] havingValues = WrapperUtil.getValues((QueryCondition)this.havingQueryCondition);
        Object[] paramValues = ArrayUtil.concat((Object[])whereValues, (Object[])havingValues);
        if (CollectionUtil.isNotEmpty((Collection)this.unions)) {
            for (UnionWrapper union : this.unions) {
                QueryWrapper queryWrapper = union.getQueryWrapper();
                paramValues = ArrayUtil.concat((Object[])paramValues, (Object[])queryWrapper.getAllValueArray());
            }
        }
        return paramValues;
    }

    List<QueryWrapper> getChildSelect() {
        ArrayList<QueryWrapper> tableChildQuery = null;
        List queryTables = this.getQueryTables();
        if (CollectionUtil.isNotEmpty((Collection)queryTables)) {
            for (QueryTable queryTable : queryTables) {
                if (!(queryTable instanceof SelectQueryTable)) continue;
                if (tableChildQuery == null) {
                    tableChildQuery = new ArrayList<QueryWrapper>();
                }
                tableChildQuery.add(((SelectQueryTable)queryTable).getQueryWrapper());
            }
        }
        List whereChildQuery = WrapperUtil.getChildQueryWrapper((QueryCondition)this.whereQueryCondition);
        List havingChildQuery = WrapperUtil.getChildQueryWrapper((QueryCondition)this.havingQueryCondition);
        if (tableChildQuery == null && whereChildQuery.isEmpty() && havingChildQuery.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueryWrapper> childQueryWrappers = tableChildQuery == null ? new ArrayList<QueryWrapper>() : new ArrayList(tableChildQuery);
        childQueryWrappers.addAll(whereChildQuery);
        childQueryWrappers.addAll(havingChildQuery);
        return childQueryWrappers;
    }

    public String toSQL() {
        String sql = DialectFactory.getDialect().forSelectByQuery(this);
        return SqlUtil.replaceSqlParams((String)sql, (Object[])this.getAllValueArray());
    }

    public QueryWrapper clone() {
        return (QueryWrapper)super.clone();
    }

    public void clearOrderBy() {
        this.setOrderBys(new LinkedList());
    }
}

