/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.config.IFrameProperties;
import com.kdgcsoft.web.core.entity.BaseJob;
import com.kdgcsoft.web.core.enums.JobStatus;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.exception.BusinessException;
import com.kdgcsoft.web.core.job.IJob;
import com.kdgcsoft.web.core.mapper.BaseJobMapper;
import com.kdgcsoft.web.core.service.BaseJobLogService;
import com.kdgcsoft.web.core.util.AopTargetUtils;
import com.kdgcsoft.web.core.util.ScheduleUtils;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseJobService
extends ServiceImpl<BaseJobMapper, BaseJob> {
    private static final Logger log = LoggerFactory.getLogger(BaseJobService.class);
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private BaseJobLogService jobLogService;
    @Autowired
    private IFrameProperties iFrameProperties;

    @PostConstruct
    public void init() {
        try {
            if (this.iFrameProperties.isEnableQuartz()) {
                List scheduleJobList = this.list();
                for (BaseJob scheduleJob : scheduleJobList) {
                    CronTrigger cronTrigger = ScheduleUtils.getCronTrigger(this.scheduler, scheduleJob.getJobId());
                    if (cronTrigger == null) {
                        ScheduleUtils.createScheduleJob(this.scheduler, scheduleJob);
                        continue;
                    }
                    ScheduleUtils.updateScheduleJob(this.scheduler, scheduleJob);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5931\u8d25,\u8bf7\u68c0\u67e5\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u4fe1\u606f", (Throwable)e);
        }
    }

    public Page<BaseJob> pageJob(PageRequest<BaseJob> pageRequest, JobStatus jobStatus, String search) {
        QueryWrapper queryWrapper = QueryWrapper.create().eq(BaseJob::getJobStatus, (Object)jobStatus).like(BaseJob::getJobName, (Object)search).orderBy(BaseJob::getJobId, (Boolean)false);
        return ((BaseJobMapper)this.getMapper()).paginate(pageRequest, queryWrapper);
    }

    public List<JSONObject> getJavaClasses() {
        Map map = SpringUtil.getBeansOfType(IJob.class);
        ArrayList<JSONObject> classes = new ArrayList<JSONObject>();
        if (CollUtil.isNotEmpty((Map)map)) {
            map.values().forEach(v -> {
                try {
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"name", (Object)v.name());
                    obj.put((Object)"class", (Object)AopTargetUtils.getTarget(v).getClass().getName());
                    classes.add(obj);
                    log.info(AopTargetUtils.getTarget(v).getClass().getName());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return classes;
    }

    public BaseJob changeJobStatus(String jobId) {
        BaseJob job = this.ensureJobExists(jobId);
        JobStatus oldJobStatus = job.getJobStatus();
        if (oldJobStatus == JobStatus.RUN) {
            ScheduleUtils.pauseJob(this.scheduler, jobId);
            job.setJobStatus(JobStatus.PAUSE);
        } else {
            ScheduleUtils.resumeJob(this.scheduler, jobId);
            job.setJobStatus(JobStatus.RUN);
        }
        this.saveOrUpdate(job);
        return job;
    }

    private BaseJob ensureJobExists(String jobId) {
        BaseJob job = (BaseJob)this.getById((Serializable)((Object)jobId));
        if (null == job) {
            throw new BusinessException("jobId:" + jobId + "\u4e0d\u5b58\u5728", new Object[0]);
        }
        return job;
    }

    public void changeJobEnabled(String jobId) {
        BaseJob job = this.ensureJobExists(jobId);
        if (job.getEnabled() == YesNo.Y) {
            if (job.getJobStatus() == JobStatus.RUN) {
                throw new BusinessException("\u4efb\u52a1\u5904\u4e8e\u8fd0\u884c\u72b6\u6001\uff0c\u8bf7\u5148\u505c\u6b62\u4efb\u52a1\u518d\u8fdb\u884c\u64cd\u4f5c", new Object[0]);
            }
            job.setEnabled(YesNo.N);
        } else {
            job.setEnabled(YesNo.Y);
        }
        this.saveOrUpdate(job);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveJob(BaseJob job) {
        boolean isNew = job.getJobId() == null;
        this.saveOrUpdate(job);
        if (isNew) {
            ScheduleUtils.createScheduleJob(this.scheduler, job);
        } else {
            ScheduleUtils.updateScheduleJob(this.scheduler, job);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(BaseJob scheduleJob) {
        ScheduleUtils.updateScheduleJob(this.scheduler, scheduleJob);
        this.save(scheduleJob);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String jobId) {
        BaseJob job = this.ensureJobExists(jobId);
        if (job.getJobStatus() == JobStatus.RUN) {
            throw new BusinessException("\u4efb\u52a1\u5904\u4e8e\u8fd0\u884c\u72b6\u6001\uff0c\u8bf7\u5148\u505c\u6b62\u4efb\u52a1\u518d\u8fdb\u884c\u64cd\u4f5c", new Object[0]);
        }
        ScheduleUtils.deleteScheduleJob(this.scheduler, jobId);
        ((BaseJobMapper)this.getMapper()).deleteById((Serializable)((Object)jobId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void clearLog(String jobid, Integer daysbefore) {
        Date datebefore = new Date();
        if (daysbefore != null) {
            datebefore = DateUtil.offsetDay((Date)new Date(), (int)(-daysbefore.intValue())).toJdkDate();
        }
        this.jobLogService.clearLog(jobid, datebefore);
    }

    public void executeOnce(String jobId) {
        this.ensureJobExists(jobId);
        ScheduleUtils.run(this.scheduler, (BaseJob)this.getById((Serializable)((Object)jobId)));
    }
}

