/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.config.security.SecurityUtil;
import com.kdgcsoft.web.core.entity.BaseFile;
import com.kdgcsoft.web.core.entity.table.BaseFileTableDef;
import com.kdgcsoft.web.core.exception.BusinessException;
import com.kdgcsoft.web.core.mapper.BaseFileMapper;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BaseFileService
extends ServiceImpl<BaseFileMapper, BaseFile> {
    private static final Logger log = LoggerFactory.getLogger(BaseFileService.class);
    @Autowired
    FileStorageService fileStorageService;

    public BaseFile findByUrl(String url) {
        return (BaseFile)this.getOne(QueryWrapper.create().from(new QueryTable[]{BaseFileTableDef.BASE_FILE}).where(BaseFileTableDef.BASE_FILE.URL.eq((Object)url)));
    }

    public BaseFile findByFileName(String fileName) {
        return (BaseFile)this.getOne(QueryWrapper.create().from(new QueryTable[]{BaseFileTableDef.BASE_FILE}).where(BaseFileTableDef.BASE_FILE.FILE_NAME.eq((Object)fileName)));
    }

    public FileInfo upload(MultipartFile file, String fileId, Map<String, String> metadata) {
        String path = DateUtil.format((Date)new DateTime(), (String)"yyyyMM");
        String fileNamePrefix = DateUtil.format((Date)new DateTime(), (String)"yyyyMMddHHmmssSSS");
        String originalFilename = FileNameUtil.cleanInvalid((String)file.getOriginalFilename());
        String fileName = StrUtil.format((CharSequence)"{}_{}.{}", (Object[])new Object[]{fileNamePrefix, FileUtil.mainName((String)originalFilename), FileUtil.extName((String)originalFilename)});
        FileInfo fileInfo = this.fileStorageService.of((Object)file).setName(originalFilename).setSaveFilename(fileName).setPath(path + "/").setHashCalculatorMd5().upload();
        BaseFile baseFile = BaseFile.of(fileInfo, metadata);
        if (StrUtil.isNotBlank((CharSequence)fileId)) {
            baseFile.setId(fileId);
        }
        baseFile.setUploadBy(SecurityUtil.getUserId());
        baseFile.setUploadTime((Date)DateTime.now());
        this.saveOrUpdate(baseFile);
        fileInfo.setId(baseFile.getId());
        return fileInfo;
    }

    public void download(String fileId, String url, HttpServletResponse resp) {
        FileInfo fileInfo;
        if (fileId != null) {
            BaseFile baseFile = (BaseFile)this.getById((Serializable)((Object)fileId));
            Assert.notNull((Object)baseFile, (String)"\u6587\u4ef6{}\u4e0d\u5b58\u5728.", (Object[])new Object[]{fileId});
            fileInfo = baseFile.toFileInfo();
        } else {
            BaseFile baseFile = this.findByUrl(url);
            fileInfo = baseFile.toFileInfo();
            boolean exists = this.fileStorageService.exists(fileInfo);
            Assert.isTrue((boolean)exists, (String)"\u6587\u4ef6{}\u4e0d\u5b58\u5728", (Object[])new Object[]{url});
        }
        try {
            resp.reset();
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileInfo.getOriginalFilename(), StandardCharsets.UTF_8.name()));
            resp.addHeader("Content-Length", "" + fileInfo.getSize());
            resp.setContentType("application/octet-stream");
            this.fileStorageService.download(fileInfo).outputStream((OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void downloadByFileName(String fileName, HttpServletResponse resp) {
        BaseFile baseFile = this.findByFileName(fileName);
        Assert.notNull((Object)baseFile, (String)"\u6587\u4ef6\u8bb0\u5f55[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{fileName});
        FileInfo fileInfo = baseFile.toFileInfo();
        boolean exists = this.fileStorageService.exists(fileInfo);
        Assert.isTrue((boolean)exists, (String)"\u6587\u4ef6[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{fileName});
        try {
            resp.reset();
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileInfo.getOriginalFilename(), StandardCharsets.UTF_8.name()));
            resp.addHeader("Content-Length", "" + fileInfo.getSize());
            MediaType mediaType = MediaTypeFactory.getMediaType((String)fileInfo.getOriginalFilename()).orElse(MediaType.APPLICATION_OCTET_STREAM);
            resp.setContentType(mediaType.getType());
            this.fileStorageService.download(fileInfo).outputStream((OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void deleteByFileName(String fileName) {
        try {
            BaseFile baseFile = this.findByFileName(fileName);
            if (baseFile != null) {
                FileInfo fileInfo = baseFile.toFileInfo();
                this.fileStorageService.delete(fileInfo);
                this.removeById(baseFile);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }
}

