/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.config.security.interfaces.AuthUser;
import com.kdgcsoft.web.config.security.interfaces.AuthUserInfo;
import com.kdgcsoft.web.config.security.interfaces.IAuthService;
import com.kdgcsoft.web.config.security.interfaces.LoginParams;
import com.kdgcsoft.web.config.security.interfaces.LoginType;
import com.kdgcsoft.web.config.security.user.BaseAuthUserInfo;
import com.kdgcsoft.web.core.entity.BaseUser;
import com.kdgcsoft.web.core.pojo.BaseAuthUser;
import com.kdgcsoft.web.core.service.BaseMenuService;
import com.kdgcsoft.web.core.service.BaseUserService;
import com.kdgcsoft.web.core.util.CryptoUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class BaseAuthService
implements IAuthService {
    @Resource
    BaseUserService baseUserService;
    @Resource
    BaseMenuService baseMenuService;

    @Override
    public LoginType[] supportedLoginTypes() {
        return new LoginType[]{LoginType.ACCOUNT, LoginType.PHONE, LoginType.EMAIL, LoginType.API_KEY, LoginType.SSO_ACCOUNT, LoginType.SSO_USERID, LoginType.SSO_EMP_NO};
    }

    @Override
    public List<? extends AuthUser> auth(LoginParams loginParams) {
        ArrayList authUsers = new ArrayList();
        List<Object> userList = new ArrayList();
        switch (loginParams.getType()) {
            case ACCOUNT: {
                if (!StrUtil.isNotBlank((CharSequence)loginParams.getAccount())) break;
                String decryptPassword = CryptoUtil.decryptFrontData(loginParams.getPassword());
                String userCredential = CryptoUtil.encryptPassword(decryptPassword);
                List<BaseUser> accounts = this.baseUserService.listByAccount(loginParams.getAccount());
                List matchedAccounts = accounts.stream().filter(baseAccount -> StrUtil.equals((CharSequence)baseAccount.getCredential(), (CharSequence)userCredential) && (StrUtil.isBlank((CharSequence)loginParams.getUserId()) || StrUtil.equals((CharSequence)loginParams.getUserId(), (CharSequence)baseAccount.getUserId()))).collect(Collectors.toList());
                userList.addAll(matchedAccounts);
                break;
            }
            case SSO_USERID: {
                BaseUser baseUser = this.baseUserService.findByUserId(loginParams.getSsoCode());
                userList.add(baseUser);
                break;
            }
            case SSO_ACCOUNT: {
                userList = this.baseUserService.listByAccount(loginParams.getSsoCode());
                break;
            }
            case SSO_EMP_NO: {
                userList = this.baseUserService.listByEmpNo(loginParams.getSsoCode());
                break;
            }
        }
        userList.forEach(user -> {
            BaseAuthUser authUser = (BaseAuthUser)BeanUtil.toBean((Object)user, BaseAuthUser.class);
            authUser.setAuthClass(BaseAuthService.class);
            authUser.setAccountType(AuthUser.AccountType.USER);
            authUsers.add(authUser);
        });
        return authUsers;
    }

    @Override
    public AuthUserInfo getAuthUserInfo(AuthUser authUser) {
        BaseAuthUserInfo baseAuthUserInfo = new BaseAuthUserInfo();
        baseAuthUserInfo.setAuthUser(authUser);
        baseAuthUserInfo.setMenus(this.baseMenuService.userMenuTree(authUser));
        return baseAuthUserInfo;
    }
}

