/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.controller;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.exception.BusinessException;
import com.kdgcsoft.web.core.util.MimeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.ModelAndView;

public class BaseController {
    public static final String LOGIN = "/login";
    public static final String LOGOUT = "/logout";
    public static final String SAVE = "/save";
    public static final String IMPORT = "/import";
    public static final String EXPORT = "/export";
    public static final String INSERT = "/insert";
    public static final String UPDATE = "/update";
    public static final String PAGE = "/page";
    public static final String LIST = "/list";
    public static final String TREE = "/tree";
    public static final String TRANS = "/trans";
    public static final String GET_BY_ID = "/getById";
    public static final String UPDATE_BY_ID = "/updateById";
    public static final String GET_BY_CODE = "/getByCode";
    public static final String DEL_BY_ID = "/deleteById";
    public static final String DEL_BY_IDS = "/deleteByIds";
    public static final String DEL_BY_CODE = "/deleteByCode";
    @Autowired
    public HttpServletRequest request;
    @Autowired
    public HttpServletResponse response;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.setAutoGrowCollectionLimit(10000);
    }

    public HttpHeaders buildDownloadHeader(String fileName) {
        HttpHeaders headers = new HttpHeaders();
        try {
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()) + "\"");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
        }
        catch (Exception e) {
            throw new BusinessException("headers\u6784\u5efa\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e, new Object[0]);
        }
        return headers;
    }

    public ResponseEntity<FileSystemResource> renderFile(File file) {
        if (file == null) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(file.getName()))).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new FileSystemResource(file));
    }

    public ResponseEntity<InputStreamResource> renderFile(InputStream inputStream, String fileName, long size) {
        if (inputStream == null) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(fileName))).contentLength(size).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new InputStreamResource(inputStream));
    }

    public ResponseEntity<FileSystemResource> renderFile(File file, String fileType) {
        if (file == null) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(file.getName()))).contentLength(file.length()).contentType(MediaType.parseMediaType((String)fileType)).body((Object)new FileSystemResource(file));
    }

    public ResponseEntity<ByteArrayResource> renderFile(byte[] bytes, String fileType, String fileName) {
        if (bytes.length < 1) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(fileName))).contentLength((long)bytes.length).contentType(StrUtil.isNotEmpty((CharSequence)fileType) ? MediaType.parseMediaType((String)fileType) : MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new ByteArrayResource(bytes));
    }

    public ResponseEntity<ByteArrayResource> renderFile(byte[] bytes, String fileName) {
        if (bytes.length < 1) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.buildDownloadHeader(fileName))).contentLength((long)bytes.length).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new ByteArrayResource(bytes));
    }

    public void renderImage(byte[] bytes, String imageName) {
        String contentType = MimeUtil.getMimeType(imageName);
        this.response.setContentType(contentType);
        ServletOutputStream os = null;
        try {
            os = this.response.getOutputStream();
            os.write(bytes);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ModelAndView view(String viewname) {
        return this.view(viewname, null);
    }

    public ModelAndView view(String viewname, Map<String, Object> modelMap) {
        ModelAndView view = new ModelAndView();
        view.setViewName(viewname);
        view.addAllObjects(modelMap);
        return view;
    }

    public ModelAndView view(ModelAndView view, Map<String, Object> modelMap) {
        view.addAllObjects(modelMap);
        return view;
    }
}

