/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.aspect;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson2.JSON;
import com.kdgcsoft.web.config.security.SecurityUtil;
import com.kdgcsoft.web.config.security.interfaces.AuthUser;
import com.kdgcsoft.web.config.security.interfaces.AuthUserInfo;
import com.kdgcsoft.web.core.anno.AuditLog;
import com.kdgcsoft.web.core.aspect.AuditLogEvent;
import com.kdgcsoft.web.core.entity.BaseAuditLog;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.util.ServletContextUtil;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

public class AuditLogHandler {
    private static final Logger log = LoggerFactory.getLogger(AuditLogHandler.class);
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final StandardEvaluationContext context = new StandardEvaluationContext();
    private final ProceedingJoinPoint joinPoint;
    private final TimeInterval timeInterval = new TimeInterval();
    private AuditLog logAnno;
    private Method method;
    private BaseAuditLog baseAuditLog;

    public AuditLogHandler(ProceedingJoinPoint joinPoint) {
        this.joinPoint = joinPoint;
        this.timeInterval.start();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        this.method = methodSignature.getMethod();
        this.logAnno = this.method.getAnnotation(AuditLog.class);
        this.baseAuditLog = new BaseAuditLog();
    }

    public void begin() {
        try {
            if (this.logAnno == null) {
                return;
            }
            Map<String, Object> paramsMap = this.buildParamsMap(this.method, this.joinPoint);
            this.context.setVariable("request", paramsMap);
            this.context.setVariable("LOGIN_USER", (Object)SecurityUtil.getUser());
            this.baseAuditLog.setLogTime((Date)DateTime.now());
            this.baseAuditLog.setLogType(this.logAnno.type());
            if (this.isSpelExpression(this.logAnno.title())) {
                this.baseAuditLog.setTitle((String)PARSER.parseExpression(this.logAnno.title()).getValue((EvaluationContext)this.context, String.class));
            } else {
                this.baseAuditLog.setTitle(this.logAnno.title());
            }
            this.baseAuditLog.setUserId(SecurityUtil.getUserIdWithDefault());
            this.baseAuditLog.setJavaMethod(this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName());
            HttpServletRequest request = ServletContextUtil.getRequest();
            if (request != null) {
                this.baseAuditLog.setLogIp(ServletContextUtil.getClientIp());
                this.baseAuditLog.setRequestUrl(request.getRequestURI());
                this.baseAuditLog.setHttpMethod(request.getMethod());
            }
            if (this.logAnno.request()) {
                HashMap<String, Object> logParams = new HashMap<String, Object>();
                for (String key : paramsMap.keySet()) {
                    Object value = paramsMap.get(key);
                    if (value instanceof HttpServletRequest || value instanceof HttpServletResponse || value instanceof Model || value instanceof AuthUser || value instanceof AuthUserInfo) continue;
                    if (value instanceof MultipartFile) {
                        MultipartFile file = (MultipartFile)value;
                        logParams.put(key, file.getName());
                        continue;
                    }
                    logParams.put(key, value);
                }
                this.baseAuditLog.setRequestContent(JSON.toJSONString(logParams));
            }
        }
        catch (Exception e) {
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u8bb0\u5f55\u51fa\u9519:", (Throwable)e);
        }
    }

    public void end(Object result) {
        try {
            this.baseAuditLog.setSuccess(YesNo.Y);
            this.baseAuditLog.setTimeCost(this.timeInterval.interval());
            if (this.logAnno.response() && result != null) {
                if (result instanceof ModelAndView) {
                    this.baseAuditLog.setResponseContent("ModelAndView(" + ((ModelAndView)result).getViewName() + ")");
                } else if (result instanceof Throwable) {
                    Throwable throwable = (Throwable)result;
                    this.baseAuditLog.setResponseContent(throwable.getClass().getSimpleName() + ":" + throwable.getMessage());
                } else if (result instanceof ResponseEntity) {
                    ResponseEntity re = (ResponseEntity)result;
                    if (re.getBody() instanceof ByteArrayResource) {
                        this.baseAuditLog.setRequestContent("[\u5b57\u8282\u6570\u636e]");
                    } else {
                        this.baseAuditLog.setResponseContent(StrUtil.maxLength((CharSequence)JSON.toJSONString((Object)result), (int)2000));
                    }
                } else {
                    this.baseAuditLog.setResponseContent(StrUtil.maxLength((CharSequence)JSON.toJSONString((Object)result), (int)2000));
                }
            }
        }
        catch (Exception e) {
            this.baseAuditLog.setResponseContent(e.getMessage());
            log.error("\u5ba1\u8ba1\u65e5\u5fd7\u8bb0\u5f55\u89e3\u6790\u51fa\u9519:", (Throwable)e);
        }
        this.sendAuditLog();
    }

    public void end(Exception exception) {
        try {
            this.baseAuditLog.setSuccess(YesNo.N);
            this.baseAuditLog.setTimeCost(this.timeInterval.interval());
            this.baseAuditLog.setResponseContent(exception.getMessage());
        }
        catch (Exception e) {
            this.baseAuditLog.setResponseContent(e.getMessage());
        }
        this.sendAuditLog();
    }

    public void sendAuditLog() {
        SpringUtil.publishEvent((ApplicationEvent)new AuditLogEvent(this.baseAuditLog));
    }

    public Map<String, Object> buildParamsMap(Method method, ProceedingJoinPoint joinPoint) {
        Object[] names = PARAMETER_NAME_DISCOVERER.getParameterNames(method);
        HashMap paramsMap = MapUtil.newHashMap();
        if (ArrayUtil.isNotEmpty((Object[])names)) {
            for (int i = 0; i < names.length; ++i) {
                Object arg = joinPoint.getArgs()[i];
                paramsMap.put(names[i], arg);
            }
        }
        return paramsMap;
    }

    public boolean isSpelExpression(String expression) {
        try {
            return StrUtil.contains((CharSequence)expression, (CharSequence)"${");
        }
        catch (Exception e) {
            return false;
        }
    }
}

