/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.config.mvc.resolver;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class PageRequest<T>
extends Page<T> {
    public static final Long DEFAULT_SIZE = 20L;
    public static final String CURRENT_PAGE = "_pageNumber";
    public static final String PAGE_SIZE = "_pageSize";
    public static final String SORTS = "_sorts";
    public static final String ORDERS = "_orders";
    private boolean hasPage = false;
    private List<OrderItem> sorts = new ArrayList<OrderItem>();

    public PageRequest(Number pageNumber, Number pageSize) {
        super(pageNumber, pageSize);
    }

    public static <T> PageRequest<T> empty() {
        return new PageRequest<T>(1L, DEFAULT_SIZE);
    }

    public static <T> PageRequest<T> of(Number pageNumber, Number pageSize) {
        return new PageRequest<T>(pageNumber, pageSize);
    }

    public Long getStartIndex() {
        return (this.getPageNumber() - 1L) * this.getPageSize();
    }

    public void buildSorts(String sortFields, String orders) {
        if (StrUtil.isNotBlank((CharSequence)sortFields) && StrUtil.isNotBlank((CharSequence)orders)) {
            List fieldList = StrUtil.split((CharSequence)sortFields, (char)',');
            final List orderList = StrUtil.split((CharSequence)orders, (char)',');
            CollUtil.forEach((Iterable)fieldList, (CollUtil.Consumer)new CollUtil.Consumer<String>(){

                public void accept(String field, int index) {
                    String order = (String)CollUtil.get((Collection)orderList, (int)index);
                    PageRequest.this.addSortItem(field, order);
                }
            });
        }
    }

    public boolean hasSorts() {
        return !CollUtil.isEmpty(this.sorts);
    }

    public void addSortItem(String field, String order) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<OrderItem>();
        }
        if (StrUtil.isNotBlank((CharSequence)field) && StrUtil.isNotBlank((CharSequence)order)) {
            OrderItem orderItem = new OrderItem();
            orderItem.setField(field);
            orderItem.setAsc(StrUtil.equalsIgnoreCase((CharSequence)order, (CharSequence)"asc"));
            this.sorts.add(orderItem);
        }
    }

    public void appendSortsToWrapper(QueryWrapper queryWrapper, Function<OrderItem, String> fieldNameFunc) {
        if (this.hasSorts()) {
            this.getSorts().forEach(item -> {
                if (fieldNameFunc == null) {
                    queryWrapper.orderBy(item.getField(true), (Boolean)item.isAsc());
                } else {
                    queryWrapper.orderBy((String)fieldNameFunc.apply((OrderItem)item), (Boolean)item.isAsc());
                }
            });
        }
    }

    public void appendSortsToWrapper(QueryWrapper queryWrapper) {
        this.appendSortsToWrapper(queryWrapper, null);
    }

    public boolean isHasPage() {
        return this.hasPage;
    }

    public List<OrderItem> getSorts() {
        return this.sorts;
    }

    public void setHasPage(boolean hasPage) {
        this.hasPage = hasPage;
    }

    public void setSorts(List<OrderItem> sorts) {
        this.sorts = sorts;
    }

    public static class OrderItem {
        private String field;
        private boolean asc = true;

        public String getField(boolean underline) {
            return underline ? StrUtil.toUnderlineCase((CharSequence)this.field) : this.field;
        }

        public String getField() {
            return this.field;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setAsc(boolean asc) {
            this.asc = asc;
        }
    }
}

