/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fhs.trans.service.impl.DictionaryTransService;
import com.kdgcsoft.web.core.anno.EnumDict;
import com.kdgcsoft.web.core.anno.EnumParam;
import com.kdgcsoft.web.core.anno.EnumParamGroup;
import com.kdgcsoft.web.core.entity.BaseDict;
import com.kdgcsoft.web.core.entity.BaseParam;
import com.kdgcsoft.web.core.pojo.ScannedDict;
import com.kdgcsoft.web.core.service.BaseDictService;
import com.kdgcsoft.web.core.service.BaseParamService;
import com.mybatisflex.annotation.EnumValue;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInitializationManager {
    private static final Logger log = LoggerFactory.getLogger(WebInitializationManager.class);
    private final TimeInterval timer = new TimeInterval();
    private final BaseDictService dictService = (BaseDictService)((Object)SpringUtil.getBean(BaseDictService.class));
    private final BaseParamService paramService = (BaseParamService)((Object)SpringUtil.getBean(BaseParamService.class));
    private final DictionaryTransService dictionaryTransService = (DictionaryTransService)SpringUtil.getBean(DictionaryTransService.class);

    public WebInitializationManager() {
        this.init();
    }

    private void init() {
        log.info("\u5f00\u59cb\u8fdb\u884c\u5185\u7f6e\u6570\u636e\u540c\u6b65.");
        this.scanEnumDicts();
        this.scanEnumParams();
        log.info("\u5185\u7f6e\u6570\u636e\u540c\u6b65\u5b8c\u6210.");
    }

    private void scanEnumParams() {
        log.info("\u540c\u6b65\u5185\u7f6e\u53c2\u6570\u4e2d...");
        ArrayList scannedList = new ArrayList();
        HashMap scannedParamMap = new HashMap();
        ClassUtil.scanPackageByAnnotation((String)"com.kdgcsoft", EnumParamGroup.class).forEach(cls -> {
            if (cls.isEnum()) {
                EnumParamGroup groupAnno = cls.getAnnotation(EnumParamGroup.class);
                for (Field field : cls.getDeclaredFields()) {
                    EnumParam paramAnno = field.getAnnotation(EnumParam.class);
                    if (paramAnno == null) continue;
                    if (scannedParamMap.containsKey(field.getName())) {
                        log.error("\u53c2\u6570\u7f16\u7801[{}]\u5df2\u5b58\u5728{},\u672c\u5b57\u5178{}\u5c06\u4e0d\u4f1a\u52a0\u8f7d", new Object[]{field.getName(), scannedParamMap.get(field.getName()), cls.getName() + "." + field.getName()});
                        return;
                    }
                    BaseParam scannedParam = BaseParam.buildByAnno(groupAnno, paramAnno, field.getName());
                    scannedList.add(scannedParam);
                    scannedParamMap.put(scannedParam.getParamCode(), scannedParam.getParamName());
                }
            }
        });
        List paramList = this.paramService.list();
        ArrayList updateList = new ArrayList();
        scannedList.forEach(scanParam -> {
            BaseParam dbParam = (BaseParam)CollUtil.findOne((Iterable)paramList, coreParam -> scanParam.getParamCode().equals(coreParam.getParamCode()));
            if (dbParam == null) {
                scanParam.setParamValue(scanParam.getDefValue());
                updateList.add(scanParam);
            } else if (!dbParam.equalToScanned((BaseParam)scanParam)) {
                dbParam.updateByScanned((BaseParam)scanParam);
                updateList.add(dbParam);
            }
        });
        this.paramService.saveOrUpdateBatch(updateList);
    }

    private void scanEnumDicts() {
        log.info("\u540c\u6b65\u5185\u7f6e\u5b57\u5178\u4e2d...");
        ArrayList scannedDictList = new ArrayList();
        HashMap scannedDictMap = new HashMap();
        ClassUtil.scanPackageByAnnotation((String)"com.kdgcsoft", EnumDict.class).forEach(cls -> {
            if (cls.isEnum()) {
                EnumDict anno = cls.getAnnotation(EnumDict.class);
                ScannedDict scannedDict = new ScannedDict();
                String code = cls.getSimpleName();
                if (scannedDictMap.containsKey(code)) {
                    log.error("\u5b57\u5178\u7f16\u7801[{}]\u5df2\u5b58\u5728{},\u672c\u5b57\u5178{}\u5c06\u4e0d\u4f1a\u52a0\u8f7d", new Object[]{code, scannedDictMap.get(code), cls.getName()});
                    return;
                }
                String name = anno.value();
                String description = StrUtil.isEmpty((CharSequence)anno.description()) ? cls.getName() : anno.description();
                scannedDict.setCode(code).setName(name).setDescription(description);
                String textField = anno.textField();
                for (Object o : cls.getEnumConstants()) {
                    Field[] fields;
                    Enum e = (Enum)o;
                    String itemValue = e.name();
                    String itemText = e.name();
                    Integer itemOrder = e.ordinal();
                    if (ReflectUtil.hasField(e.getClass(), (String)textField)) {
                        itemText = Convert.toStr((Object)ReflectUtil.getFieldValue((Object)e, (String)textField));
                    }
                    for (Field field : fields = ReflectUtil.getFields(e.getClass())) {
                        if (!field.isAnnotationPresent(EnumValue.class)) continue;
                        itemValue = Convert.toStr((Object)ReflectUtil.getFieldValue((Object)e, (String)field.getName()));
                        break;
                    }
                    scannedDict.addItem(itemValue, itemText, itemOrder);
                }
                scannedDictMap.put(code, cls.getName());
                scannedDictList.add(scannedDict);
            }
        });
        List<BaseDict> dictList = this.dictService.listEmbedDicts();
        ArrayList updateList = new ArrayList();
        scannedDictList.forEach(scannedDict -> {
            BaseDict dbDict = (BaseDict)CollUtil.findOne((Iterable)dictList, coreDict -> scannedDict.getCode().equals(coreDict.getDictCode()));
            if (dbDict == null) {
                dbDict = BaseDict.buildWith(scannedDict);
                updateList.add(dbDict);
                dictList.add(dbDict);
            } else if (!dbDict.equalTo((ScannedDict)scannedDict)) {
                dbDict.updateByScannedDict((ScannedDict)scannedDict);
                updateList.add(dbDict);
            }
        });
        updateList.forEach(this.dictService::saveEmbedDict);
        List<BaseDict> allDictList = this.dictService.allDictList();
        allDictList.forEach(dict -> {
            HashMap itemMap = new HashMap();
            CollUtil.forEach(dict.getItems(), (CollUtil.Consumer & Serializable)(item, index) -> itemMap.put(item.getValue(), item.getLabel()));
            this.dictionaryTransService.refreshCache(dict.getDictCode(), itemMap);
        });
    }
}

