/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.controller.params.SyncModelParam;
import com.kdgcsoft.web.ac.entity.AcModel;
import com.kdgcsoft.web.ac.entity.AcModelField;
import com.kdgcsoft.web.ac.entity.AcModelSyncHis;
import com.kdgcsoft.web.ac.enums.SyncMessageLevel;
import com.kdgcsoft.web.ac.enums.SyncStatus;
import com.kdgcsoft.web.ac.enums.SyncType;
import com.kdgcsoft.web.ac.enums.dict.ModelSyncStatus;
import com.kdgcsoft.web.ac.enums.dict.ModelType;
import com.kdgcsoft.web.ac.mapper.AcModelSyncHisMapper;
import com.kdgcsoft.web.ac.service.AcModelFieldService;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.kdgcsoft.web.ac.service.AcModelSyncInterceptor;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.exception.BusinessException;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.proxy.ServiceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AcModelSyncHisService
extends ServiceImpl<AcModelSyncHisMapper, AcModelSyncHis> {
    private static final Logger log = LoggerFactory.getLogger(AcModelSyncHisService.class);
    @Resource
    AcModelService modelService;
    private final Map<String, SyncModelParam> syncStatusMap = new ConcurrentHashMap<String, SyncModelParam>();
    @Autowired
    private AcModelFieldService modelFieldService;
    @Autowired
    private AcModelSyncInterceptor syncInterceptor;

    public AcModel getLastSyncModel(String modelCode) {
        return null;
    }

    public SyncModelParam syncModels(SyncModelParam syncModelParam) {
        Assert.notEmpty(syncModelParam.getModelIds(), (String)"\u540c\u6b65\u7684\u6a21\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)syncModelParam.getSyncType()), (String)"\u8bf7\u9009\u62e9\u540c\u6b65\u6a21\u5f0f", (Object[])new Object[0]);
        syncModelParam.initStatus();
        this.syncStatusMap.put(syncModelParam.getSyncId(), syncModelParam);
        ThreadUtil.execAsync(() -> this.syncModelsByThread(syncModelParam));
        return syncModelParam;
    }

    public void syncModelsByThread(SyncModelParam syncModelParam) {
        List<AcModel> models = this.modelService.findByIds(syncModelParam.getModelIds());
        models.forEach(model -> {
            this.syncInterceptor.start();
            AcModelSyncHis syncHis = new AcModelSyncHis();
            syncHis.setModelCode(model.getModelCode());
            try {
                model = this.syncModel(model.getModelCode(), syncModelParam.getSyncType());
                syncModelParam.updateModelResult(model.getModelId(), SyncStatus.SUCCESS);
                syncModelParam.appendMessage(model.getModelId(), SyncMessageLevel.INFO, "[{}]({}): \u540c\u6b65\u5b8c\u6210.", model.getModelName(), model.getModelCode());
                syncHis.setSyncSuccess(YesNo.Y);
                model.setSyncStatus(ModelSyncStatus.SYNCED);
                model.updateLastDbName();
                this.modelService.updateById(model);
                this.modelFieldService.saveOrUpdateBatch(model.getFields());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                syncModelParam.updateModelResult(model.getModelId(), SyncStatus.ERROR);
                syncModelParam.appendMessage(model.getModelId(), SyncMessageLevel.ERROR, "[{}]({}): \u540c\u6b65\u51fa\u9519:{}", model.getModelName(), model.getModelCode(), e.getMessage());
                syncHis.setSyncSuccess(YesNo.N);
            }
            try {
                List<String> ddlSql = this.syncInterceptor.end();
                syncHis.setSyncLog(CollUtil.join(ddlSql, (CharSequence)";"));
                System.out.println(syncHis.getSyncLog());
                syncHis.setSyncTime(DateTime.now());
                this.save(syncHis);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                syncModelParam.updateModelResult(model.getModelId(), SyncStatus.ERROR);
                syncModelParam.appendMessage(model.getModelId(), SyncMessageLevel.ERROR, "[{}]({}): \u540c\u6b65\u51fa\u9519:{}", model.getModelName(), model.getModelCode(), e.getMessage());
            }
        });
        syncModelParam.setStatus(SyncStatus.SUCCESS);
    }

    public AcModel syncModel(String modelCode, SyncType syncType) throws Exception {
        AcModel model = this.modelService.findByCode(modelCode);
        if (model.getModelType() == ModelType.V) {
            this.syncView(model);
        } else if (syncType == SyncType.FORMDB) {
            this.modelService.deleteModel(model.getModelId());
            model.setModelId(null);
            model.setFields(this.modelService.getFieldsFormDb(model.getTableName()));
            model.setImported(true);
            this.modelService.saveModel(model);
        } else {
            String tableName = StrUtil.isNotBlank((CharSequence)model.getLastDbName()) ? model.getLastDbName() : model.getTableName();
            Table table = ServiceProxy.metadata().table(tableName);
            if (table == null) {
                this.createTable(model);
            } else {
                this.updateTable(model, table, syncType);
            }
        }
        return model;
    }

    public void syncView(AcModel model) {
        List<AcModelField> viewFields = this.modelService.getFieldsFormDb(model.getTableName());
        viewFields.forEach(vField -> {
            if (!CollUtil.contains(model.getFields(), modelField -> StrUtil.equals((CharSequence)vField.getColName(), (CharSequence)modelField.getColName()))) {
                model.getFields().add((AcModelField)vField);
            }
        });
        model.getFields().forEach(modelField -> {
            if (!CollUtil.contains((Collection)viewFields, vField -> StrUtil.equals((CharSequence)vField.getColName(), (CharSequence)modelField.getColName()))) {
                modelField.setDeleted(1);
            }
        });
        model.setSyncStatus(ModelSyncStatus.SYNCED);
        this.modelService.saveOrUpdate(model);
        this.modelFieldService.saveOrUpdateBatch(model.getFields());
    }

    public void createTable(AcModel model) {
        Table table = new Table(model.getTableName());
        table.setComment(model.getModelName());
        for (AcModelField field : model.getFields()) {
            table.addColumn(field.toDbColumn());
        }
        try {
            ServiceProxy.ddl().create(table);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8868\u7ed3\u6784\u521b\u5efa\u5931\u8d25,{}:{}", (Throwable)e, model.getTableName(), e.getMessage());
        }
    }

    public void updateTable(AcModel model, Table table, SyncType syncType) throws Exception {
        if (syncType == SyncType.DROP) {
            this.dropTable(table);
            this.createTable(model);
            return;
        }
        if (syncType == SyncType.CLEAR) {
            this.clearTable(table);
        }
        try {
            this.syncTableColumns(model, table, syncType);
            ServiceProxy.ddl().alter(table);
            if (!StrUtil.equalsIgnoreCase((CharSequence)model.getTableName(), (CharSequence)table.getName())) {
                table.setNewName(model.getTableName());
                ServiceProxy.ddl().alter(table);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u8868\u7ed3\u6784\u66f4\u65b0\u5931\u8d25,{}:{}", (Throwable)e, model.getTableName(), e.getMessage());
        }
    }

    public void syncTableColumns(AcModel model, Table table, SyncType syncType) {
        table.update();
        List<AcModelField> modelFields = model.getFields();
        modelFields.forEach(field -> {
            String dbColName = StrUtil.isNotBlank((CharSequence)field.getLastDbName()) ? field.getLastDbName() : field.getColName();
            Column col = table.getColumn(dbColName);
            if (col == null) {
                table.addColumn(field.toDbColumn());
            } else {
                AcModelField dbField = AcModelField.fromDbColumn(col);
                if (!StrUtil.equals((CharSequence)field.columnStr(), (CharSequence)dbField.columnStr())) {
                    col = (Column)col.update();
                    Column fieldCol = field.toDbColumn();
                    col.setName(fieldCol.getName());
                    col.setTypeName(fieldCol.getTypeName());
                    col.setLength(fieldCol.getLength());
                    col.setPrecision(fieldCol.getPrecision());
                    col.setScale(fieldCol.getScale());
                    col.setDefaultValue(fieldCol.getDefaultValue());
                    col.setComment(fieldCol.getComment());
                    col.setPrimary(fieldCol.isPrimaryKey());
                    col.setNullable(fieldCol.isNullable());
                }
            }
        });
        if (syncType == SyncType.STRICT) {
            table.setAutoDropColumn(true);
            ArrayList colNames = new ArrayList(table.getColumns().keySet());
            colNames.forEach(colName -> {
                if (model.getFieldByColName((String)colName) == null) {
                    table.getColumn(colName).drop();
                }
            });
        }
    }

    public void clearTable(Table table) {
        ServiceProxy.truncate((Table)table);
    }

    public void dropTable(Table table) throws Exception {
        ServiceProxy.ddl().drop(table);
    }

    public SyncModelParam getSyncStatus(String syncId) {
        return this.syncStatusMap.get(syncId);
    }
}

