/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcFlow;
import com.kdgcsoft.web.ac.entity.table.AcFlowTableDef;
import com.kdgcsoft.web.ac.interfaces.ModelHandler;
import com.kdgcsoft.web.ac.mapper.AcFlowMapper;
import com.kdgcsoft.web.ac.utils.ModelUtil;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AcFlowService
extends ServiceImpl<AcFlowMapper, AcFlow>
implements ModelHandler<AcFlow> {
    @Override
    public boolean beforeSave(AcFlow entity, boolean isNew) {
        if (StrUtil.isBlank((CharSequence)entity.getFlowId())) {
            entity.setFlowCode(ModelUtil.shortId("flow"));
        }
        return true;
    }

    public AcFlow findByCode(String flowCode) {
        Assert.notBlank((CharSequence)flowCode, (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcFlow)((AcFlowMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcFlow::getFlowCode, (Object)flowCode));
    }

    public AcFlow saveFlow(AcFlow acFlow) {
        if (StrUtil.isBlank((CharSequence)acFlow.getFlowId())) {
            acFlow.setFlowCode(ModelUtil.shortId("flow"));
        }
        this.checkRepeat(acFlow);
        this.saveOrUpdate(acFlow);
        return acFlow;
    }

    public void checkRepeat(AcFlow acFlow) {
        Assert.isFalse((boolean)this.exists(AcFlowTableDef.AC_FLOW.FLOW_CODE.eq((Object)acFlow.getFlowCode()).and(AcFlowTableDef.AC_FLOW.FLOW_ID.ne((Object)acFlow.getFlowId(), If::hasText))), (String)"\u6d41\u7a0b[{}]\u7f16\u7801[{}]\u91cd\u590d", (Object[])new Object[]{acFlow.getFlowName(), acFlow.getFlowCode()});
    }

    public List<AcFlow> exportByAppCode(String appCode) {
        return ((AcFlowMapper)this.getMapper()).selectListByQuery(QueryWrapper.create().eq(AcFlow::getAppCode, (Object)appCode));
    }

    public String importFlows(List<AcFlow> flows) {
        int insertCount = 0;
        int updateCount = 0;
        if (CollectionUtil.isNotEmpty(flows)) {
            List flowCodeList = flows.stream().map(AcFlow::getFlowCode).collect(Collectors.toList());
            List dbFlowList = this.list(QueryWrapper.create().in(AcFlow::getFlowCode, flowCodeList));
            Map dbFlowMap = dbFlowList.stream().collect(Collectors.toMap(AcFlow::getFlowCode, Function.identity()));
            for (AcFlow flow : flows) {
                AcFlow dbFlow = (AcFlow)dbFlowMap.get(flow.getFlowCode());
                if (dbFlow == null) {
                    flow.setFlowId(null);
                    ++insertCount;
                } else {
                    flow.setFlowId(dbFlow.getFlowId());
                    ++updateCount;
                }
                this.saveOrUpdate(flow);
            }
        }
        if (insertCount + updateCount == 0) {
            return null;
        }
        return String.format("\u5bfc\u5165\u6d41\u7a0b %d \u4e2a\uff1a\u65b0\u589e %d \u4e2a\uff0c\u66f4\u65b0 %d \u4e2a", insertCount + updateCount, insertCount, updateCount);
    }
}

