/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.pojo.dataset;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.enums.Condition;
import com.kdgcsoft.web.ac.enums.ConditionType;
import com.kdgcsoft.web.ac.enums.JoinType;
import com.kdgcsoft.web.ac.enums.Order;
import com.kdgcsoft.web.ac.enums.QueryFieldFunc;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ModelQueryBuilder {
    private List<QueryField> fields;
    private QueryModel main;
    private List<JoinModel> joins;
    private List<QueryCondition> conditions;
    private List<QueryOrder> groups;
    private List<QueryOrder> orders;

    public boolean isValid() {
        if (this.main == null || StrUtil.isBlank((CharSequence)this.main.getModelCode())) {
            return false;
        }
        if (CollUtil.isEmpty(this.fields)) {
            return false;
        }
        AtomicBoolean isValid = new AtomicBoolean(true);
        CollUtil.forEach(this.joins, (CollUtil.Consumer & Serializable)(joinModel, index) -> {
            if (StrUtil.isBlank((CharSequence)joinModel.getModelCode()) || StrUtil.isBlank((CharSequence)joinModel.getMainField()) || StrUtil.isBlank((CharSequence)joinModel.getJoinField())) {
                isValid.set(false);
            }
        });
        return isValid.get();
    }

    public ModelQueryBuilder setFields(List<QueryField> fields) {
        this.fields = fields;
        return this;
    }

    public ModelQueryBuilder setMain(QueryModel main) {
        this.main = main;
        return this;
    }

    public ModelQueryBuilder setJoins(List<JoinModel> joins) {
        this.joins = joins;
        return this;
    }

    public ModelQueryBuilder setConditions(List<QueryCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public ModelQueryBuilder setGroups(List<QueryOrder> groups) {
        this.groups = groups;
        return this;
    }

    public ModelQueryBuilder setOrders(List<QueryOrder> orders) {
        this.orders = orders;
        return this;
    }

    public List<QueryField> getFields() {
        return this.fields;
    }

    public QueryModel getMain() {
        return this.main;
    }

    public List<JoinModel> getJoins() {
        return this.joins;
    }

    public List<QueryCondition> getConditions() {
        return this.conditions;
    }

    public List<QueryOrder> getGroups() {
        return this.groups;
    }

    public List<QueryOrder> getOrders() {
        return this.orders;
    }

    public static class QueryOrder {
        private String fieldKey;
        private Order order;

        public String getTableKey() {
            List list = StrUtil.split((CharSequence)this.fieldKey, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(0);
            }
            return null;
        }

        public String getFieldCode() {
            List list = StrUtil.split((CharSequence)this.fieldKey, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(1);
            }
            return null;
        }

        public QueryOrder setFieldKey(String fieldKey) {
            this.fieldKey = fieldKey;
            return this;
        }

        public QueryOrder setOrder(Order order) {
            this.order = order;
            return this;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public Order getOrder() {
            return this.order;
        }
    }

    public static class QueryCondition {
        private String fieldKey;
        private Condition condition;
        private ConditionType type;
        private String value;

        public String getTableKey() {
            List list = StrUtil.split((CharSequence)this.fieldKey, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(0);
            }
            return null;
        }

        public String getFieldCode() {
            List list = StrUtil.split((CharSequence)this.fieldKey, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(1);
            }
            return null;
        }

        public String getRightTableKey() {
            List list = StrUtil.split((CharSequence)this.value, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(0);
            }
            return null;
        }

        public String getRightFieldCode() {
            List list = StrUtil.split((CharSequence)this.value, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(1);
            }
            return null;
        }

        public QueryCondition setFieldKey(String fieldKey) {
            this.fieldKey = fieldKey;
            return this;
        }

        public QueryCondition setCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public QueryCondition setType(ConditionType type) {
            this.type = type;
            return this;
        }

        public QueryCondition setValue(String value) {
            this.value = value;
            return this;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public ConditionType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class JoinModel {
        private String tableKey;
        private String modelCode;
        private String alias;
        private String joinField;
        private JoinType joinType;
        private String mainField;

        public JoinModel setTableKey(String tableKey) {
            this.tableKey = tableKey;
            return this;
        }

        public JoinModel setModelCode(String modelCode) {
            this.modelCode = modelCode;
            return this;
        }

        public JoinModel setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public JoinModel setJoinField(String joinField) {
            this.joinField = joinField;
            return this;
        }

        public JoinModel setJoinType(JoinType joinType) {
            this.joinType = joinType;
            return this;
        }

        public JoinModel setMainField(String mainField) {
            this.mainField = mainField;
            return this;
        }

        public String getTableKey() {
            return this.tableKey;
        }

        public String getModelCode() {
            return this.modelCode;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getJoinField() {
            return this.joinField;
        }

        public JoinType getJoinType() {
            return this.joinType;
        }

        public String getMainField() {
            return this.mainField;
        }
    }

    public static class QueryModel {
        private String tableKey;
        private String modelCode;
        private String alias;

        public QueryModel setTableKey(String tableKey) {
            this.tableKey = tableKey;
            return this;
        }

        public QueryModel setModelCode(String modelCode) {
            this.modelCode = modelCode;
            return this;
        }

        public QueryModel setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public String getTableKey() {
            return this.tableKey;
        }

        public String getModelCode() {
            return this.modelCode;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public static class QueryField {
        private String fieldKey;
        private String alias;
        private QueryFieldFunc func;

        public String getTableKey() {
            List list = StrUtil.split((CharSequence)this.fieldKey, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(0);
            }
            return null;
        }

        public String getFieldCode() {
            List list = StrUtil.split((CharSequence)this.fieldKey, (CharSequence)".");
            if (list.size() == 2) {
                return (String)list.get(1);
            }
            return null;
        }

        public QueryField setFieldKey(String fieldKey) {
            this.fieldKey = fieldKey;
            return this;
        }

        public QueryField setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public QueryField setFunc(QueryFieldFunc func) {
            this.func = func;
            return this;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public String getAlias() {
            return this.alias;
        }

        public QueryFieldFunc getFunc() {
            return this.func;
        }
    }
}

