/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.pojo.dataset;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcDataset;
import com.kdgcsoft.web.ac.enums.QueryType;
import com.kdgcsoft.web.ac.pojo.TreeFields;
import com.kdgcsoft.web.ac.pojo.dataset.DatasetConfig;
import com.kdgcsoft.web.ac.pojo.dataset.DatasetField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasetModel {
    private String datasetId;
    private String appCode;
    private String datasetCode;
    private String datasetName;
    private QueryType queryType;
    private DatasetConfig datasetConfig;
    private TreeFields treeFields;
    private List<DatasetField> datasetFields;
    private List<DatasetConfig.DatasetParam> configParams = new ArrayList<DatasetConfig.DatasetParam>();
    private List<String> requiredParams = new ArrayList<String>();
    private Map<String, String> paramsValues = new HashMap<String, String>();

    public static DatasetModel of(AcDataset acDataset) {
        DatasetModel datasetModel = new DatasetModel();
        BeanUtil.copyProperties((Object)acDataset, (Object)datasetModel, (String[])new String[0]);
        datasetModel.setConfigParams(datasetModel.getDatasetConfig() == null ? new ArrayList() : datasetModel.getDatasetConfig().getParams());
        return datasetModel;
    }

    public void buildParamsValue(Map<String, String> paramsMap) {
        paramsMap.forEach((k, v) -> {
            if (CollUtil.contains(this.configParams, datasetParam -> StrUtil.equals((CharSequence)datasetParam.getCode(), (CharSequence)k))) {
                this.paramsValues.put((String)k, (String)v);
            }
        });
    }

    public boolean hasRequiredParam() {
        return this.paramsValues.keySet().containsAll(this.requiredParams);
    }

    public DatasetModel setDatasetId(String datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    public DatasetModel setAppCode(String appCode) {
        this.appCode = appCode;
        return this;
    }

    public DatasetModel setDatasetCode(String datasetCode) {
        this.datasetCode = datasetCode;
        return this;
    }

    public DatasetModel setDatasetName(String datasetName) {
        this.datasetName = datasetName;
        return this;
    }

    public DatasetModel setQueryType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    public DatasetModel setDatasetConfig(DatasetConfig datasetConfig) {
        this.datasetConfig = datasetConfig;
        return this;
    }

    public DatasetModel setTreeFields(TreeFields treeFields) {
        this.treeFields = treeFields;
        return this;
    }

    public DatasetModel setDatasetFields(List<DatasetField> datasetFields) {
        this.datasetFields = datasetFields;
        return this;
    }

    public DatasetModel setConfigParams(List<DatasetConfig.DatasetParam> configParams) {
        this.configParams = configParams;
        return this;
    }

    public DatasetModel setRequiredParams(List<String> requiredParams) {
        this.requiredParams = requiredParams;
        return this;
    }

    public DatasetModel setParamsValues(Map<String, String> paramsValues) {
        this.paramsValues = paramsValues;
        return this;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getDatasetCode() {
        return this.datasetCode;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public DatasetConfig getDatasetConfig() {
        return this.datasetConfig;
    }

    public TreeFields getTreeFields() {
        return this.treeFields;
    }

    public List<DatasetField> getDatasetFields() {
        return this.datasetFields;
    }

    public List<DatasetConfig.DatasetParam> getConfigParams() {
        return this.configParams;
    }

    public List<String> getRequiredParams() {
        return this.requiredParams;
    }

    public Map<String, String> getParamsValues() {
        return this.paramsValues;
    }
}

