/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.entity;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONObject;
import com.fhs.core.trans.anno.Trans;
import com.fhs.core.trans.vo.TransPojo;
import com.kdgcsoft.web.ac.enums.EmbedFields;
import com.kdgcsoft.web.ac.enums.dict.FieldType;
import com.kdgcsoft.web.ac.pojo.FieldUIConfig;
import com.kdgcsoft.web.core.entity.base.AuditEntity;
import com.kdgcsoft.web.core.enums.YesNo;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.core.handler.Fastjson2TypeHandler;
import io.swagger.v3.oas.annotations.media.Schema;
import org.anyline.metadata.Column;

@Schema(name="\u6a21\u578b\u5b57\u6bb5", title="")
@Table(value="ac_model_field")
public class AcModelField
extends AuditEntity
implements TransPojo {
    @Schema(name="\u5b57\u6bb5ID", title="")
    @Id
    private String fieldId;
    @Schema(name="\u5b57\u6bb5key", title="")
    private String fieldKey;
    @Schema(name="\u6a21\u578b\u7f16\u7801", title="")
    private String modelCode;
    @Schema(name="\u5b57\u6bb5\u7f16\u7801", title="")
    private String fieldCode;
    @Schema(name="\u5b57\u6bb5\u540d\u79f0", title="")
    private String fieldName;
    @Schema(name="\u6570\u636e\u5e93\u5217\u540d", title="")
    private String colName;
    @Schema(name="\u6700\u540e\u4e00\u6b21\u540c\u6b65\u540e\u7684\u6570\u636e\u5e93\u5217\u540d", title="")
    private String lastDbName;
    @Schema(name="\u5b57\u6bb5\u7c7b\u578b", title="")
    @Trans(type="dictionary", key="FieldType")
    private FieldType fieldType;
    @Schema(name="\u5b57\u6bb5\u957f\u5ea6", title="")
    private Integer fieldSize;
    @Schema(name="\u5b57\u6bb5\u7cbe\u5ea6", title="")
    private Integer fieldScale;
    @Schema(name="\u662f\u5426\u552f\u4e00\u6027\u9a8c\u8bc1", title="")
    private YesNo isUnique;
    @Schema(name="ui\u5efa\u8bae", title="")
    @com.mybatisflex.annotation.Column(typeHandler=Fastjson2TypeHandler.class)
    private FieldUIConfig uiConfig;
    @Schema(name="\u662f\u5426\u4e3b\u952e", title="")
    private YesNo isPk;
    @Schema(name="\u5fc5\u586b", title="")
    private YesNo notNull;
    @Schema(name="\u9ed8\u8ba4\u503c", title="")
    private String defValue;
    @Schema(name="\u5907\u6ce8", title="")
    private String rmk;
    @Schema(name="\u6392\u5e8f\u53f7", title="")
    private Integer orderNo;
    @Schema(name="\u5185\u7f6e\u5b57\u6bb5", title="")
    @Trans(type="dictionary", key="YesNo")
    private YesNo embed;
    @Schema(name="\u5b57\u6bb5\u7c7b\u578b\u7b80\u79f0,\u7528\u4f5c\u524d\u53f0\u5c55\u793a", title="")
    @com.mybatisflex.annotation.Column(ignore=true)
    private String typeAbbr;

    public String columnStr() {
        JSONObject json = new JSONObject();
        json.put((Object)"column", (Object)this.colName.toLowerCase());
        json.put((Object)"type", (Object)this.fieldType.getStandardType());
        json.put((Object)"size", (Object)this.fieldSize);
        json.put((Object)"scale", (Object)this.fieldScale);
        json.put((Object)"pk", this.isPk != null ? this.isPk.name() : null);
        json.put((Object)"notNull", this.notNull != null ? this.notNull.name() : null);
        json.put((Object)"defValue", (Object)this.defValue);
        return json.toString();
    }

    public void settleField() {
        if (StrUtil.isNotBlank((CharSequence)this.colName)) {
            this.colName = this.colName.toLowerCase();
        }
        if (this.fieldId == null) {
            this.fieldCode = NamingCase.toCamelCase((CharSequence)this.colName);
        }
        if (StrUtil.isBlank((CharSequence)this.fieldKey)) {
            this.fieldKey = StrUtil.join((CharSequence)".", (Object[])new Object[]{this.modelCode, this.fieldCode});
        }
        this.isPk = (YesNo)((Object)ObjectUtil.defaultIfNull((Object)((Object)this.isPk), (Object)((Object)YesNo.N)));
        this.fieldType = (FieldType)((Object)ObjectUtil.defaultIfNull((Object)((Object)this.fieldType), (Object)((Object)FieldType.STRING)));
        this.fieldSize = (Integer)ObjectUtil.defaultIfNull((Object)this.fieldSize, (Object)this.fieldType.getSize());
        this.fieldScale = (Integer)ObjectUtil.defaultIfNull((Object)this.fieldScale, (Object)this.fieldType.getScale());
        this.notNull = (YesNo)((Object)ObjectUtil.defaultIfNull((Object)((Object)this.notNull), (Object)((Object)YesNo.N)));
        this.embed = (YesNo)((Object)ObjectUtil.defaultIfNull((Object)((Object)this.embed), (Object)((Object)YesNo.N)));
    }

    public Column toDbColumn() {
        Column column = new Column();
        ((Column)((Column)column.setName(this.getColName())).setPrimary(Boolean.valueOf(this.getIsPk() == YesNo.Y)).setNullable(Boolean.valueOf(this.getNotNull() == YesNo.N)).setComment(this.getFieldName())).setDefaultValue((Object)this.getDefValue());
        column.setTypeName(this.getFieldType().getStandardType().getName());
        column.setPrecision(this.getFieldSize());
        column.setLength(this.getFieldSize());
        column.setScale(this.getFieldScale());
        return column;
    }

    public static AcModelField fromDbColumn(Column column) {
        AcModelField field = new AcModelField();
        if (EmbedFields.isEmbedField(column.getName())) {
            field = EmbedFields.buildEmbedField(column.getName());
        } else {
            field.setColName(column.getName());
            field.setFieldCode(NamingCase.toCamelCase((CharSequence)column.getName()));
            field.setFieldName(StrUtil.emptyToDefault((CharSequence)column.getComment(), (String)field.getFieldCode()));
            field.setOrderNo(column.getPosition());
            field.setEmbed(YesNo.N);
            field.setDefValue(column.getDefaultValue() == null ? null : column.getDefaultValue().toString());
            field.setNotNull(Convert.toBool((Object)column.isNullable()) != false ? YesNo.N : YesNo.Y);
            field.setIsPk(Convert.toBool((Object)column.isPrimaryKey()) != false ? YesNo.Y : YesNo.N);
            field.setFieldType(FieldType.getByCategory(column.getTypeMetadata().getCategory()));
            field.setFieldSize(column.getLength());
            if (field.getFieldType() == FieldType.DOUBLE) {
                field.setFieldScale(column.getScale());
            }
        }
        return field;
    }

    public String toString() {
        return "DesModelField{fieldId='" + this.fieldId + "', modelCode='" + this.modelCode + "', fieldCode='" + this.fieldCode + "', fieldName='" + this.fieldName + "', colName='" + this.colName + "', fieldType=" + this.fieldType + ", fieldSize=" + this.fieldSize + ", fieldScale=" + this.fieldScale + ", isPk=" + this.isPk + ", notNull=" + this.notNull + ", defValue='" + this.defValue + "', rmk='" + this.rmk + "', embed=" + this.embed + "}";
    }

    public AcModelField setFieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    public AcModelField setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
        return this;
    }

    public AcModelField setModelCode(String modelCode) {
        this.modelCode = modelCode;
        return this;
    }

    public AcModelField setFieldCode(String fieldCode) {
        this.fieldCode = fieldCode;
        return this;
    }

    public AcModelField setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public AcModelField setColName(String colName) {
        this.colName = colName;
        return this;
    }

    public AcModelField setLastDbName(String lastDbName) {
        this.lastDbName = lastDbName;
        return this;
    }

    public AcModelField setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public AcModelField setFieldSize(Integer fieldSize) {
        this.fieldSize = fieldSize;
        return this;
    }

    public AcModelField setFieldScale(Integer fieldScale) {
        this.fieldScale = fieldScale;
        return this;
    }

    public AcModelField setIsUnique(YesNo isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    public AcModelField setUiConfig(FieldUIConfig uiConfig) {
        this.uiConfig = uiConfig;
        return this;
    }

    public AcModelField setIsPk(YesNo isPk) {
        this.isPk = isPk;
        return this;
    }

    public AcModelField setNotNull(YesNo notNull) {
        this.notNull = notNull;
        return this;
    }

    public AcModelField setDefValue(String defValue) {
        this.defValue = defValue;
        return this;
    }

    public AcModelField setRmk(String rmk) {
        this.rmk = rmk;
        return this;
    }

    public AcModelField setOrderNo(Integer orderNo) {
        this.orderNo = orderNo;
        return this;
    }

    public AcModelField setEmbed(YesNo embed) {
        this.embed = embed;
        return this;
    }

    public AcModelField setTypeAbbr(String typeAbbr) {
        this.typeAbbr = typeAbbr;
        return this;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getFieldKey() {
        return this.fieldKey;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public String getFieldCode() {
        return this.fieldCode;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getColName() {
        return this.colName;
    }

    public String getLastDbName() {
        return this.lastDbName;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public Integer getFieldSize() {
        return this.fieldSize;
    }

    public Integer getFieldScale() {
        return this.fieldScale;
    }

    public YesNo getIsUnique() {
        return this.isUnique;
    }

    public FieldUIConfig getUiConfig() {
        return this.uiConfig;
    }

    public YesNo getIsPk() {
        return this.isPk;
    }

    public YesNo getNotNull() {
        return this.notNull;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public String getRmk() {
        return this.rmk;
    }

    public Integer getOrderNo() {
        return this.orderNo;
    }

    public YesNo getEmbed() {
        return this.embed;
    }

    public String getTypeAbbr() {
        return this.typeAbbr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcModelField)) {
            return false;
        }
        AcModelField other = (AcModelField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$fieldSize = this.getFieldSize();
        Integer other$fieldSize = other.getFieldSize();
        if (this$fieldSize == null ? other$fieldSize != null : !((Object)this$fieldSize).equals(other$fieldSize)) {
            return false;
        }
        Integer this$fieldScale = this.getFieldScale();
        Integer other$fieldScale = other.getFieldScale();
        if (this$fieldScale == null ? other$fieldScale != null : !((Object)this$fieldScale).equals(other$fieldScale)) {
            return false;
        }
        Integer this$orderNo = this.getOrderNo();
        Integer other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !((Object)this$orderNo).equals(other$orderNo)) {
            return false;
        }
        String this$fieldId = this.getFieldId();
        String other$fieldId = other.getFieldId();
        if (this$fieldId == null ? other$fieldId != null : !this$fieldId.equals(other$fieldId)) {
            return false;
        }
        String this$fieldKey = this.getFieldKey();
        String other$fieldKey = other.getFieldKey();
        if (this$fieldKey == null ? other$fieldKey != null : !this$fieldKey.equals(other$fieldKey)) {
            return false;
        }
        String this$modelCode = this.getModelCode();
        String other$modelCode = other.getModelCode();
        if (this$modelCode == null ? other$modelCode != null : !this$modelCode.equals(other$modelCode)) {
            return false;
        }
        String this$fieldCode = this.getFieldCode();
        String other$fieldCode = other.getFieldCode();
        if (this$fieldCode == null ? other$fieldCode != null : !this$fieldCode.equals(other$fieldCode)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$colName = this.getColName();
        String other$colName = other.getColName();
        if (this$colName == null ? other$colName != null : !this$colName.equals(other$colName)) {
            return false;
        }
        String this$lastDbName = this.getLastDbName();
        String other$lastDbName = other.getLastDbName();
        if (this$lastDbName == null ? other$lastDbName != null : !this$lastDbName.equals(other$lastDbName)) {
            return false;
        }
        FieldType this$fieldType = this.getFieldType();
        FieldType other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType)) {
            return false;
        }
        YesNo this$isUnique = this.getIsUnique();
        YesNo other$isUnique = other.getIsUnique();
        if (this$isUnique == null ? other$isUnique != null : !((Object)((Object)this$isUnique)).equals((Object)other$isUnique)) {
            return false;
        }
        FieldUIConfig this$uiConfig = this.getUiConfig();
        FieldUIConfig other$uiConfig = other.getUiConfig();
        if (this$uiConfig == null ? other$uiConfig != null : !this$uiConfig.equals(other$uiConfig)) {
            return false;
        }
        YesNo this$isPk = this.getIsPk();
        YesNo other$isPk = other.getIsPk();
        if (this$isPk == null ? other$isPk != null : !((Object)((Object)this$isPk)).equals((Object)other$isPk)) {
            return false;
        }
        YesNo this$notNull = this.getNotNull();
        YesNo other$notNull = other.getNotNull();
        if (this$notNull == null ? other$notNull != null : !((Object)((Object)this$notNull)).equals((Object)other$notNull)) {
            return false;
        }
        String this$defValue = this.getDefValue();
        String other$defValue = other.getDefValue();
        if (this$defValue == null ? other$defValue != null : !this$defValue.equals(other$defValue)) {
            return false;
        }
        String this$rmk = this.getRmk();
        String other$rmk = other.getRmk();
        if (this$rmk == null ? other$rmk != null : !this$rmk.equals(other$rmk)) {
            return false;
        }
        YesNo this$embed = this.getEmbed();
        YesNo other$embed = other.getEmbed();
        if (this$embed == null ? other$embed != null : !((Object)((Object)this$embed)).equals((Object)other$embed)) {
            return false;
        }
        String this$typeAbbr = this.getTypeAbbr();
        String other$typeAbbr = other.getTypeAbbr();
        return !(this$typeAbbr == null ? other$typeAbbr != null : !this$typeAbbr.equals(other$typeAbbr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcModelField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $fieldSize = this.getFieldSize();
        result = result * 59 + ($fieldSize == null ? 43 : ((Object)$fieldSize).hashCode());
        Integer $fieldScale = this.getFieldScale();
        result = result * 59 + ($fieldScale == null ? 43 : ((Object)$fieldScale).hashCode());
        Integer $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : ((Object)$orderNo).hashCode());
        String $fieldId = this.getFieldId();
        result = result * 59 + ($fieldId == null ? 43 : $fieldId.hashCode());
        String $fieldKey = this.getFieldKey();
        result = result * 59 + ($fieldKey == null ? 43 : $fieldKey.hashCode());
        String $modelCode = this.getModelCode();
        result = result * 59 + ($modelCode == null ? 43 : $modelCode.hashCode());
        String $fieldCode = this.getFieldCode();
        result = result * 59 + ($fieldCode == null ? 43 : $fieldCode.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $colName = this.getColName();
        result = result * 59 + ($colName == null ? 43 : $colName.hashCode());
        String $lastDbName = this.getLastDbName();
        result = result * 59 + ($lastDbName == null ? 43 : $lastDbName.hashCode());
        FieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
        YesNo $isUnique = this.getIsUnique();
        result = result * 59 + ($isUnique == null ? 43 : ((Object)((Object)$isUnique)).hashCode());
        FieldUIConfig $uiConfig = this.getUiConfig();
        result = result * 59 + ($uiConfig == null ? 43 : $uiConfig.hashCode());
        YesNo $isPk = this.getIsPk();
        result = result * 59 + ($isPk == null ? 43 : ((Object)((Object)$isPk)).hashCode());
        YesNo $notNull = this.getNotNull();
        result = result * 59 + ($notNull == null ? 43 : ((Object)((Object)$notNull)).hashCode());
        String $defValue = this.getDefValue();
        result = result * 59 + ($defValue == null ? 43 : $defValue.hashCode());
        String $rmk = this.getRmk();
        result = result * 59 + ($rmk == null ? 43 : $rmk.hashCode());
        YesNo $embed = this.getEmbed();
        result = result * 59 + ($embed == null ? 43 : ((Object)((Object)$embed)).hashCode());
        String $typeAbbr = this.getTypeAbbr();
        result = result * 59 + ($typeAbbr == null ? 43 : $typeAbbr.hashCode());
        return result;
    }

    public static final class Fields {
        public static final String fieldId = "fieldId";
        public static final String fieldKey = "fieldKey";
        public static final String modelCode = "modelCode";
        public static final String fieldCode = "fieldCode";
        public static final String fieldName = "fieldName";
        public static final String colName = "colName";
        public static final String lastDbName = "lastDbName";
        public static final String fieldType = "fieldType";
        public static final String fieldSize = "fieldSize";
        public static final String fieldScale = "fieldScale";
        public static final String isUnique = "isUnique";
        public static final String uiConfig = "uiConfig";
        public static final String isPk = "isPk";
        public static final String notNull = "notNull";
        public static final String defValue = "defValue";
        public static final String rmk = "rmk";
        public static final String orderNo = "orderNo";
        public static final String embed = "embed";
        public static final String typeAbbr = "typeAbbr";
    }
}

