/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.resource.tdengine;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.db.meta.Table;
import com.kdgcsoft.common.exception.BizException;
import com.kdgcsoft.plugin.api.ResourceType;
import com.kdgcsoft.plugin.api.param.DBResourcePluginParam;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.common.model.PageObject;
import com.kdgcsoft.plugin.common.resource.db.AbstractDBResourcePlugin;
import com.kdgcsoft.plugin.common.resource.db.SimpleDataSource;
import com.kdgcsoft.plugin.common.util.DbMetaUtil;
import com.kdgcsoft.plugin.common.util.JdbcDBType;
import com.kdgcsoft.plugin.resource.tdengine.TDEngineProtocolType;
import com.kdgcsoft.plugin.resource.tdengine.TDEngineResourceApiController;
import com.kdgcsoft.plugin.resource.tdengine.TDEngineResourcePluginParam;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class TDEngineResourcePlugin
extends Plugin {
    public TDEngineResourcePlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class TDEngineIResourcePlugin
    extends AbstractDBResourcePlugin
    implements ExtensionPoint {
        private TDEngineProtocolType protocolType;

        public void init(PluginParam pluginParam) {
            TDEngineResourcePluginParam param = (TDEngineResourcePluginParam)pluginParam;
            this.protocolType = param.getProtocolType();
            super.init(pluginParam);
        }

        public Connection openConnection() throws Exception {
            String driverClass = this.driverClass();
            Class.forName(driverClass);
            return DriverManager.getConnection(this.connectionString);
        }

        protected String driverClass() {
            return this.protocolType.getDriverClass();
        }

        public String buildUrl(DBResourcePluginParam param) {
            return this.protocolType.getProtocol() + param.getHost() + ":" + param.getPort() + "/" + param.getCatalog() + "?user=" + param.getUsername() + "&password=" + param.getPassword();
        }

        private void getTables(List<String> tables, Connection conn, String catalog, boolean isSuperTable) throws Exception {
            if (tables.size() >= 5) {
                return;
            }
            String sql = "show " + catalog + (isSuperTable ? ".stables " : ".tables ");
            try (PreparedStatement statement = conn.prepareStatement(sql);
                 ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    String tableName = rs.getString(isSuperTable ? "name" : "table_name");
                    if (!StrUtil.isNotBlank((CharSequence)tableName)) continue;
                    tables.add(tableName);
                    if (tables.size() < 5) continue;
                    break;
                }
            }
        }

        public Object resourceInfo() {
            ArrayList<Table> arrayList;
            block9: {
                ArrayList<String> tables = new ArrayList<String>();
                Connection conn = this.openConnection();
                try {
                    String catalog = conn.getCatalog();
                    this.getTables(tables, conn, catalog, true);
                    this.getTables(tables, conn, catalog, false);
                    ArrayList<Table> list = new ArrayList<Table>();
                    for (String t : tables) {
                        list.add(DbMetaUtil.getTableMeta4TD((Connection)conn, (String)this.db, (String)this.getSchema(), (String)t));
                    }
                    arrayList = list;
                    if (conn == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new BizException(e.getMessage(), (Throwable)e);
                    }
                }
                conn.close();
            }
            return arrayList;
        }

        public Object preview(Map<String, String> map) {
            PageObject result;
            try (Connection conn = this.openConnection();){
                this.jdbcDBType = JdbcDBType.of((String)conn.getMetaData().getDatabaseProductName());
                String tableName = map.get("tableName");
                String sql = "SELECT * FROM `" + tableName + "`";
                TimeInterval timer = DateUtil.timer();
                Page page = Page.of((int)MapUtil.getInt(map, (Object)"page"), (int)MapUtil.getInt(map, (Object)"pageSize"));
                result = PageObject.of((PageResult)DbUtil.use((DataSource)this.buildDataSource()).page((CharSequence)sql, page, new Object[0]));
                result.setTimeCost(timer.interval());
            }
            catch (Exception e) {
                throw new BizException(e.getMessage(), (Throwable)e);
            }
            return result;
        }

        protected DataSource buildDataSource() throws Exception {
            return new SimpleDataSource(){

                public Connection getConnection() throws SQLException {
                    try {
                        return this.openConnection();
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                }
            };
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return TDEngineResourcePluginParam.class;
        }

        public ResourceType resourceType() {
            return ResourceType.TIME_SERIES;
        }

        public String configComponent() {
            return "TDEngineResourceConfigForm";
        }

        public Class<?> apiClass() {
            return TDEngineResourceApiController.class;
        }
    }
}

