/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.sc.rdc.business.plugin.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.sc.rdc.business.database.RDB;
import com.kdgcsoft.sc.rdc.business.database.impl.HiveDB;
import com.kdgcsoft.sc.rdc.business.database.impl.PGSQL;
import com.kdgcsoft.sc.rdc.business.plugin.vo.ResultResponse;
import com.kdgcsoft.sc.rdc.plugin.api.plugin.vo.ColumnInfo;
import com.kdgcsoft.sc.rdc.plugin.api.plugin.vo.TableInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.metamodel.create.ColumnCreationBuilder;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMaintain {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableMaintain.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TableInfo> getAllTabs(Connection conn, String databaseType, String schemaName) {
        LOGGER.info("\u8fdb\u5165getAllTabs\u65b9\u6cd5,{}", (Object)conn);
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TableInfo> tabList = new ArrayList<TableInfo>();
        try {
            String sql = RDB.forName(databaseType).getTableInfoSQL(schemaName);
            pstm = conn.prepareStatement(sql);
            rs = pstm.executeQuery();
            int colCount = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                TableInfo tableInfo = new TableInfo();
                tableInfo.setTableName(rs.getString(1));
                if (colCount > 1) {
                    tableInfo.setTableMemo(rs.getString(2));
                }
                tabList.add(tableInfo);
            }
            LOGGER.info("\u67e5\u8be2\u5168\u8868\u7ed3\u675f\uff0c\u5171\u6709" + tabList.size() + "\u5f20\u8868,dbId={}", (Object)conn);
        }
        catch (Exception e) {
            try {
                LOGGER.error("\u67e5\u8be2\u5168\u8868\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                TableMaintain.close(null, pstm, rs);
                throw throwable;
            }
            TableMaintain.close(null, pstm, rs);
        }
        TableMaintain.close(null, pstm, rs);
        return tabList;
    }

    public static void close(Connection conn, Statement stm, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stm != null) {
            try {
                stm.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getTriggers(DataSource ds, String tableNames, String dbType, String schemaName) throws SQLException {
        LOGGER.info("\u8fdb\u5165getTriggers\u65b9\u6cd5,{}", (Object)ds);
        Connection conn = ds.getConnection();
        tableNames = tableNames.replace(schemaName.toLowerCase() + ".", "");
        tableNames = tableNames.replace(schemaName.toUpperCase() + ".", "");
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        HashMap<String, String> obj = null;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            String sql = RDB.forName(dbType).getTriggerSql(schemaName, tableNames.split(","));
            pstm = conn.prepareStatement(sql);
            rs = pstm.executeQuery();
            while (rs.next()) {
                obj = new HashMap<String, String>();
                obj.put("tableName", rs.getString(2));
                obj.put("triggerName", rs.getString(1));
                list.add(obj);
            }
            for (Map map : list) {
                String value = null;
                for (Map map2 : result) {
                    if (!map2.get("tableName").equals(map.get("tableName"))) continue;
                    value = map2.get("triggerName") + "," + map.get("triggerName");
                    map2.put("triggerName", value);
                    break;
                }
                if (value != null) continue;
                result.add(map);
            }
            TableMaintain.close(conn, pstm, rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TableMaintain.close(conn, pstm, rs);
        }
        return result;
    }

    public static List<ColumnInfo> queryTableColumns(Connection conn, String schemaName, String tableName) throws Exception {
        JdbcDataContext dc = new JdbcDataContext(conn);
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        Table table = dc.getTableByQualifiedLabel(tableName);
        if (null == table) {
            table = dc.getTableByQualifiedLabel(schemaName + "." + tableName);
        }
        if (table != null) {
            for (Column c : table.getColumns()) {
                ColumnInfo cl = new ColumnInfo();
                cl.setColName(c.getName());
                cl.setColType(c.getNativeType().toUpperCase());
                cl.setMetaModelType(c.getType().getName().toUpperCase());
                cl.setPrimaryKey(c.isPrimaryKey());
                cl.setNullable(c.isNullable().booleanValue());
                if (c.getColumnSize() != null) {
                    cl.setPrecision(c.getColumnSize().intValue());
                }
                cl.setIndex(c.isIndexed());
                cl.setStates("A");
                cl.setColMemo(c.getRemarks());
                colInfos.add(cl);
            }
        } else {
            LOGGER.error("\u8868\u4e0d\u5b58\u5728:" + tableName);
        }
        return colInfos;
    }

    public static List<ColumnInfo> getTableColumns4Hive(Connection conn, String sql) throws Exception {
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        try (PreparedStatement pstm = conn.prepareStatement(sql);
             ResultSet rs = pstm.executeQuery();){
            while (rs.next()) {
                String colName = rs.getString(1);
                String colTyp = rs.getString(2);
                ColumnInfo colInfo = new ColumnInfo();
                colInfo.setColName(colName);
                colInfo.setColType(colTyp.toUpperCase());
                colInfos.add(colInfo);
            }
            LOGGER.info("\u8868\u7ed3\u6784\u4fe1\u606f\uff1a" + ((Object)colInfos).toString());
        }
        return colInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnInfo> getSourceTabStructBySql(Connection conn, String sql) throws Exception {
        LOGGER.info("\u8fdb\u5165getTabStructBySql\u65b9\u6cd5");
        String tmpSql = sql;
        if (tmpSql.contains("##")) {
            tmpSql = tmpSql.replaceAll("##", "'0'");
        }
        if (tmpSql.indexOf("?") >= 0) {
            tmpSql = tmpSql.replaceAll("\\?", "'0'");
        }
        if (tmpSql.matches("^.+'\\$\\{.+\\}'.*$")) {
            tmpSql = tmpSql.replaceAll("^(.+')\\$\\{.+\\}('.*)$", "$10$2");
        } else if (tmpSql.matches("^.+\\$\\{.+\\}.*$")) {
            tmpSql = tmpSql.replaceAll("^(.+)\\$\\{.+\\}(.*)$", "$1'0'$2");
        }
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        PreparedStatement pstm = null;
        try {
            pstm = conn.prepareStatement(tmpSql);
            ResultSetMetaData rsmd = pstm.getMetaData();
            if (null == rsmd) {
                rsmd = pstm.executeQuery().getMetaData();
            }
            int cc = rsmd.getColumnCount();
            for (int i = 1; i <= cc; ++i) {
                ColumnInfo colInfo = new ColumnInfo();
                colInfo.setColName(rsmd.getColumnLabel(i));
                colInfo.setColType(rsmd.getColumnTypeName(i).toUpperCase());
                colInfo.setMetaModelType(TableMaintain.transColumnType(rsmd.getColumnTypeName(i).toUpperCase()));
                colInfo.setPrimaryKey(false);
                colInfo.setNullable(rsmd.isNullable(i) == 1);
                colInfo.setScale(rsmd.getScale(i));
                colInfo.setPrecision(rsmd.getPrecision(i));
                colInfo.setIndex(false);
                colInfo.setStates("A");
                colInfos.add(colInfo);
            }
            LOGGER.info("\u8868\u7ed3\u6784\u4fe1\u606f\uff1a" + ((Object)colInfos).toString());
        }
        finally {
            TableMaintain.close(conn, pstm, null);
        }
        return colInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateTableExist(DataSource ds, String tableName, String schemaName) throws Exception {
        block19: {
            Connection conn = ds.getConnection();
            try {
                JdbcDataContext dc = new JdbcDataContext(conn);
                Table table = null;
                if (StrUtil.isNotBlank((CharSequence)schemaName)) {
                    block18: {
                        try {
                            Schema s = dc.getSchemaByName(schemaName);
                            if (s == null) break block18;
                            table = s.getTableByName(tableName);
                            if (table != null) {
                                boolean bl = true;
                                return bl;
                            }
                            break block19;
                        }
                        catch (Exception exc) {
                            throw new Exception("dbId:" + ds + "\u67e5\u627eSchema\u5931\u8d25:" + schemaName);
                        }
                    }
                    throw new Exception("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u8fde\u63a5!");
                }
                table = dc.getTableByQualifiedLabel(tableName);
                if (table != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return false;
    }

    public static ResultResponse tabSync(DataSource ds, String schemaName, String tableName, List<ColumnInfo> columsInfos, String dbType) throws Exception {
        LOGGER.info("\u8fdb\u5165tabSync\u8868\u540c\u6b65\u65b9\u6cd5");
        ResultResponse response = new ResultResponse();
        try (Connection conn = ds.getConnection();){
            JdbcDataContext dc;
            Table table;
            boolean operateFlag = true;
            for (ColumnInfo colInfo : columsInfos) {
                if (StrUtil.isEmpty((CharSequence)colInfo.getStates())) {
                    LOGGER.error("\u8868\u5b57\u6bb5{}\uff0c\u72b6\u6001\u4e3a\u7a7a", (Object)colInfo.getColName());
                    response.setMessage("\u8868\u5b57\u6bb5" + colInfo.getColName() + "\uff0c\u72b6\u6001\u4e3a\u7a7a");
                    response.setSuccess(false);
                    ResultResponse resultResponse = response;
                    return resultResponse;
                }
                if ("A".equals(colInfo.getStates())) continue;
                operateFlag = false;
                break;
            }
            if (null == (table = (dc = new JdbcDataContext(conn)).getTableByQualifiedLabel(tableName)) && !tableName.contains(".")) {
                table = dc.getTableByQualifiedLabel(schemaName + "." + tableName);
            }
            if (!operateFlag && table == null) {
                LOGGER.error("\u9700\u66f4\u65b0\u7684\u8868\u5df2\u88ab\u5728\u6570\u636e\u5e93\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u8868\u7684\u662f\u5426\u5b58\u5728\uff01");
                response.setMessage("\u9700\u66f4\u65b0\u7684\u8868\u5df2\u88ab\u5728\u6570\u636e\u5e93\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u8868\u7684\u662f\u5426\u5b58\u5728\uff01");
                response.setSuccess(false);
                ResultResponse resultResponse = response;
                return resultResponse;
            }
            if (table != null) {
                operateFlag = false;
            }
            if (operateFlag) {
                ResultResponse resultResponse = TableMaintain.createTable(schemaName, tableName, columsInfos, dc, dbType);
                return resultResponse;
            }
            ResultResponse resultResponse = TableMaintain.modifyTable(schemaName, tableName, columsInfos, dc, dbType);
            return resultResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResultResponse modifyTable(String schemaName, String tableName, List<ColumnInfo> columsInfos, JdbcDataContext dc, String dbType) throws Exception {
        ResultResponse response = new ResultResponse();
        Table table = dc.getTableByQualifiedLabel(tableName);
        if (table == null && null == (table = dc.getTableByQualifiedLabel(schemaName + "." + tableName))) {
            LOGGER.error("\u76ee\u6807\u5e93\u4e0d\u5b58\u5728\u8be5\u8868\uff1a{}", (Object)tableName);
            response.setMessage("\u76ee\u6807\u5e93\u4e0d\u5b58\u5728\u8be5\u8868\uff1a" + tableName);
            response.setSuccess(false);
            return response;
        }
        LOGGER.info("dbType:{}", (Object)dbType);
        RDB db = RDB.forName(dbType);
        for (ColumnInfo colInfo : columsInfos) {
            String sql;
            if ("S".equals(colInfo.getStates())) continue;
            String combinType = colInfo.getColType();
            if (colInfo.getLength() > 0) {
                combinType = combinType + "(" + colInfo.getLength() + ")";
            }
            if (colInfo.getPrecision() > 0) {
                if (colInfo.getScale() > 0) {
                    if (colInfo.getPrecision() < colInfo.getScale()) {
                        LOGGER.error("\u5c0f\u6570\u4f4d\u6570\u5e94\u5c0f\u4e8e\u603b\u957f\u5ea6\uff1a{}", (Object)colInfo.getColName());
                        response.setMessage("\u5c0f\u6570\u4f4d\u6570\u5e94\u5c0f\u4e8e\u603b\u957f\u5ea6\uff1a" + colInfo.getColName());
                        response.setSuccess(false);
                        return response;
                    }
                    combinType = colInfo.getColType() + "(" + colInfo.getPrecision() + "," + colInfo.getScale() + ")";
                } else {
                    combinType = colInfo.getColType() + "(" + colInfo.getPrecision() + ")";
                }
            }
            String colName = colInfo.getColName();
            if ("A".equals(colInfo.getStates())) {
                sql = db.getAddColumnSQL(tableName, colName, combinType);
                LOGGER.info("\u65b0\u589e\u5217:" + sql);
            } else if ("U".equals(colInfo.getStates())) {
                sql = db.getModifyColumnSQL(tableName, colName, combinType);
                LOGGER.info("\u4fee\u6539\u5217:" + sql);
            } else if ("D".equals(colInfo.getStates())) {
                sql = db.getDelColumnSQL(tableName, colName);
                LOGGER.info("\u5220\u9664\u5217:" + sql);
            } else {
                LOGGER.error("\u5217\u72b6\u6001\u5f02\u5e38\uff0c\u975eA/U/D/S");
                response.setMessage("\u5217\u72b6\u6001\u5f02\u5e38\uff0c\u975eA/U/D/S");
                response.setSuccess(false);
                return response;
            }
            PreparedStatement statement = null;
            try {
                statement = dc.getConnection().prepareStatement(sql);
                statement.execute();
            }
            finally {
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException exc) {
                    LOGGER.error("\u4fee\u6539\u8868\u65f6\u5173\u95edstatement\u51fa\u9519", (Throwable)exc);
                    response.setMessage("\u4fee\u6539\u8868\u65f6\u5173\u95edstatement\u51fa\u9519");
                    response.setException(exc);
                    response.setSuccess(false);
                    return response;
                }
            }
        }
        List<ColumnInfo> columnInfoList = columsInfos.stream().filter(col -> col.getStates().equals("A") || col.getStates().equals("U")).collect(Collectors.toList());
        Schema schema = StrUtil.isEmpty((CharSequence)schemaName) ? dc.getDefaultSchema() : (db instanceof PGSQL ? dc.getDefaultSchema() : dc.getSchemaByName(schemaName));
        TableMaintain.setDefaultAndIndexAndComment(columnInfoList, db, schema.getName(), tableName, dc, response);
        return response;
    }

    private static ResultResponse createTable(String schemaName, String tableName, List<ColumnInfo> columsInfos, JdbcDataContext dc, String dbType) throws Exception {
        ResultResponse response = new ResultResponse();
        Table table = dc.getTableByQualifiedLabel(tableName);
        if (table != null) {
            LOGGER.error("\u76ee\u6807\u5e93\u5df2\u5b58\u5728\u8be5\u8868\uff1a{}", (Object)tableName);
            response.setSuccess(false);
            response.setMessage("\u76ee\u6807\u5e93\u5df2\u5b58\u5728\u8be5\u8868\uff1a" + tableName);
            return response;
        }
        dc.executeUpdate(callback -> {
            Table table1;
            String simpleTable = tableName.substring(tableName.indexOf(".") + 1);
            Schema schema = StrUtil.isEmpty((CharSequence)schemaName) ? dc.getDefaultSchema() : dc.getSchemaByName(schemaName);
            TableCreationBuilder builder = callback.createTable(schema, simpleTable);
            RDB db = RDB.forName(dbType);
            for (ColumnInfo colInfo : columsInfos) {
                TableMaintain.createRowDeal(builder, colInfo, response);
                if (response.isSuccess()) continue;
                return;
            }
            try {
                table1 = builder.execute();
            }
            catch (Exception e) {
                LOGGER.error("\u8868\u521b\u5efa\u5931\u8d25", (Throwable)e);
                response.setException(e);
                response.setMessage("\u8868\u521b\u5efa\u5931\u8d25");
                response.setSuccess(false);
                return;
            }
            if (table1 != null) {
                LOGGER.info("\u8868\u521b\u5efa\u6210\u529f\uff0c\u5f00\u59cb\u5efa\u7acb\u7d22\u5f15\uff0c\u5907\u6ce8");
                TableMaintain.setDefaultAndIndexAndComment(columsInfos, db, schema.getName(), tableName, dc, response);
            } else {
                LOGGER.info("\u8868\u521b\u5efa\u5931\u8d25\uff0c\u5f00\u59cb\u5efa\u7acb\u7d22\u5f15\uff0c\u5907\u6ce8");
            }
        });
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long executeSql(RDB rdb, Connection conn, List<String> sqlList) throws SQLException {
        Statement stm = null;
        long updateCount = 0L;
        try {
            stm = conn.createStatement();
            if (rdb instanceof HiveDB) {
                for (String sql : sqlList) {
                    boolean result = stm.execute(sql);
                    if (!result) continue;
                    updateCount += (long)stm.getUpdateCount();
                }
            } else {
                int[] countArr;
                for (String sql : sqlList) {
                    stm.addBatch(sql);
                }
                for (int value : countArr = stm.executeBatch()) {
                    updateCount += (long)value;
                }
            }
            Long l = updateCount;
            return l;
        }
        finally {
            TableMaintain.close(null, stm, null);
        }
    }

    private static String transColumnType(String type) throws Exception {
        switch (type) {
            case "LONG": {
                return "BIGINT";
            }
            case "TEXT": {
                return "CLOB";
            }
            case "VARCHAR2": {
                return "VARCHAR";
            }
            case "NVARCHAR2": {
                return "NVARCHAR";
            }
            case "DATETIME": {
                return "TIMESTAMP";
            }
            case "INT": {
                return "INTEGER";
            }
            case "BINARY_FLOAT": {
                return "FLOAT";
            }
            case "BINARY_DOUBLE": {
                return "DOUBLE";
            }
        }
        return type;
    }

    private static void createRowDeal(TableCreationBuilder builder, ColumnInfo colInfo, ResultResponse response) {
        if (StrUtil.isNotBlank((CharSequence)colInfo.getColName()) && StrUtil.isNotBlank((CharSequence)colInfo.getMetaModelType())) {
            String colName = colInfo.getColName();
            ColumnType type = ColumnTypeImpl.valueOf((String)colInfo.getMetaModelType());
            if (type == null) {
                LOGGER.error("\u5217\u7c7b\u578b\u975e\u81ea\u7136\u7c7b\u578b\uff1a" + colInfo.getMetaModelType());
                response.setMessage("\u5217\u7c7b\u578b\u975e\u81ea\u7136\u7c7b\u578b\uff1a" + colInfo.getMetaModelType());
                response.setSuccess(false);
                return;
            }
            if (colInfo.getPrecision() > 0 && !type.isTimeBased()) {
                if (colInfo.getScale() > 0) {
                    if (colInfo.getPrecision() < colInfo.getScale()) {
                        LOGGER.error("\u5c0f\u6570\u4f4d\u6570\u5e94\u5c0f\u4e8e\u603b\u957f\u5ea6\uff1a" + colInfo.getColName());
                        response.setMessage("\u5c0f\u6570\u4f4d\u6570\u5e94\u5c0f\u4e8e\u603b\u957f\u5ea6\uff1a" + colInfo.getColName());
                        response.setSuccess(false);
                        return;
                    }
                    String combinType = "DECIMAL(" + colInfo.getPrecision() + "," + colInfo.getScale() + ")";
                    if (colInfo.isPrimaryKey()) {
                        ((ColumnCreationBuilder)((ColumnCreationBuilder)builder.withColumn(colName).ofNativeType(combinType)).asPrimaryKey()).nullable(colInfo.isNullable());
                    } else {
                        ((ColumnCreationBuilder)builder.withColumn(colName).ofNativeType(combinType)).nullable(colInfo.isNullable());
                    }
                } else if (colInfo.isPrimaryKey()) {
                    ((ColumnCreationBuilder)((ColumnCreationBuilder)((ColumnCreationBuilder)builder.withColumn(colName).ofType(type)).ofSize(colInfo.getPrecision())).asPrimaryKey()).nullable(colInfo.isNullable());
                } else {
                    ((ColumnCreationBuilder)((ColumnCreationBuilder)builder.withColumn(colName).ofType(type)).ofSize(colInfo.getPrecision())).nullable(colInfo.isNullable());
                }
            } else if (colInfo.isPrimaryKey()) {
                ((ColumnCreationBuilder)((ColumnCreationBuilder)builder.withColumn(colName).ofType(type)).asPrimaryKey()).nullable(colInfo.isNullable());
            } else {
                ((ColumnCreationBuilder)builder.withColumn(colName).ofType(type)).nullable(colInfo.isNullable());
            }
            response.setSuccess(true);
        } else {
            LOGGER.error("\u7ef4\u62a4\u7684\u5217\u540d\u6216\u5217\u7c7b\u578b\u6709\u4e3a\u7a7a\u3002\u5217\u540d\uff1a" + colInfo.getColName() + ",\u7c7b\u578b\uff1a" + colInfo.getColType());
            response.setMessage("\u7ef4\u62a4\u7684\u5217\u540d\u6216\u5217\u7c7b\u578b\u6709\u4e3a\u7a7a\u3002\u5217\u540d\uff1a" + colInfo.getColName() + ",\u7c7b\u578b\uff1a" + colInfo.getColType());
            response.setSuccess(false);
        }
    }

    private static void setDefaultAndIndexAndComment(List<ColumnInfo> columnInfos, RDB db, String schemaName, String tableName, JdbcDataContext dc, ResultResponse response) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnInfo col : columnInfos) {
            sqls.clear();
            String tmp = "";
            Table table = dc.getTableByQualifiedLabel(tableName);
            if (table == null) {
                table = dc.getTableByQualifiedLabel(schemaName + "." + tableName);
            }
            Column column = table.getColumnByName(col.getColName());
            if (col.isIndex() && !col.isPrimaryKey() && !column.isIndexed()) {
                tmp = db.getCreateIndexSQL(schemaName, tableName, col.getColName());
                sqls.add(tmp);
            }
            if (!StrUtil.isEmpty((CharSequence)col.getColMemo())) {
                String colType = col.getColType();
                if (col.getLength() > 0) {
                    colType = colType + "(" + col.getLength() + ")";
                }
                if (col.getPrecision() > 0) {
                    colType = col.getScale() > 0 ? col.getColType() + "(" + col.getPrecision() + "," + col.getScale() + ")" : col.getColType() + "(" + col.getPrecision() + ")";
                }
                tmp = db.getColumnCommentSQL(schemaName, tableName, col.getColName(), colType, col.getColMemo());
                sqls.add(tmp);
            }
            boolean isGUID = col.getColName().equals("DCGUID");
            tmp = db.getSetColumnDefaultSQL(schemaName, tableName, col.getColName(), col.getDefaultValue(), isGUID);
            if (!StrUtil.isEmpty((CharSequence)tmp)) {
                sqls.add(tmp);
            }
            try {
                TableMaintain.executeSql(db, dc.getConnection(), sqls);
            }
            catch (Exception e) {
                LOGGER.error("\u521b\u5efa\u9ed8\u8ba4\u503c\u6216\u7d22\u5f15\u6216\u5907\u6ce8\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(sqls), (Object)e);
                response.setException(e);
                response.setMessage("\u521b\u5efa\u9ed8\u8ba4\u503c\u6216\u7d22\u5f15\u6216\u5907\u6ce8\u5931\u8d25\uff1a" + JSON.toJSONString(sqls));
                response.setSuccess(false);
            }
        }
    }
}

