/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.sc.rdc.business.database.impl;

import com.kdgcsoft.sc.rdc.business.database.RDB;
import java.util.Properties;

public final class OracleDB
extends RDB {
    @Override
    public String getTestSQL() {
        return "select 1 from dual";
    }

    @Override
    public String getDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String getTableInfoSQL(String schemaName) {
        return "select a.TABLE_NAME,b.comments as table_comment from all_tables a ,all_tab_comments b where a.TABLE_NAME = b.table_name AND a.OWNER = b.OWNER and a.OWNER = '" + schemaName.toUpperCase() + "'";
    }

    @Override
    public String getTriggerSql(String schemaName, String[] tableNames) {
        String tablenameList = this.toSQLStrList(tableNames);
        return "select t.TRIGGER_NAME,t.TABLE_NAME from all_triggers t where t.OWNER = '" + schemaName.toUpperCase() + "'   and t.TABLE_NAME in " + tablenameList;
    }

    @Override
    public String getSysDateSQL(String tableName) {
        return "select sysdate from dual";
    }

    @Override
    protected String getGUIDFuncStr() {
        return "sys_guid()";
    }

    @Override
    public String getLinkStr() {
        return "jdbc:oracle:thin:@[IP\u6216\u4e3b\u673a\u540d]:1521:[\u6570\u636e\u5e93\u540d]";
    }

    @Override
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        props.put("oracle.net.CONNECT_TIMEOUT", "10000");
        props.put("oracle.jdbc.ReadTimeout", "1800000");
        return props;
    }
}

