/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.sc.rdc.business.database.impl;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.sc.rdc.business.database.RDB;
import java.util.Properties;

public final class MySqlDB
extends RDB {
    @Override
    public String getTestSQL() {
        return "SELECT 1";
    }

    @Override
    public String getDriver() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public String getTableInfoSQL(String schemaName) {
        return "SELECT concat(table_schema,'.',table_name) table_name,table_comment FROM information_schema.tables WHERE table_schema='" + schemaName + "'";
    }

    @Override
    public String getTriggerSql(String schemaName, String[] tableNames) {
        String tablenameList = this.toSQLStrList(tableNames);
        return "select t.TRIGGER_NAME,t.EVENT_OBJECT_TABLE as table_name from information_schema.triggers t where t.TRIGGER_SCHEMA = '" + schemaName + "'   and t.EVENT_OBJECT_TABLE in" + tablenameList;
    }

    @Override
    public String getModifyColumnSQL(String tableName, String colName, String combinType) {
        return "alter table " + tableName + " modify `" + colName + "` " + combinType;
    }

    @Override
    public String getAddColumnSQL(String tableName, String colName, String combinType) {
        return "alter table " + tableName + " add `" + colName + "` " + combinType;
    }

    @Override
    public String getDelColumnSQL(String tableName, String colName) {
        return "alter table " + tableName + " drop column `" + colName + "`";
    }

    @Override
    public String getSysDateSQL(String tableName) {
        return "SELECT CURRENT_TIMESTAMP";
    }

    @Override
    protected String getGUIDFuncStr() {
        return "uuid()";
    }

    @Override
    public String getLinkStr() {
        return "jdbc:mysql://[IP\u6216\u4e3b\u673a\u540d]:3306/[\u6570\u636e\u5e93\u540d]";
    }

    @Override
    public String getSimpleColumnName(String columnName) {
        return String.format("`%s`", columnName);
    }

    @Override
    public String getColumnCommentSQL(String schemaName, String tableName, String colName, String colType, String memo) {
        String sql = "ALTER TABLE " + (schemaName == null ? "" : schemaName + ".") + tableName + " MODIFY COLUMN `" + colName + "` " + colType + " COMMENT '" + memo + "'";
        return sql;
    }

    @Override
    public String getCreateIndexSQL(String schemaName, String tableName, String colName) {
        colName = colName.replaceAll("\"", "");
        String sql = "CREATE INDEX INX_" + tableName + "_" + colName + " ON " + (schemaName == null ? "" : schemaName + ".") + tableName + " (`" + colName + "`)";
        return sql;
    }

    @Override
    public String getSetColumnDefaultSQL(String schemaName, String tableName, String colName, String defaultValue, boolean isGUID) {
        String sql = "";
        if (isGUID) {
            sql = "ALTER TABLE " + (schemaName == null ? "" : schemaName + ".") + tableName + " ALTER COLUMN `" + colName + "` SET DEFAULT " + this.getGUIDFuncStr();
        } else if (!StrUtil.isEmpty((CharSequence)defaultValue)) {
            sql = "ALTER TABLE " + (schemaName == null ? "" : schemaName + ".") + tableName + " ALTER COLUMN `" + colName + "` SET DEFAULT '" + defaultValue + "'";
        }
        return sql;
    }

    @Override
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        props.put("rewriteBatchedStatements", "true");
        return props;
    }
}

