/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.sc.rdc.business.database.impl;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.sc.rdc.business.database.RDB;

public final class KingbaseESDB
extends RDB {
    @Override
    public String getTestSQL() {
        return "select 1 from dual";
    }

    @Override
    public String getDriver() {
        return "com.kingbase.Driver";
    }

    @Override
    public String getTableInfoSQL(String schemaName) {
        return "select a.object_name as TABLE_NAME,b.comments as table_comment from SYS_NAMESPACE t   join ALL_OBJECTS A on T.OID=A.NAMESPACE   left join ALL_TAB_COMMENTS b on (a.object_name = b.table_name) WHERE A.OBJECT_TYPE IN('TABLE')   AND T.NSPNAME='" + schemaName + "'";
    }

    @Override
    public String getTriggerSql(String schemaName, String[] tableNames) {
        String tablenameList = this.toSQLStrList(tableNames);
        return "select t.tgname as trigger_name, t.tablename as table_name from sys_triggers t where t.schemaname = '" + schemaName + "'   and t.tablename in" + tablenameList;
    }

    @Override
    public String getSysDateSQL(String tableName) {
        return "select now() from dual";
    }

    @Override
    public String getModifyColumnSQL(String tableName, String colName, String combinType) {
        return "alter table " + tableName + " alter column  \"" + colName + "\" type " + combinType;
    }

    @Override
    protected String getGUIDFuncStr() {
        return "encode(SYS_GUID(), 'hex')";
    }

    @Override
    public String getSetColumnDefaultSQL(String schemaName, String tableName, String colName, String defaultValue, boolean isGUID) {
        String sql = "";
        if (isGUID) {
            sql = "ALTER TABLE " + (schemaName == null ? "" : schemaName + ".") + tableName + " ALTER COLUMN " + colName + " SET DEFAULT " + this.getGUIDFuncStr();
        } else if (!StrUtil.isEmpty((CharSequence)defaultValue)) {
            sql = "ALTER TABLE " + (schemaName == null ? "" : schemaName + ".") + tableName + " ALTER COLUMN " + colName + " SET DEFAULT '" + defaultValue + "'";
        }
        return sql;
    }

    @Override
    public String getLinkStr() {
        return "jdbc:kingbase://[IP\u6216\u4e3b\u673a\u540d]/[\u6570\u636e\u5e93\u540d]";
    }
}

