/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.sc.rdc.business.database;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.sc.rdc.business.database.impl.DB2DB;
import com.kdgcsoft.sc.rdc.business.database.impl.DamengDB;
import com.kdgcsoft.sc.rdc.business.database.impl.H2DB;
import com.kdgcsoft.sc.rdc.business.database.impl.HiveDB;
import com.kdgcsoft.sc.rdc.business.database.impl.KingbaseESDB;
import com.kdgcsoft.sc.rdc.business.database.impl.MySqlDB;
import com.kdgcsoft.sc.rdc.business.database.impl.OracleDB;
import com.kdgcsoft.sc.rdc.business.database.impl.PGSQL;
import com.kdgcsoft.sc.rdc.business.database.impl.SQLServer2000DB;
import com.kdgcsoft.sc.rdc.business.database.impl.SQLServerDB;
import com.kdgcsoft.sc.rdc.business.database.impl.TDengine;
import com.kdgcsoft.sc.rdc.business.database.impl.TDengine_RS;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RDB {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RDB.class);
    public static final String ORACLE = "Oracle";
    public static final String DAMENG = "DAMENG";
    public static final String MYSQL = "MySQL";
    public static final String KINGBASEES = "KingbaseES";
    public static final String SQLSERVER = "SQLServer";
    public static final String SQLSERVER2000 = "SQLServer 2000";
    public static final String H2 = "H2";
    public static final String DB2 = "DB2";
    public static final String HIVE = "Hive";
    public static final String PGSQL = "PostgreSQL";
    public static final String TDENGINE = "TDengine";
    public static final String TDENGINE_RS = "TDengine-RS";

    public static RDB forName(String dbType) {
        switch (dbType) {
            case "Oracle": {
                return new OracleDB();
            }
            case "DAMENG": {
                return new DamengDB();
            }
            case "MySQL": {
                return new MySqlDB();
            }
            case "KingbaseES": {
                return new KingbaseESDB();
            }
            case "SQLServer": {
                return new SQLServerDB();
            }
            case "SQLServer 2000": {
                return new SQLServer2000DB();
            }
            case "H2": {
                return new H2DB();
            }
            case "DB2": {
                return new DB2DB();
            }
            case "Hive": {
                return new HiveDB();
            }
            case "PostgreSQL": {
                return new PGSQL();
            }
            case "TDengine": {
                return new TDengine();
            }
            case "TDengine-RS": {
                return new TDengine_RS();
            }
        }
        LOGGER.error("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a{}\u3002\u5c1d\u8bd5\u6309\u7167Oracle\u8bed\u6cd5\u8fdb\u884c\u5904\u7406\u3002" + dbType);
        return new OracleDB();
    }

    public abstract String getTestSQL();

    public abstract String getLinkStr();

    public abstract String getDriver();

    public abstract String getTableInfoSQL(String var1);

    public abstract String getTriggerSql(String var1, String[] var2);

    public abstract String getSysDateSQL(String var1);

    protected abstract String getGUIDFuncStr();

    public String getAddColumnSQL(String tableName, String colName, String combinType) {
        return "alter table " + tableName + " add \"" + colName + "\" " + combinType;
    }

    public String getModifyColumnSQL(String tableName, String colName, String combinType) {
        return "alter table " + tableName + " modify \"" + colName + "\" " + combinType;
    }

    public String getDelColumnSQL(String tableName, String colName) {
        return "alter table " + tableName + " drop column \"" + colName + "\"";
    }

    public String getSimpleColumnName(String columnName) {
        return String.format("\"%s\"", columnName);
    }

    public String getConcatChar() {
        return "||";
    }

    public String getSetColumnDefaultSQL(String schemaName, String tableName, String colName, String defaultValue, boolean isGUID) {
        String sql = "";
        if (isGUID) {
            sql = "alter table " + (schemaName == null ? "" : schemaName + ".") + tableName + " modify " + colName + " default (" + this.getGUIDFuncStr() + ")";
        } else if (!StrUtil.isEmpty((CharSequence)defaultValue)) {
            sql = "alter table " + (schemaName == null ? "" : schemaName + ".") + tableName + " modify " + colName + " default ('" + defaultValue + "')";
        } else {
            LOGGER.warn("\u6ca1\u6709\u8bbe\u7f6e\u5217\u7684\u9ed8\u8ba4\u503c\uff0c\u4e0d\u9700\u8981\u6267\u884c\u9ed8\u8ba4\u503c\u8bbe\u7f6eSQL\u3002\u8868\uff1a{}\uff0c\u5217\uff1a{}", (Object)tableName, (Object)colName);
        }
        return sql;
    }

    public String getCreateIndexSQL(String schemaName, String tableName, String colName) {
        String sql = "CREATE INDEX INX_" + tableName + "_" + colName + " ON " + (schemaName == null ? "" : schemaName + ".") + tableName + " (" + colName + ")";
        return sql;
    }

    public String getColumnCommentSQL(String schemaName, String tableName, String colName, String colType, String memo) {
        String sql = "COMMENT ON COLUMN " + (schemaName == null ? "" : schemaName + ".") + tableName + "." + colName + " IS '" + memo + "'";
        return sql;
    }

    public String getDropIndexSQL(String schemaName, String tableName, String colName) {
        String sql = "DROP INDEX INX_" + tableName + "_" + colName + " ON " + (schemaName == null ? "" : schemaName + ".") + tableName;
        return sql;
    }

    protected String toSQLStrList(String[] names) {
        String rs = "('')";
        if (names != null && names.length != 0) {
            StringBuilder result = new StringBuilder("(");
            for (String string : names) {
                result.append("'" + this.null2String(string) + "',");
            }
            rs = result.substring(0, result.length() - 1) + ")";
        }
        return rs;
    }

    private String null2String(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }
}

