/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.rabbitmq.reader;

import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.plugin.api.DataNumEstimateType;
import com.kdgcsoft.plugin.api.PluginContext;
import com.kdgcsoft.plugin.api.PluginType;
import com.kdgcsoft.plugin.api.data.IDataReadPlugin;
import com.kdgcsoft.plugin.api.message.MessageBoxWrapper;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.record.Item;
import com.kdgcsoft.plugin.api.record.ItemType;
import com.kdgcsoft.plugin.api.record.Record;
import com.kdgcsoft.plugin.collect.rabbitmq.reader.MessageTuple;
import com.kdgcsoft.plugin.collect.rabbitmq.reader.RabbitMQReaderPluginParam;
import com.kdgcsoft.plugin.rabbit.common.RabbitConnector;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class RabbitMQReaderPlugin
extends Plugin {
    public RabbitMQReaderPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class RabbitMQIDataReadPlugin
    extends MessageBoxWrapper
    implements IDataReadPlugin,
    ExtensionPoint {
        private static final int CAPACITY = 65536;
        private RabbitMQReaderPluginParam pluginParam;
        private Connection connection;
        private Channel channel;
        private BlockingQueue<MessageTuple> queue;
        private AtomicLong lastUpdate;
        private volatile boolean stopped = false;
        private boolean continuousListen;
        private long maxWaitTime;
        private PluginContext context;

        public void init(PluginContext context, PluginParam param) throws Exception {
            this.pluginParam = (RabbitMQReaderPluginParam)param;
            this.context = context;
            this.queue = new ArrayBlockingQueue<MessageTuple>(65536);
            long connectBegin = System.currentTimeMillis();
            this.connection = RabbitConnector.connectionFactory((PluginContext)context, (String)this.pluginParam.getResourceCode()).newConnection();
            long connectEnd = System.currentTimeMillis();
            this.mb.sendResourceConnectInfo(context.flowCode(), context.taskCode(), context.jobCode(), this.pluginParam.getResourceCode());
            this.mb.writeLog("\u8fde\u63a5RabbitMQ\u8017\u65f6: {}ms", new Object[]{connectEnd - connectBegin});
            this.channel = this.connection.createChannel();
            this.lastUpdate = new AtomicLong(System.currentTimeMillis());
            this.mb.writeLog("\u76d1\u542c\u7b49\u5f85\u65f6\u95f4\uff1a{}", new Object[]{this.pluginParam.getListenWaitTime()});
            this.continuousListen = this.pluginParam.getListenWaitTime() <= 0;
            this.maxWaitTime = this.continuousListen ? Long.MAX_VALUE : TimeUnit.MINUTES.toMillis(this.pluginParam.getListenWaitTime());
        }

        public void begin() throws Exception {
            this.lastUpdate.set(System.currentTimeMillis());
            this.channel.basicConsume(this.pluginParam.getQueue(), false, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    long deliveryTag = envelope.getDeliveryTag();
                    if (!stopped) {
                        try {
                            lastUpdate.set(System.currentTimeMillis());
                            queue.put(new MessageTuple(deliveryTag, new String(body)));
                        }
                        catch (Exception e) {
                            mb.writeExceptionLog(e);
                        }
                    }
                }
            });
            if (!this.continuousListen) {
                Thread t = new Thread(() -> {
                    do {
                        try {
                            TimeUnit.MINUTES.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (System.currentTimeMillis() - this.lastUpdate.get() <= this.maxWaitTime);
                    this.stopped = true;
                });
                t.setDaemon(true);
                t.start();
            }
        }

        public boolean hasNext() throws Exception {
            return !this.stopped || this.queue.size() != 0;
        }

        public Record next() throws Exception {
            MessageTuple messageTuple = this.continuousListen ? this.queue.take() : this.queue.poll(1L, TimeUnit.MINUTES);
            if (null == messageTuple) {
                return null;
            }
            String msg = messageTuple.getMsg();
            long deliveryTag = messageTuple.getDeliveryTag();
            this.channel.basicAck(deliveryTag, true);
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)msg);
                Set set = jsonObject.entrySet();
                Record record = new Record();
                for (Map.Entry entry : set) {
                    record.add(new Item((String)entry.getKey(), ItemType.STRING, (Serializable)((Object)entry.getValue().toString())));
                }
                return record;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\uff1a" + msg);
            }
        }

        public long estimateDataNum() {
            return 0L;
        }

        public DataNumEstimateType estimateType() {
            return DataNumEstimateType.CANNOT_ESTIMATE;
        }

        public void end() throws Exception {
            this.stopped = true;
            if (null != this.channel) {
                this.channel.close();
                this.channel = null;
            }
            if (null != this.connection) {
                this.connection.close();
                this.connection = null;
                this.mb.sendResourceDisconnectInfo(this.context.flowCode(), this.context.taskCode(), this.context.jobCode(), this.pluginParam.getResourceCode());
            }
            if (null != this.queue) {
                this.queue.clear();
                this.queue = null;
            }
            this.mb.writeLog("RabbitMQ\u8bfb\u63d2\u4ef6\u505c\u6b62\u8bfb\u53d6Queue[{}]\u6d88\u606f.", new Object[]{this.pluginParam.getQueue()});
        }

        public PluginType type() {
            return PluginType.READER;
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return RabbitMQReaderPluginParam.class;
        }

        public String configComponent() {
            return "RabbitMQReaderConfigForm";
        }
    }
}

