package com.kdgcsoft.power.filestore;

import java.io.File;

import com.kdgcsoft.power.filestore.strategy.IKeyStrategy;
import com.kdgcsoft.power.filestore.strategy.UUIDKeyStrategy;

/**
 * 使用UUID作为文件Key，并基于UUID创建目录层级的本地磁盘文件存储库
 * @author hling
 *
 */
public class UUIDSimpleFileStore extends SimpleFileStore {
	
	private static IKeyStrategy strategy = new UUIDKeyStrategy();
	
	public UUIDSimpleFileStore(File rootPath) {
		super(rootPath, strategy);
	}
	
	public UUIDSimpleFileStore(String strRootPath) {
		super(strRootPath, strategy);
	}
}
