package com.kdgcsoft.power.filestore;

import java.io.File;

import com.kdgcsoft.power.filestore.strategy.IKeyStrategy;
import com.kdgcsoft.power.filestore.strategy.TimeStampKeyStrategy;

/**
 * 使用时间戳+4位序号作为文件Key，并基于时间戳创建年/月/日三级目录层级的本地磁盘文件存储库
 * 其中，4位序号在同一秒内递增，每秒内的序号都从1开始。即最多支持一秒内存储9999个文件。
 * @author hling
 *
 */
public class TimeStampSimpleFileStore extends SimpleFileStore {
	
	private static IKeyStrategy strategy = new TimeStampKeyStrategy();
	
	public TimeStampSimpleFileStore(File rootPath) {
		super(rootPath, strategy);
	}
	
	public TimeStampSimpleFileStore(String strRootPath) {
		super(strRootPath, strategy);
	}

}
