package com.kdgcsoft.power.filestore;

/**
 * 查询参数，包含关键字、元数据查询条件、最大返回条数
 * @author hling
 */
public class SearchParameter {
	/** 全文搜索的关键字 */
	private String keyword;
	
	/** 最大返回条数，小于等于0表示不限制。 */
	private long limit = 0;
	
	/** 查询条件表达式。例：@类型="执法" and (@种类="药品" or @编号=3)*/
	private String conditions = null;
	
	public SearchParameter() {}

	public SearchParameter(String keyword) {
		this.keyword = keyword;
	}
	
	public String getKeyword() {
		return keyword;
	}

	/**
	 * 设置全文检索的关键字
	 * @param keyword 全文检索关键字
	 */
	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	/**
	 * 返回最大返回条数。
	 * @return 条数限制
	 */
	public long getLimit() {
		return limit;
	}

	/**
	 * 设置最大返回条数。
	 * @param limit 返回条数，小于等于0表示不限制。
	 */
	public void setLimit(long limit) {
		this.limit = limit;
	}

	/**
	 * 返回查询条件表达式
	 * @return 条件表达式
	 */
	public String getConditions() {
		return conditions;
	}

	/**
	 * 设置查询条件表达式。元数据名称前要加@。暂不支持日期条件。
	 * @param conditions 查询条件，例：@类型="执法" and (@种类="药品" or @编号=3)
	 */
	public void setConditions(String conditions) {
		this.conditions = conditions;
	}

	@Override
	public String toString() {
		return "查询条件 [keyword=" + keyword + ", limit=" + limit + ", conditions=" + conditions + "]";
	}

}
