package com.kdgcsoft.power.filestore;

import java.io.File;
import java.io.InputStream;

public abstract class AbstractFileStore implements FileStore {
	
	public final static String DEFAULT_STORE_NAME = "DefaultStore";
	
	/**
	 * 检查仓库名称是否合法。只允许包含字母、汉字、数字、减号、下划线。
	 * @param name 仓库名称
	 * @throws FileStoreException 名称不合法时抛出的异常
	 */
	protected static void checkName(final String name) throws FileStoreException {
		if (name == null || "".equals(name)) {
			throw new FileStoreException("存储库的名称不能为空！");
		}
		
		for (int i = 0; i < name.length(); i++) {
			char ch = name.charAt(i);
			if (!Character.isLetterOrDigit(ch) && "_-".indexOf(name.charAt(i)) < 0) {
				throw new FileStoreException("存储库的名称必须是字母、汉字、数字、减号、下划线组成！");
			}
		}

		return;
	}
	
	/* (non-Javadoc)
	 * @see com.kdgcsoft.power.filestore.FileStore#putFile(java.io.File)
	 */
	public FileInfo putFile(final File file) throws FileStoreException {
		return putFile(file, file.getName());
	}
	
//	/* (non-Javadoc)
//	 * @see com.kdgcsoft.power.filestore.FileStore#putFile(java.io.File, java.lang.String)
//	 */
//	public FileInfo putFile(final File file, final String fileName) throws FileStoreException {
//		return putFile(file, fileName, "");
//	}
	
	/* (non-Javadoc)
	 * @see com.kdgcsoft.power.filestore.FileStore#putFileAsStream(java.io.InputStream)
	 */
	public FileInfo putFileAsStream(final InputStream inputStream) throws FileStoreException {
		return putFileAsStream(inputStream, null);
	}
	
//	/* (non-Javadoc)
//	 * @see com.kdgcsoft.power.filestore.FileStore#putFileAsStream(java.io.InputStream, java.lang.String)
//	 */
//	public FileInfo putFileAsStream(final InputStream inputStream, final String fileName) throws FileStoreException {
//		return putFileAsStream(inputStream, fileName, "");
//	}
}
