/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filestore;

import com.kdgcsoft.power.filestore.FileInfo;
import com.kdgcsoft.power.filestore.FileStore;
import com.kdgcsoft.power.filestore.FileStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleFileStore
implements FileStore {
    private static Logger logger = LoggerFactory.getLogger(SimpleFileStore.class);
    private File rootPath;

    SimpleFileStore(File rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public boolean supportFullTextSearch() {
        return false;
    }

    @Override
    public void setLoginAccount(String user, String password) {
    }

    @Override
    public String putFile(File file, String StoreFileName, String relativePath) throws FileStoreException {
        logger.info("\u5f00\u59cb\u5b58\u50a8\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
        String uuid = UUID.randomUUID().toString();
        File dir = this.getStorageDir(uuid);
        String filename = StoreFileName == null || "".equals(StoreFileName) ? file.getName() : FilenameUtils.getName((String)StoreFileName);
        filename = String.valueOf(uuid) + "_" + filename;
        try {
            FileUtils.copyFile((File)file, (File)new File(dir, filename));
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw new FileStoreException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
        }
        logger.info("\u5b58\u50a8\u6587\u4ef6\u7ed3\u675f\u3002uuid\uff1a{}", (Object)uuid);
        return uuid;
    }

    @Override
    public String putFileAsStream(InputStream inputStream, String StoreFileName, String relativePath) throws FileStoreException {
        logger.info("\u5f00\u59cb\u5b58\u50a8\u6587\u4ef6\u6d41\uff1a{}", (Object)StoreFileName);
        String uuid = UUID.randomUUID().toString();
        File dir = this.getStorageDir(uuid);
        String filename = FilenameUtils.getName((String)StoreFileName);
        filename = String.valueOf(uuid) + "_" + filename;
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(dir, filename));
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw new FileStoreException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
        }
        logger.info("\u5b58\u50a8\u6587\u4ef6\u6d41\u7ed3\u675f\u3002uuid\uff1a{}", (Object)uuid);
        return uuid;
    }

    @Override
    public FileInfo getFile(String uuid) throws FileStoreException {
        logger.info("\u5f00\u59cb\u83b7\u53d6\u6587\u4ef6\uff1a{}", (Object)uuid);
        File file = this.getFileDirectly(uuid);
        if (file == null) {
            logger.warn("\u6587\u4ef6\u6ca1\u627e\u5230");
            return null;
        }
        FileInfo info = new FileInfo();
        info.setUUID(uuid);
        info.setFilesize(file.length());
        try {
            try {
                info.setInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                logger.error("\u67e5\u8be2\u8fc7\u7a0b\u4e2d\u6587\u4ef6\u88ab\u5220\u9664:{}", (Object)uuid);
                throw new FileStoreException("\u67e5\u8be2\u8fc7\u7a0b\u4e2d\u6587\u4ef6\u88ab\u5220\u9664:" + uuid, e);
            }
        }
        finally {
            logger.info("\u7ed3\u675f\u83b7\u53d6\u6587\u4ef6\u6d41\uff1a{}", (Object)uuid);
        }
        return info;
    }

    @Override
    public InputStream getFileAsStream(String uuid) throws FileStoreException {
        logger.info("\u5f00\u59cb\u83b7\u53d6\u6587\u4ef6\u6d41\uff1a{}", (Object)uuid);
        File file = this.getFileDirectly(uuid);
        if (file == null) {
            logger.warn("\u6587\u4ef6\u6ca1\u627e\u5230");
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            logger.error("\u67e5\u8be2\u8fc7\u7a0b\u4e2d\u6587\u4ef6\u88ab\u5220\u9664:{}", (Object)uuid);
            throw new FileStoreException("\u67e5\u8be2\u8fc7\u7a0b\u4e2d\u6587\u4ef6\u88ab\u5220\u9664:" + uuid, e);
        }
        finally {
            logger.info("\u7ed3\u675f\u83b7\u53d6\u6587\u4ef6\u6d41\uff1a{}", (Object)uuid);
        }
    }

    private File getFileDirectly(final String uuid) throws FileStoreException {
        try {
            UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            logger.error("\u4e0d\u662f\u5408\u6cd5\u7684UUID:{}", (Object)uuid);
            throw new FileStoreException("\u4e0d\u662f\u5408\u6cd5\u7684UUID:" + uuid, e);
        }
        String relPath = this.getRelativePathByUUID(uuid);
        File dir = new File(FilenameUtils.concat((String)this.rootPath.getAbsolutePath(), (String)relPath));
        Iterator iter = FileUtils.iterateFiles((File)dir, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(uuid);
            }

            public boolean accept(File dir, String name) {
                return false;
            }
        }, null);
        File result = null;
        if (iter.hasNext()) {
            result = (File)iter.next();
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    @Override
    public long getFileSize(String uuid) throws FileStoreException {
        File file = this.getFileDirectly(uuid);
        if (file == null) {
            logger.warn("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de\u957f\u5ea6-1");
            return -1L;
        }
        logger.info("\u6587\u4ef6{}\u7684\u957f\u5ea6\u4e3a{}", (Object)uuid, (Object)file.length());
        return file.length();
    }

    @Override
    public boolean exist(String uuid) throws FileStoreException {
        return this.getFileDirectly(uuid) != null;
    }

    @Override
    public boolean deleteFile(String uuid) throws FileStoreException {
        logger.info("\u5f00\u59cb\u5220\u9664\u6587\u4ef6\uff0cuuid={}", (Object)uuid);
        File file = this.getFileDirectly(uuid);
        if (file == null) {
            logger.info("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0cuuid={}", (Object)uuid);
            return false;
        }
        try {
            FileUtils.forceDelete((File)file);
            logger.info("\u6587\u4ef6\u5df2\u5220\u9664\uff0cuuid={}", (Object)uuid);
        }
        catch (IOException e) {
            logger.error("\u5220\u9664{}\u5931\u8d25\uff01", (Object)file.getAbsolutePath(), (Object)e);
            throw new FileStoreException("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + file.getAbsolutePath(), e);
        }
        return true;
    }

    @Override
    public List<String> searchFullText(String keyword) throws FileStoreException {
        logger.error("SimpleFileStore\u4e0d\u652f\u6301\u5168\u6587\u68c0\u7d22");
        return null;
    }

    @Override
    public Map<String, String> searchFullTextWithExcerpt(String keyword) throws FileStoreException {
        logger.error("SimpleFileStore\u4e0d\u652f\u6301\u5168\u6587\u68c0\u7d22");
        return null;
    }

    private File getStorageDir(String uuid) {
        String realtivePath = this.getRelativePathByUUID(uuid);
        File targetDir = new File(this.rootPath, realtivePath);
        return targetDir;
    }

    private String getRelativePathByUUID(String uuid) {
        return uuid.charAt(0) + File.separator + uuid.charAt(1);
    }
}

