/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filestore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"MimeUtil");
    private static Properties propFile = new Properties();

    static {
        InputStream in = null;
        try {
            try {
                in = MimeUtil.class.getResourceAsStream("mimetype.properties");
                propFile.load(in);
            }
            catch (FileNotFoundException e) {
                logger.error("\u627e\u4e0d\u5230mime\u5b9a\u4e49\u6587\u4ef6mimetype.properties\uff0c\u5c06\u65e0\u6cd5\u5224\u65ad\u6587\u4ef6mime\uff01");
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5931\u8d25", (Throwable)e2);
                }
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6mimetype.properties\u5931\u8d25\uff0c\u5c06\u65e0\u6cd5\u5224\u65ad\u6587\u4ef6mime\uff01");
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e3) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5931\u8d25", (Throwable)e3);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static String getMimeType(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        if (extension == null || "".equals(extension)) {
            return null;
        }
        String type = propFile.getProperty(extension);
        type = type == null || "".equals(type) ? "application/octet-stream" : type.split(",")[0].trim();
        return type;
    }
}

