/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filestore;

import com.kdgcsoft.power.filestore.FileStoreException;
import com.kdgcsoft.power.filestore.MimeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.value.BinaryValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JackrabbitHelper {
    private static Logger logger = LoggerFactory.getLogger(JackrabbitHelper.class);

    JackrabbitHelper() {
    }

    public static void initStorageNode(Session session, String storeName) throws FileStoreException {
        try {
            Node root = session.getRootNode();
            Node node = root.addNode(storeName, "nt:unstructured");
            node.setProperty("jcr:lastModified", System.currentTimeMillis());
            String pkUUID = UUID.randomUUID().toString().replaceAll("-", "");
            node.setProperty("jcr:uuid", pkUUID);
            session.save();
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
    }

    public static Node getStoreNode(Session session, String storeName) throws FileStoreException {
        Node storeNode = null;
        String xPath = "/jcr:root/" + storeName;
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(xPath, "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                storeNode = it.nextNode();
            }
            if (storeNode == null) {
                throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u6839\u5b58\u50a8\u4f4d\u7f6e!");
            }
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
        return storeNode;
    }

    public static Node getFileNode(Session session, String uuid) throws ItemNotFoundException, RepositoryException {
        Node node = session.getNodeByIdentifier(uuid);
        NodeIterator contentNodes = node.getNodes();
        Node contNode = null;
        while (contentNodes.hasNext()) {
            contNode = contentNodes.nextNode();
        }
        return contNode;
    }

    public static String saveFileContent(Session session, String storeName, String filename, InputStream is, String relativePath) throws FileStoreException {
        Node storeNode = JackrabbitHelper.getStoreNode(session, storeName);
        String fileUUID = "";
        try {
            Node node = JackrabbitHelper.getOrAddNodeRecursively(storeNode, relativePath);
            if (node == null) {
                throw new FileStoreException("\u5728\u5e93\u4e2d\u83b7\u53d6\u6216\u521b\u5efa\u8def\u5f84\u5931\u8d25! " + relativePath);
            }
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            String currentTime = dateformat.format(new Date());
            String fileBaseName = FilenameUtils.getBaseName((String)filename);
            String fileType = FilenameUtils.getExtension((String)filename);
            String name = String.valueOf(fileBaseName) + "_" + currentTime + "." + fileType;
            Node fileNode = node.addNode(name, "nt:file");
            fileUUID = fileNode.getIdentifier();
            Node resNode = fileNode.addNode("jcr:content", "nt:resource");
            String mimeType = MimeUtil.getMimeType(filename);
            resNode.setProperty("jcr:mimeType", mimeType);
            resNode.setProperty("jcr:encoding", "utf-8");
            BinaryValue fileBinary = new BinaryValue(is);
            resNode.setProperty("jcr:data", (Value)fileBinary);
            session.save();
        }
        catch (ItemExistsException e) {
            throw new FileStoreException("\u6587\u4ef6\u5df2\u5b58\u5728!", e);
        }
        catch (PathNotFoundException e) {
            throw new FileStoreException("\u6ca1\u627e\u5230\u8def\u5f84!", e);
        }
        catch (NoSuchNodeTypeException e) {
            throw new FileStoreException("\u6ca1\u6709\u6b64\u7c7b\u8282\u70b9!", e);
        }
        catch (LockException e) {
            throw new FileStoreException("\u6587\u4ef6\u88ab\u9501\u5b9a!", e);
        }
        catch (VersionException e) {
            throw new FileStoreException("\u7248\u672c\u5f02\u5e38!", e);
        }
        catch (ConstraintViolationException e) {
            throw new FileStoreException("\u8fdd\u53cd\u7ea6\u675f!", e);
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
        return fileUUID;
    }

    private static Node getOrAddNodeRecursively(Node root, String relPath) throws RepositoryException {
        String[] names = relPath.split("/");
        Node parent = root;
        int i = 0;
        while (i < names.length) {
            if (names[i] != null && !"".equals(names[i])) {
                parent = JcrUtils.getOrAddNode((Node)parent, (String)names[i], (String)"nt:folder");
            }
            ++i;
        }
        return parent;
    }

    public static List<Node> fullTextSearchForNode(Session session, String storageNodeName, String keyword) throws FileStoreException {
        ArrayList<Node> list = new ArrayList<Node>();
        if (!"".equals(keyword)) {
            try {
                String xPath = "//element(*, nt:file)[(jcr:contains(jcr:content,\"" + keyword + "\"))]";
                Workspace ws = session.getWorkspace();
                QueryManager qm = ws.getQueryManager();
                Query query = qm.createQuery(xPath, "xpath");
                QueryResult singleStorageNode = query.execute();
                NodeIterator it = singleStorageNode.getNodes();
                while (it.hasNext()) {
                    Node node = it.nextNode();
                    list.add(node);
                }
            }
            catch (InvalidQueryException e) {
                throw new FileStoreException("\u65e0\u6548\u7684\u5de5\u4f5c\u9879\u67e5\u8be2\u8bed\u53e5!", e);
            }
            catch (RepositoryException e) {
                throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
            }
        }
        return list;
    }

    public static boolean deleteNode(Session session, String uuid, String storageNodeName) throws FileStoreException {
        try {
            Node node = session.getNodeByIdentifier(uuid);
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                Node fileNode = it.nextNode();
                fileNode.remove();
            }
            node.remove();
            session.save();
            return true;
        }
        catch (ItemNotFoundException e) {
            logger.warn("\u8981\u5220\u9664\u7684\u6587\u4ef6\u5df2\u7ecf\u4e0d\u5b58\u5728\uff01uuid={}", (Object)uuid);
            return false;
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
    }

    public static void replaceFile(Session session, String pkUUID, String storageNodeName, InputStream is, String fileName) throws FileStoreException {
        String xPath = "//" + storageNodeName + "/*[@jcr:uuid= '" + pkUUID + "']";
        Workspace ws = session.getWorkspace();
        String mimeType = MimeUtil.getMimeType(fileName);
        String newName = fileName.substring(0, fileName.lastIndexOf("."));
        try {
            try {
                QueryManager qm = ws.getQueryManager();
                Query query = qm.createQuery(xPath, "xpath");
                QueryResult singleStorageNode = query.execute();
                NodeIterator itSingle = singleStorageNode.getNodes();
                while (itSingle.hasNext()) {
                    Node singleNode = itSingle.nextNode();
                    session.move(singleNode.getPath(), String.valueOf(singleNode.getParent().getPath()) + "/" + newName);
                    NodeIterator it = singleNode.getNodes();
                    while (it.hasNext()) {
                        Node contentNode = it.nextNode();
                        contentNode.remove();
                        session.save();
                    }
                    Node fileNode = singleNode.addNode(fileName, "nt:file");
                    Node resNode = fileNode.addNode("jcr:content", "nt:resource");
                    resNode.setProperty("jcr:mimeType", mimeType);
                    BinaryValue fileBinary = new BinaryValue(is);
                    resNode.setProperty("jcr:data", (Value)fileBinary);
                    session.save();
                }
            }
            catch (InvalidQueryException e) {
                throw new FileStoreException("\u65e0\u6548\u7684\u5de5\u4f5c\u9879\u67e5\u8be2\u8bed\u53e5!", e);
            }
            catch (RepositoryException e) {
                throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new FileStoreException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25!", e);
                }
            }
        }
    }
}

