/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filestore;

import com.kdgcsoft.power.filestore.FileInfo;
import com.kdgcsoft.power.filestore.FileStore;
import com.kdgcsoft.power.filestore.FileStoreException;
import com.kdgcsoft.power.filestore.JackrabbitHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JackRabbitFileStore
implements FileStore {
    private static Logger logger = LoggerFactory.getLogger(JackRabbitFileStore.class);
    private static String DEFAULT_USER = "admin";
    private static String DEFAULT_PASS = "admin";
    private Repository repository = null;
    private String rootNodeName = null;
    private String user = DEFAULT_USER;
    private String password = DEFAULT_PASS;

    JackRabbitFileStore(Repository repo, String rootNodeName) {
        this.repository = repo;
        this.rootNodeName = rootNodeName;
    }

    @Override
    public void setLoginAccount(String user, String password) {
        this.user = user;
        this.password = password;
    }

    private Session CreateSession() throws FileStoreException {
        try {
            Session session = this.repository.login((Credentials)new SimpleCredentials(this.user, this.password.toCharArray()));
            Node storageNode = JackrabbitHelper.getStoreNode(session, this.rootNodeName);
            if (storageNode == null) {
                JackrabbitHelper.initStorageNode(session, this.rootNodeName);
            }
            return session;
        }
        catch (LoginException e) {
            logger.error("\u5185\u5bb9\u4ed3\u5e93\u767b\u5f55\u5931\u8d25!", (Throwable)e);
            throw new FileStoreException("\u5185\u5bb9\u4ed3\u5e93\u767b\u5f55\u5931\u8d25!", e);
        }
        catch (RepositoryException e) {
            logger.error("\u5185\u5bb9\u4ed3\u5e93\u521b\u5efa\u5f02\u5e38\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u5185\u5bb9\u4ed3\u5e93\u8def\u5f84", (Throwable)e);
            throw new FileStoreException("\u5185\u5bb9\u4ed3\u5e93\u521b\u5efa\u5f02\u5e38\u5f02\u5e38!\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u4e2d\u5185\u5bb9\u4ed3\u5e93\u8def\u5f84", e);
        }
    }

    @Override
    public String putFile(File file, String realName, String relativePath) throws FileStoreException {
        FileInputStream is;
        logger.info("\u5f00\u59cb\u5b58\u50a8\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)file.getAbsolutePath());
            throw new FileStoreException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff1a" + file.getAbsolutePath(), e);
        }
        return this.putFileAsStream(is, realName, relativePath);
    }

    @Override
    public String putFileAsStream(InputStream inputStream, String realName, String relativePath) throws FileStoreException {
        logger.info("\u5f00\u59cb\u5b58\u50a8\u6587\u4ef6\u6d41\uff1a{}", (Object)realName);
        String filename = realName;
        String UUID = null;
        Session session = this.CreateSession();
        try {
            UUID = JackrabbitHelper.saveFileContent(session, this.rootNodeName, filename, inputStream, relativePath);
            logger.info("\u6587\u6863\u4e0a\u4f20\u6210\u529f\uff0c\u8fd4\u56deuuid\uff1a" + UUID);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u8f93\u5165\u6d41\u5173\u95ed\u9519\u8bef!", (Throwable)e);
                    throw new FileStoreException("\u6587\u4ef6\u8f93\u5165\u6d41\u5173\u95ed\u9519\u8bef!", e);
                }
            }
            session.logout();
        }
        return UUID;
    }

    @Override
    public FileInfo getFile(String uuid) throws FileStoreException {
        logger.info("\u5f00\u59cb\u83b7\u53d6\u6587\u4ef6{}", (Object)uuid);
        Session session = this.CreateSession();
        try {
            Node contNode = JackrabbitHelper.getFileNode(session, uuid);
            FileInfo info = new FileInfo();
            info.setUUID(uuid);
            info.setInputStream(contNode.getProperty("jcr:data").getBinary().getStream());
            info.setFilesize(contNode.getProperty("jcr:data").getLength());
            FileInfo fileInfo = info;
            return fileInfo;
        }
        catch (ItemNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6\uff0cuuid={}!", (Object)uuid, (Object)e);
            return null;
        }
        catch (RepositoryException e1) {
            logger.error("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e1);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e1);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            logger.info("\u7ed3\u675f\u83b7\u53d6\u6587\u4ef6{}", (Object)uuid);
        }
    }

    @Override
    public InputStream getFileAsStream(String uuid) throws FileStoreException {
        Session session = this.CreateSession();
        try {
            Node contNode = JackrabbitHelper.getFileNode(session, uuid);
            InputStream inputStream = contNode.getProperty("jcr:data").getBinary().getStream();
            return inputStream;
        }
        catch (ItemNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6\uff0cuuid={}!", (Object)uuid, (Object)e);
            return null;
        }
        catch (RepositoryException e1) {
            logger.error("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e1);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e1);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            logger.info("\u7ed3\u675f\u83b7\u53d6\u6587\u4ef6\u6d41{}", (Object)uuid);
        }
    }

    @Override
    public long getFileSize(String uuid) throws FileStoreException {
        Session session = this.CreateSession();
        long size = -1L;
        try {
            Node node = session.getNodeByIdentifier(uuid);
            NodeIterator contentNodes = node.getNodes();
            Node contNode = null;
            while (contentNodes.hasNext()) {
                contNode = contentNodes.nextNode();
            }
            if (contNode == null) {
                throw new FileStoreException("\u627e\u4e0d\u5230\u6587\u4ef6, uuid=" + uuid);
            }
            long l = size = contNode.getProperty("jcr:data").getLength();
            return l;
        }
        catch (ValueFormatException e1) {
            logger.error("\u503c\u683c\u5f0f\u5316\u5931\u8d25!", (Throwable)e1);
            throw new FileStoreException("\u503c\u683c\u5f0f\u5316\u5931\u8d25!", e1);
        }
        catch (PathNotFoundException e1) {
            logger.error("\u6587\u4ef6\u8def\u5f84\u6ca1\u627e\u5230!", (Throwable)e1);
            throw new FileStoreException("\u6587\u4ef6\u8def\u5f84\u6ca1\u627e\u5230!", e1);
        }
        catch (RepositoryException e1) {
            logger.error("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e1);
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e1);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            logger.info("\u6587\u4ef6{}\u5927\u5c0f\u4e3a{}", (Object)uuid, (Object)size);
        }
    }

    @Override
    public boolean exist(String uuid) throws FileStoreException {
        Session session = this.CreateSession();
        try {
            Node node = session.getNodeByIdentifier(uuid);
            return node != null;
            {
            }
        }
        catch (ItemNotFoundException e) {
            logger.info("\u6587\u4ef6{}\u4e0d\u5b58\u5728", (Object)uuid);
            return false;
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u6587\u4ef6\u4ed3\u5e93\u8fde\u63a5\u51fa\u9519");
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public boolean deleteFile(String uuid) throws FileStoreException {
        logger.info("\u5f00\u59cb\u5220\u9664\u6587\u4ef6{}", (Object)uuid);
        Session session = null;
        try {
            session = this.CreateSession();
            boolean result = JackrabbitHelper.deleteNode(session, uuid, null);
            logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u675f\uff0c\u7ed3\u679c={}", (Object)result);
            boolean bl = result;
            return bl;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public List<String> searchFullText(String keyword) throws FileStoreException {
        logger.info("\u542f\u52a8\u5168\u6587\u68c0\u7d22\u529f\u80fd...");
        logger.info("\u68c0\u7d22\u5173\u952e\u5b57..." + keyword);
        Session session = this.CreateSession();
        try {
            List<Node> list = JackrabbitHelper.fullTextSearchForNode(session, this.rootNodeName, keyword);
            ArrayList<String> listIds = new ArrayList<String>();
            for (Node n : list) {
                listIds.add(n.getIdentifier());
            }
            logger.info("\u68c0\u7d22\u7ed3\u675f\uff0c\u8fd4\u56de\u68c0\u7d22\u5185\u5bb9...");
            logger.info("\u68c0\u7d22\u5230\u7684uuid\u4e3a\uff1a" + listIds);
            ArrayList<String> arrayList = listIds;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public Map<String, String> searchFullTextWithExcerpt(String keyword) throws FileStoreException {
        logger.info("\u542f\u52a8\u5168\u6587\u68c0\u7d22\u548c\u6458\u8981\u529f\u80fd...");
        logger.info("\u68c0\u7d22\u5173\u952e\u5b57..." + keyword);
        HashMap<String, String> resultmapMap = new HashMap<String, String>();
        Session session = this.CreateSession();
        try {
            if (!"".equals(keyword)) {
                try {
                    String xPath = "//element(*, nt:file)[(jcr:contains(jcr:content,\"" + keyword + "\"))]";
                    Workspace ws = session.getWorkspace();
                    QueryManager qm = ws.getQueryManager();
                    Query query = qm.createQuery(xPath, "xpath");
                    RowIterator rows = query.execute().getRows();
                    while (rows.hasNext()) {
                        Row r = rows.nextRow();
                        Node file = (Node)session.getItem(r.getValue("jcr:path").getString());
                        resultmapMap.put(file.getIdentifier(), r.getValue("rep:excerpt(jcr:content)").getString());
                    }
                    logger.info("\u68c0\u7d22\u7ed3\u675f\uff0c\u8fd4\u56de\u68c0\u7d22\u5185\u5bb9...");
                    logger.info("\u68c0\u7d22\u5230\u7684uuid\u4e3a\uff1a" + resultmapMap.keySet());
                }
                catch (InvalidQueryException e) {
                    logger.error("\u65e0\u6548\u7684\u67e5\u8be2\u8bed\u53e5!", (Throwable)e);
                    throw new FileStoreException("\u65e0\u6548\u7684\u67e5\u8be2\u8bed\u53e5!", e);
                }
                catch (RepositoryException e) {
                    logger.error("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", (Throwable)e);
                    throw new FileStoreException("\u6587\u4ef6\u5b58\u50a8\u5e93\u5f02\u5e38!", e);
                }
            }
            HashMap<String, String> hashMap = resultmapMap;
            return hashMap;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public boolean supportFullTextSearch() {
        return true;
    }
}

