/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filestore;

import com.kdgcsoft.power.filestore.FileStore;
import com.kdgcsoft.power.filestore.FileStoreException;
import com.kdgcsoft.power.filestore.JackRabbitFileStore;
import com.kdgcsoft.power.filestore.SimpleFileStore;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Repository;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreManager {
    private static Logger logger = LoggerFactory.getLogger(FileStoreManager.class);
    private static String DEFAULT_NAME = "DefaultStore";
    private static Map<String, FileStore> instances = new Hashtable<String, FileStore>();

    public static FileStore createSimpleStore(String saveRootPath) throws FileStoreException {
        return FileStoreManager.createSimpleStore(saveRootPath, DEFAULT_NAME);
    }

    public static FileStore createSimpleStore(String saveRootPath, String name) throws FileStoreException {
        FileStoreManager.checkName(name);
        File rootPath = new File(saveRootPath);
        File workPath = new File(rootPath, name);
        try {
            FileUtils.forceMkdir((File)workPath);
        }
        catch (IOException e) {
            logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a{}", (Object)saveRootPath);
            throw new FileStoreException("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + saveRootPath, e);
        }
        SimpleFileStore store = new SimpleFileStore(workPath);
        FileStoreManager.saveInstance(name, store);
        return store;
    }

    public static FileStore createLocalJackRabbitStore(File localStorePath) throws FileStoreException {
        return FileStoreManager.createLocalJackRabbitStore(new File("/doesntexistDummy"), localStorePath, DEFAULT_NAME);
    }

    public static FileStore createLocalJackRabbitStore(File localStorePath, String name) throws FileStoreException {
        return FileStoreManager.createLocalJackRabbitStore(new File("/doesntexistDummy"), localStorePath, name);
    }

    public static FileStore createLocalJackRabbitStore(File xmlFile, File storeDir) throws FileStoreException {
        return FileStoreManager.createLocalJackRabbitStore(xmlFile, storeDir, DEFAULT_NAME);
    }

    public static FileStore createLocalJackRabbitStore(File xmlFile, File storeDir, String name) throws FileStoreException {
        FileStoreManager.checkName(name);
        TransientRepository repository = new TransientRepository(xmlFile, storeDir);
        JackRabbitFileStore store = new JackRabbitFileStore((Repository)repository, name);
        FileStoreManager.saveInstance(name, store);
        return store;
    }

    public static FileStore createRemoteJackRabbitStore(String url) throws FileStoreException {
        return FileStoreManager.createRemoteJackRabbitStore(url, DEFAULT_NAME);
    }

    public static FileStore createRemoteJackRabbitStore(String url, String name) throws FileStoreException {
        URLRemoteRepository repository;
        FileStoreManager.checkName(name);
        try {
            repository = new URLRemoteRepository(url);
        }
        catch (MalformedURLException e) {
            logger.error("URL\u683c\u5f0f\u9519\u8bef\uff01{}", (Object)url, (Object)e);
            throw new FileStoreException("\u6587\u4ef6\u5e93\u7684URL\u683c\u5f0f\u9519\u8bef\uff01", e);
        }
        JackRabbitFileStore store = new JackRabbitFileStore((Repository)repository, name);
        FileStoreManager.saveInstance(name, store);
        return store;
    }

    public static FileStore getStore(String name) throws FileStoreException {
        FileStoreManager.checkName(name);
        if (instances.get(name) == null) {
            logger.warn("\u6ca1\u6709\u521b\u5efa\u540d\u4e3a{}\u7684\u5b58\u50a8\u5e93\u3002\u8bf7\u5148\u4f7f\u7528create...Store()\u521b\u5efa\uff01");
        }
        return instances.get(name);
    }

    public static FileStore getStore() throws FileStoreException {
        return FileStoreManager.getStore(DEFAULT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveInstance(String name, FileStore store) throws FileStoreException {
        Map<String, FileStore> map = instances;
        synchronized (map) {
            if (instances.get(name) != null) {
                logger.error("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u5b58\u50a8\u5e93\u5b9e\u4f8b{}\uff01\u4e0d\u540c\u7684FileStore\u5b9e\u4f8b\u9700\u8981\u4e0d\u540c\u7684\u540d\u5b57\uff0c\u53ea\u5b58\u5728\u4e00\u4e2a\u5b9e\u4f8b\u65f6\u624d\u53ef\u4ee5\u4f7f\u7528\u7f3a\u7701\u540d", (Object)name);
                throw new FileStoreException("\uff01\u8bf7\u5bf9\u4e0d\u540c\u7684FileStore\u5b9e\u4f8b\u4f7f\u7528\u4e0d\u540c\u7684\u540d\u5b57\u3002\u5f53\u524d\u91cd\u590d\u540d\u4e3a" + name);
            }
            instances.put(name, store);
        }
    }

    private static void checkName(String name) throws FileStoreException {
        if (name == null || "".equals(name)) {
            throw new FileStoreException("\u5b58\u50a8\u5e93\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch) && "_-".indexOf(name.charAt(i)) < 0) {
                throw new FileStoreException("\u5b58\u50a8\u5e93\u7684\u540d\u79f0\u5fc5\u987b\u662f\u5b57\u6bcd\u3001\u6c49\u5b57\u3001\u6570\u5b57\u3001\u51cf\u53f7\u3001\u4e0b\u5212\u7ebf\u7ec4\u6210\uff01");
            }
            ++i;
        }
    }
}

