package com.kdgcsoft.power.previewprovider;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdgcsoft.power.fileconverter.FileConverterException;
import com.kdgcsoft.power.fileconverter.OutputType;
import com.kdgcsoft.power.filemanager.FileManager;
import com.kdgcsoft.power.filemanager.RequestDocInfo;
import com.kdgcsoft.power.filepreview.provider.PreviewInfo;
import com.kdgcsoft.power.filestore.FileInfo;
import com.kdgcsoft.power.filestore.FileStoreException;

public class PreviewManager {
	private static Logger logger = LoggerFactory.getLogger(PreviewManager.class);
	private static volatile PreviewManager instance;
	private static final Map<String, String> viewtypeMap;
	static {
		viewtypeMap = new HashMap<String, String>();
		viewtypeMap.put("doc", OutputType.pdf.name());
		viewtypeMap.put("docx", OutputType.pdf.name());
		viewtypeMap.put("ppt", OutputType.pdf.name());
		viewtypeMap.put("pptx", OutputType.pdf.name());
		viewtypeMap.put("xls", OutputType.html.name());
		viewtypeMap.put("xlsx", OutputType.html.name());
	}
	private final FileManager filemanager;

	private PreviewManager() {
		filemanager = FileManager.getInstance();
	}

	public static PreviewManager getInstance() {
		if (instance == null) {
			synchronized (PreviewManager.class) {
				if (instance == null) {
					instance = new PreviewManager();
				}
			}
		}
		return instance;

	}

	public PreviewInfo getPreviewInfo(String key) {
		PreviewInfo previewinfo = new PreviewInfo();
		try {
			FileInfo fileinfo = filemanager.getFileInfo(key);
			String viewtype= defaultviewtype(fileinfo.getFileName());
			RequestDocInfo requestinfo= filemanager.requestTargetTypeFile(key,viewtype, true);
			previewinfo.setKey(key);
			previewinfo.setFileName(fileinfo.getFileName());
			previewinfo.setFileLength(fileinfo.getFileSize());
			previewinfo.setViewtype(viewtype);
			previewinfo.setMultiView(requestinfo.getWantFilesCount()>1?true:false);
			previewinfo.setTotalNum(requestinfo.getWantFilesCount());
		} catch (FileStoreException e) {
			logger.error("文件获取失败:", e);
		} catch (FileConverterException e) {
			logger.error("文件转换失败:", e);
		}
		return previewinfo;
	}
	
	
	public InputStream getDownloadStream(String key) {
		InputStream is=null;
		try {
			is= filemanager.getFileAsStream(key);
		} catch (FileStoreException e) {
			logger.error("获取文件下载流出错:", e);
		}
		return is;
	}
	
	public InputStream getPreviewStream(String key) {
		InputStream is=null;
		try {
			FileInfo fileinfo = filemanager.getFileInfo(key);
			String viewtype= defaultviewtype(fileinfo.getFileName());
			is= filemanager.getFileAsStream(key,viewtype,true);
		} catch (FileStoreException e) {
			logger.error("获取文件下载流出错:", e);
		} catch (FileConverterException e) {
			logger.error("文件转换失败:", e);
		}
		return is;
	}
	
	public InputStream getPreviewStream(String key,int page) {
		InputStream is=null;
		try {
			FileInfo fileinfo = filemanager.getFileInfo(key);
			String viewtype= defaultviewtype(fileinfo.getFileName());
			is= filemanager.getFilePageAsStream(key, viewtype, page, true);
		} catch (FileStoreException e) {
			logger.error("获取文件下载流出错:", e);
		} catch (FileConverterException e) {
			logger.error("文件转换失败:", e);
		}
		return is;
	}

	private String defaultviewtype(String fileName) {
		String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
		if(viewtypeMap.containsKey(suffix)) {
			return viewtypeMap.get(suffix);
		}else {
			return suffix;
		}
	}

}
