package com.kdgcsoft.power.previewprovider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.kdgcsoft.power.filepreview.provider.PreviewBtn;
import com.kdgcsoft.power.filepreview.provider.PreviewInfo;
import com.kdgcsoft.power.filepreview.provider.IPreviewProvider;
public class DefaultPreivewProvider implements IPreviewProvider {
	private String fileIdKey="fileid";
	private String pageKey="page";
	@Override
	public boolean canPreview(HttpServletRequest request) {
		return true;
	}

	@Override
	public boolean canDownload(HttpServletRequest request) {
		return true;
	}

	@Override
	public InputStream getDownloadStream(HttpServletRequest request) {
		String fileid=request.getParameter(fileIdKey);
		InputStream is=PreviewManager.getInstance().getDownloadStream(fileid);
		return is;
	}
	
	@Override
	public PreviewInfo getPreviewInfo(HttpServletRequest request) {
		String fileid=request.getParameter(fileIdKey);
		PreviewInfo preivewinfo=PreviewManager.getInstance().getPreviewInfo(fileid);
		return preivewinfo;
	}

	@Override
	public InputStream getPreviewStream(HttpServletRequest request) {
		String fileid=request.getParameter(fileIdKey);
		String pagestr=request.getParameter(pageKey);
		int page=0;
		InputStream is=null;
		if(pagestr!=null&&!"".equals(pagestr)) {//传入页数了就调用指定页数的方法
			page=Integer.parseInt(pagestr);
			 is=PreviewManager.getInstance().getPreviewStream(fileid,page);
		}else {//
			 is=PreviewManager.getInstance().getPreviewStream(fileid);
		}
		return is;
	}

	@Override
	public List<PreviewBtn> morePreviewBtn(HttpServletRequest request) {
		List<PreviewBtn> btnlist=new ArrayList<PreviewBtn>();
//		PreviewBtn btn1=new PreviewBtn("百度","http://www.baidu.com");
//		btnlist.add(btn1);
		return btnlist;
	}

}
