/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.previewprovider;

import com.kdgcsoft.power.fileconverter.FileConverterException;
import com.kdgcsoft.power.fileconverter.OutputType;
import com.kdgcsoft.power.filemanager.FileManager;
import com.kdgcsoft.power.filemanager.FileManagerSettings;
import com.kdgcsoft.power.filemanager.RequestDocInfo;
import com.kdgcsoft.power.filepreview.provider.PreviewInfo;
import com.kdgcsoft.power.filestore.FileInfo;
import com.kdgcsoft.power.filestore.FileStoreException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewManager {
    private static Logger logger = LoggerFactory.getLogger(PreviewManager.class);
    private static volatile PreviewManager instance;
    private static final Map<String, String> viewtypeMap;
    private FileManager filemanager;

    static {
        viewtypeMap = new HashMap<String, String>();
        viewtypeMap.put("doc", OutputType.pdf.name());
        viewtypeMap.put("docx", OutputType.pdf.name());
        viewtypeMap.put("ppt", OutputType.pdf.name());
        viewtypeMap.put("pptx", OutputType.pdf.name());
        viewtypeMap.put("xls", OutputType.html.name());
        viewtypeMap.put("xlsx", OutputType.html.name());
    }

    private PreviewManager() {
        FileManager.init(FileManagerSettings.createDefault().setBaseDir("D://filestore").setAutoConvert(true));
        this.filemanager = FileManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PreviewManager getInstance() {
        if (instance != null) return instance;
        Class<PreviewManager> clazz = PreviewManager.class;
        synchronized (PreviewManager.class) {
            if (instance != null) return instance;
            instance = new PreviewManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public PreviewInfo getPreviewInfo(String key) {
        PreviewInfo previewinfo = new PreviewInfo();
        try {
            FileInfo fileinfo = this.filemanager.getFile(key);
            String viewtype = this.defaultviewtype(fileinfo.getFileName());
            RequestDocInfo requestinfo = this.filemanager.getFile(key, viewtype, true);
            previewinfo.setKey(key);
            previewinfo.setFileName(fileinfo.getFileName());
            previewinfo.setFileLength(fileinfo.getFileSize());
            previewinfo.setViewtype(viewtype);
            previewinfo.setMultiView(requestinfo.getWantFilesCount() > 1);
            previewinfo.setTotalNum(requestinfo.getWantFilesCount());
        }
        catch (FileStoreException e) {
            logger.error("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:", (Throwable)e);
        }
        catch (FileConverterException e) {
            logger.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25:", (Throwable)e);
        }
        return previewinfo;
    }

    public InputStream getDownloadStream(String key) {
        InputStream is = null;
        try {
            is = this.filemanager.getFile(key).getInputStream();
        }
        catch (FileStoreException e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u6d41\u51fa\u9519:", (Throwable)e);
        }
        return is;
    }

    public InputStream getPreviewStream(String key) {
        InputStream is = null;
        try {
            FileInfo fileinfo = this.filemanager.getFile(key);
            String viewtype = this.defaultviewtype(fileinfo.getFileName());
            is = this.filemanager.getFileAsStream(key, viewtype, true);
        }
        catch (FileStoreException e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u6d41\u51fa\u9519:", (Throwable)e);
        }
        catch (FileConverterException e) {
            logger.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25:", (Throwable)e);
        }
        return is;
    }

    public InputStream getPreviewStream(String key, int page) {
        InputStream is = null;
        try {
            FileInfo fileinfo = this.filemanager.getFile(key);
            String viewtype = this.defaultviewtype(fileinfo.getFileName());
            is = this.filemanager.getFilePageAsStream(key, viewtype, page, true);
        }
        catch (FileStoreException e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u6d41\u51fa\u9519:", (Throwable)e);
        }
        catch (FileConverterException e) {
            logger.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25:", (Throwable)e);
        }
        return is;
    }

    private String defaultviewtype(String fileName) {
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (viewtypeMap.containsKey(suffix)) {
            return viewtypeMap.get(suffix);
        }
        return suffix;
    }
}

