/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filemanager;

import com.kdgcsoft.power.fileconverter.ConvertEngineType;
import com.kdgcsoft.power.fileconverter.FileConverterService;
import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.StorageType;
import com.kdgcsoft.power.filemanager.AutoConvertStrategy;
import com.kdgcsoft.power.filemanager.FileManager;
import com.kdgcsoft.power.filestore.FileStore;
import com.kdgcsoft.power.filestore.FileStoreException;
import com.kdgcsoft.power.filestore.LocalJackRabbitFileStore;
import com.kdgcsoft.power.filestore.RemoteJackRabbitFileStore;
import com.kdgcsoft.power.filestore.TimeStampSimpleFileStore;
import com.kdgcsoft.power.filestore.UUIDSimpleFileStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerSettings {
    private static final Logger logger = LoggerFactory.getLogger(FileManagerSettings.class);
    private static final String DEFAULT_DIR = String.valueOf(System.getProperty("user.dir")) + "/FileManager";
    private String baseDir = DEFAULT_DIR;
    private IDType idType = IDType.timestamp;
    private boolean useJackrabbit = false;
    private String jackrabbitURL = "";
    private String jackrabbitUser = "admin";
    private String jackrabbitPassword = "admin";
    private boolean autoConvert = true;
    private AutoConvertStrategy convertStrategy = null;
    private FileConverterSettings convertSettings = new FileConverterSettings();

    private FileManagerSettings() {
    }

    public static FileManagerSettings createDefault() {
        InputStream is = FileManagerSettings.class.getClassLoader().getResourceAsStream("default.properties");
        return FileManagerSettings.createByPropertiesSteam(is);
    }

    public static FileManagerSettings createByPropertiesFile(File propFile) {
        try {
            return FileManagerSettings.createByPropertiesSteam(new FileInputStream(propFile));
        }
        catch (FileNotFoundException e) {
            logger.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25{}\uff01\u5c06\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\u3002", (Object)propFile.getAbsolutePath(), (Object)e);
            return FileManagerSettings.createDefault();
        }
    }

    public static FileManagerSettings createByPropertiesSteam(InputStream is) {
        Properties prop = new Properties();
        try {
            prop.load(new InputStreamReader(is, "utf-8"));
            return FileManagerSettings.createByProperties(prop);
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25{}\uff01", (Throwable)e);
            return new FileManagerSettings();
        }
    }

    public static FileManagerSettings createByProperties(Properties prop) {
        String e2h_hideOneTab;
        String e2h_showHidden;
        String e2h_showHeaders;
        String openOfficePorts;
        String openOfficePath;
        String pdf2HtmlStr;
        String threadStr;
        String engine;
        String testMode;
        String strategyStr;
        String autoConvert;
        boolean useJackRabbit;
        String idType;
        FileManagerSettings settings = new FileManagerSettings();
        String baseDir = prop.getProperty("dc.dir");
        if (!FileManagerSettings.isBlank(baseDir)) {
            settings.setBaseDir(baseDir.trim());
        }
        if ((idType = prop.getProperty("dc.id-type")) != null) {
            try {
                IDType type = IDType.valueOf(idType.trim());
                settings.setIdType(type);
            }
            catch (Exception e) {
                logger.warn("\u65e0\u6cd5\u8bc6\u522b\u7684id-type\uff1a{}", (Object)idType);
            }
        }
        if (useJackRabbit = Boolean.valueOf(prop.getProperty("dc.filestore.jackrabbit.enabled")).booleanValue()) {
            settings.setUseJackrabbit(prop.getProperty("dc.filestore.jackrabbit.url"), prop.getProperty("dc.filestore.jackrabbit.user"), prop.getProperty("dc.filestore.jackrabbit.password"));
        }
        if (!FileManagerSettings.isBlank(autoConvert = prop.getProperty("dc.convert.auto-convert.enabled"))) {
            settings.setAutoConvert(Boolean.valueOf(autoConvert));
        }
        if (!FileManagerSettings.isBlank(strategyStr = prop.getProperty("dc.convert.auto-convert.strategy"))) {
            settings.setConvertStrategy(AutoConvertStrategy.parse(strategyStr.trim()));
        }
        if (!FileManagerSettings.isBlank(testMode = prop.getProperty("dc.convert.test-mode"))) {
            settings.setConvertTestMode(Boolean.valueOf(testMode));
        }
        if (!FileManagerSettings.isBlank(engine = prop.getProperty("dc.convert.engine"))) {
            try {
                ConvertEngineType type = ConvertEngineType.valueOf((String)engine.trim());
                settings.setConvertEngine(type);
            }
            catch (Exception e) {
                logger.error("\u65e0\u6cd5\u8bc6\u522b\u7684\u8f6c\u6362\u5f15\u64ce\uff1a{}", (Object)engine);
            }
        }
        if (!FileManagerSettings.isBlank(threadStr = prop.getProperty("dc.convert.max-thread"))) {
            try {
                settings.setMaxConvertThread(Integer.valueOf(threadStr.trim()));
            }
            catch (NumberFormatException e) {
                logger.error("dc.convert.max-thread\u5fc5\u987b\u662f\u6574\u6570\uff01");
            }
        }
        if (!FileManagerSettings.isBlank(pdf2HtmlStr = prop.getProperty("dc.convert.pdf2html-exe-path"))) {
            settings.setPdf2HtmlExePath(pdf2HtmlStr.trim());
        }
        if (!FileManagerSettings.isBlank(openOfficePath = prop.getProperty("dc.convert.openoffice.path"))) {
            settings.setPdf2HtmlExePath(openOfficePath.trim());
        }
        if (!FileManagerSettings.isBlank(openOfficePorts = prop.getProperty("dc.convert.openoffice.ports"))) {
            String[] ports;
            ArrayList<Integer> portList = new ArrayList<Integer>();
            String[] stringArray = ports = openOfficePorts.split(",");
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                String port = stringArray[n2];
                try {
                    int p = Integer.valueOf(port.trim());
                    portList.add(p);
                }
                catch (NumberFormatException e) {
                    logger.error("\u7aef\u53e3\u53f7\u5fc5\u987b\u662f\u6574\u6570\uff01\u5f53\u524d\u503c\uff1a{}", (Object)port);
                }
                ++n2;
            }
            int[] intPorts = new int[portList.size()];
            int i = 0;
            while (i < portList.size()) {
                intPorts[i] = (Integer)portList.get(i);
                ++i;
            }
            settings.setOpenOfficePorts(intPorts);
        }
        if (!FileManagerSettings.isBlank(e2h_showHeaders = prop.getProperty("dc.convert.excel2html.show-headers"))) {
            settings.setExcel2HtmlShowHeaders(Boolean.valueOf(e2h_showHeaders));
        }
        if (!FileManagerSettings.isBlank(e2h_showHidden = prop.getProperty("dc.convert.excel2html.show-hidden-content"))) {
            settings.setExcel2HtmlShowHeaders(Boolean.valueOf(e2h_showHidden));
        }
        if (!FileManagerSettings.isBlank(e2h_hideOneTab = prop.getProperty("dc.convert.excel2html.hide-only-one-tab"))) {
            settings.setExcel2HtmlShowHeaders(Boolean.valueOf(e2h_hideOneTab));
        }
        return settings;
    }

    public FileManagerSettings setBaseDir(String baseDir) {
        if (!FileManagerSettings.isBlank(baseDir)) {
            this.baseDir = baseDir.trim();
        } else {
            logger.info("FileManager\u4f7f\u7528\u7f3a\u7701\u5b58\u50a8\u8def\u5f84\uff1a{}", (Object)baseDir);
        }
        return this;
    }

    public FileManagerSettings setIdType(IDType idType) {
        if (idType != null) {
            this.idType = idType;
        }
        return this;
    }

    public FileManagerSettings setUseJackrabbit(String urlOrDir, String user, String password) {
        this.useJackrabbit = true;
        this.jackrabbitURL = urlOrDir;
        this.jackrabbitUser = user;
        this.jackrabbitPassword = password;
        return this;
    }

    public FileManagerSettings setAutoConvert(boolean autoConvert) {
        this.autoConvert = autoConvert;
        return this;
    }

    public FileManagerSettings setConvertStrategy(AutoConvertStrategy convertStrategy) {
        this.convertStrategy = convertStrategy;
        return this;
    }

    public FileManagerSettings setConvertTestMode(boolean isTestMode) {
        this.convertSettings.setTestMode(isTestMode);
        return this;
    }

    public FileManagerSettings setConvertEngine(ConvertEngineType engine) {
        if (engine != null) {
            this.convertSettings.setConvertEngine(engine);
        }
        return this;
    }

    public FileManagerSettings setMaxConvertThread(int maxConvertThread) {
        if (maxConvertThread > 0) {
            this.convertSettings.setMaxConvertThread(maxConvertThread);
        }
        return this;
    }

    public FileManagerSettings setPdf2HtmlExePath(String exePath) {
        if (!FileManagerSettings.isBlank(exePath)) {
            this.convertSettings.setPdf2HtmlExePath(exePath.trim());
        }
        return this;
    }

    public FileManagerSettings setOpenOfficeDirectory(String openOfficeDir) {
        if (!FileManagerSettings.isBlank(openOfficeDir)) {
            this.convertSettings.setOpenOfficePath(openOfficeDir.trim());
        }
        return this;
    }

    public FileManagerSettings setOpenOfficePorts(int[] ports) {
        if (ports != null) {
            this.convertSettings.setOpenOfficePorts(ports);
        }
        return this;
    }

    public FileManagerSettings setExcel2HtmlShowHeaders(boolean excel2html_showHeaders) {
        this.convertSettings.setExcel2HtmlShowHeaders(excel2html_showHeaders);
        return this;
    }

    public FileManagerSettings setExcel2HtmlShowHiddenContent(boolean excel2html_showHiddenContent) {
        this.convertSettings.setExcel2HtmlShowHiddenContent(excel2html_showHiddenContent);
        return this;
    }

    public FileManagerSettings setExcel2HtmlHideTabIfOnlyOne(boolean excel2html_hideTabIfOnlyOne) {
        this.convertSettings.setExcel2HtmlHideTabIfOnlyOne(excel2html_hideTabIfOnlyOne);
        return this;
    }

    public FileManagerSettings setExcel2HtmlTemplateStr(String excel2html_htmlTemplate) {
        if (!FileManagerSettings.isBlank(excel2html_htmlTemplate)) {
            this.convertSettings.setExcel2HtmlTemplateStr(excel2html_htmlTemplate);
        }
        return this;
    }

    public FileManagerSettings setConvertSettings(FileConverterSettings settings) {
        if (settings != null) {
            this.convertSettings = settings;
        } else {
            logger.warn("setConvertSettings\u53c2\u6570\u4e3anull\u3002\u5c06\u4f7f\u7528\u9ed8\u8ba4\u8f6c\u6362\u8bbe\u7f6e\u3002");
        }
        return this;
    }

    void apply(FileManager filemanager) throws FileStoreException, IOException {
        Object fileStore;
        File baseDir = new File(this.baseDir);
        baseDir = new File(baseDir.getAbsolutePath());
        if (this.useJackrabbit) {
            fileStore = this.jackrabbitURL.startsWith("http") ? new RemoteJackRabbitFileStore(this.jackrabbitURL, this.jackrabbitUser, this.jackrabbitPassword) : new LocalJackRabbitFileStore(this.jackrabbitURL, this.jackrabbitUser, this.jackrabbitPassword);
            this.idType = IDType.uuid;
        } else {
            String fileStoreBaseDir = new File(baseDir, "file_storage").getAbsolutePath();
            fileStore = IDType.timestamp.equals((Object)this.idType) ? new TimeStampSimpleFileStore(fileStoreBaseDir) : new UUIDSimpleFileStore(fileStoreBaseDir);
        }
        filemanager.setFileStore((FileStore)fileStore);
        String convertBaseDir = new File(baseDir, "convert_storage").getAbsolutePath();
        this.convertSettings.setWorkdir(new File(convertBaseDir));
        if (IDType.timestamp.equals((Object)this.idType)) {
            this.convertSettings.setStorageType(StorageType.TimeStamp);
        } else {
            this.convertSettings.setStorageType(StorageType.UUID);
        }
        FileConverterService.init((FileConverterSettings)this.convertSettings);
        filemanager.setAutoConvert(this.autoConvert);
        if (this.convertStrategy != null) {
            filemanager.setConvertStrategy(this.convertStrategy);
        }
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static enum IDType {
        uuid,
        timestamp;

    }
}

