/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filemanager;

import com.kdgcsoft.power.fileconverter.FileConverterException;
import com.kdgcsoft.power.fileconverter.FileConverterService;
import com.kdgcsoft.power.fileconverter.OutputType;
import com.kdgcsoft.power.filemanager.AutoConvertStrategy;
import com.kdgcsoft.power.filemanager.FileManagerSettings;
import com.kdgcsoft.power.filemanager.RequestDocInfo;
import com.kdgcsoft.power.filestore.FileInfo;
import com.kdgcsoft.power.filestore.FileStore;
import com.kdgcsoft.power.filestore.FileStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileManager {
    private static final Logger logger = LoggerFactory.getLogger(FileManager.class);
    private static FileManager instance = new FileManager();
    private FileStore fileStore;
    private boolean autoConvert = true;
    private AutoConvertStrategy convertStrategy = AutoConvertStrategy.createDefaultStrategy();
    private volatile boolean inited = false;
    private FileManagerSettings settings = FileManagerSettings.createDefault();

    FileManager() {
    }

    public static FileManager getInstance() {
        return instance;
    }

    public static void init(FileManagerSettings settings) {
        if (FileManager.instance.inited) {
            logger.error("FileManager\u5df2\u7ecf\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u591a\u6b21\u8c03\u7528init\u63a5\u53e3\uff01");
        }
        FileManager.instance.settings = settings;
    }

    public static void init(File propFile) {
        if (FileManager.instance.inited) {
            logger.error("FileManager\u5df2\u7ecf\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u591a\u6b21\u8c03\u7528init\u63a5\u53e3\uff01");
        }
        FileManager.instance.settings = FileManagerSettings.createByPropertiesFile(propFile);
    }

    public static void init(InputStream is) {
        if (FileManager.instance.inited) {
            logger.error("FileManager\u5df2\u7ecf\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u591a\u6b21\u8c03\u7528init\u63a5\u53e3\uff01");
        }
        FileManager.instance.settings = FileManagerSettings.createByPropertiesSteam(is);
    }

    public static void init(Properties props) {
        if (FileManager.instance.inited) {
            logger.error("FileManager\u5df2\u7ecf\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u591a\u6b21\u8c03\u7528init\u63a5\u53e3\uff01");
        }
        FileManager.instance.settings = FileManagerSettings.createByProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepare() throws FileStoreException {
        if (this.inited) {
            return;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            try {
                if (this.inited) {
                    return;
                }
                this.settings.apply(this);
                this.inited = true;
            }
            catch (IOException e) {
                logger.error("FileManager\u521d\u59cb\u5316\u5931\u8d25\uff01", (Object)e.getMessage());
                throw new FileStoreException((Throwable)e);
            }
            catch (FileStoreException e) {
                logger.error("FileManager\u521d\u59cb\u5316\u5931\u8d25\uff01", (Object)e.getMessage());
                throw new FileStoreException((Throwable)e);
            }
        }
    }

    void setFileStore(FileStore store) {
        this.fileStore = store;
    }

    void setAutoConvert(boolean autoConvert) {
        this.autoConvert = autoConvert;
    }

    void setConvertStrategy(AutoConvertStrategy convertStrategy) {
        this.convertStrategy = convertStrategy;
    }

    public FileInfo putFile(File file) throws FileStoreException, FileConverterException {
        this.prepare();
        return this.putFile(file, file.getName());
    }

    public FileInfo putFile(File file, String fileName) throws FileStoreException, FileConverterException {
        this.prepare();
        try {
            return this.putFileAsStream(new FileInputStream(file), fileName);
        }
        catch (FileNotFoundException e) {
            throw new FileStoreException((Throwable)e);
        }
    }

    public FileInfo putFileAsStream(InputStream stream, String fileName) throws FileStoreException, FileConverterException {
        String ext;
        Collection<OutputType> strategy;
        this.prepare();
        FileInfo info = this.fileStore.putFileAsStream(stream, fileName);
        if (this.autoConvert && (strategy = this.convertStrategy.getConvertStrategy(ext = FilenameUtils.getExtension((String)fileName))) != null) {
            for (OutputType type : strategy) {
                InputStream is = this.fileStore.getFileAsStream(info.getKey());
                if (!FileConverterService.canCanvert((String)fileName, (OutputType)type)) continue;
                FileConverterService.convert((InputStream)is, (String)fileName, (String)info.getKey(), (OutputType)type, (boolean)true);
            }
        }
        return info;
    }

    public FileInfo getFile(String key) throws FileStoreException {
        this.prepare();
        return this.fileStore.getFile(key);
    }

    public InputStream getFileAsStream(String key) throws FileStoreException {
        this.prepare();
        return this.fileStore.getFileAsStream(key);
    }

    public void deleteFile(String key) throws FileStoreException {
        this.prepare();
        this.fileStore.deleteFile(key);
        FileConverterService.deleteConvertedFileQuietly((String)key);
    }

    public void convert(String key, OutputType outType, boolean isAsync) throws FileConverterException, FileStoreException {
        this.prepare();
        FileInfo info = this.fileStore.getFile(key);
        if (info != null) {
            FileConverterService.convert((InputStream)info.getInputStream(), (String)info.getFileName(), (OutputType)outType, (boolean)isAsync);
        } else {
            logger.error("\u4e0d\u5b58\u5728\u7684\u6587\u4ef6Key:{}", (Object)key);
        }
    }

    public void close() {
        FileConverterService.finish();
    }

    public RequestDocInfo getFile(String key, String wantType, boolean autoConvert) throws FileStoreException, FileConverterException {
        this.prepare();
        FileInfo originFileInfo = this.fileStore.getFile(key);
        if (originFileInfo == null) {
            logger.error("\u5728\u6587\u4ef6\u5b58\u50a8\u5e93\u4e2d\u627e\u4e0d\u5230\u6587\u4ef6\u3002\u53ef\u80fd\u662f\u6587\u4ef6\u5b58\u50a8\u5e93\u88ab\u4eba\u4e3a\u5220\u9664\u4e86\u6587\u4ef6\uff01Key={}", (Object)key);
            return null;
        }
        String fileName = originFileInfo.getFileName().toLowerCase();
        RequestDocInfo docInfo = new RequestDocInfo();
        docInfo.setKey(originFileInfo.getKey());
        docInfo.setOriginalFileName(originFileInfo.getFileName());
        docInfo.setOriginalFileStream(originFileInfo.getInputStream());
        docInfo.setWantType(wantType.toLowerCase());
        if (fileName.toLowerCase().endsWith("." + wantType.toLowerCase())) {
            docInfo.setSupportWantType(true);
            docInfo.setWantFilesCount(1);
            return docInfo;
        }
        OutputType outType = null;
        try {
            outType = OutputType.valueOf((String)wantType.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            logger.error("\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u8f6c\u6362\u6210\u76ee\u6807\u7c7b\u578b\u3002\u6587\u4ef6Key\uff1a{}, \u6587\u4ef6\u540d\uff1a{}, \u76ee\u6807\u7c7b\u578b\uff1a{} ", new Object[]{key, originFileInfo.getFileName(), wantType});
            docInfo.setSupportWantType(false);
            docInfo.setWantFilesCount(0);
            return docInfo;
        }
        if (!FileConverterService.canCanvert((String)fileName, (OutputType)outType)) {
            logger.error("\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u8f6c\u6362\u6210\u76ee\u6807\u7c7b\u578b\u3002\u6587\u4ef6Key\uff1a{}, \u6587\u4ef6\u540d\uff1a{}, \u76ee\u6807\u7c7b\u578b\uff1a{} ", new Object[]{key, originFileInfo.getFileName(), outType.toString()});
            docInfo.setSupportWantType(false);
            docInfo.setWantFilesCount(0);
            return docInfo;
        }
        docInfo.setSupportWantType(true);
        int count = FileConverterService.getConvertedFilesCount((String)key, (OutputType)outType);
        if (count == 0) {
            if (autoConvert) {
                FileConverterService.convert((InputStream)originFileInfo.getInputStream(), (String)fileName, (String)key, (OutputType)outType);
                count = FileConverterService.getConvertedFilesCount((String)key, (OutputType)outType);
            } else {
                logger.info("{}\u6587\u4ef6\u5c1a\u672a\u88ab\u8f6c\u6362\u6210{}\u683c\u5f0f", (Object)key, (Object)outType.toString());
            }
        }
        docInfo.setWantFilesCount(count);
        return docInfo;
    }

    public InputStream getFileAsStream(String key, String wantType, boolean autoConvert) throws FileStoreException, FileConverterException {
        this.prepare();
        RequestDocInfo info = this.getFile(key, wantType, autoConvert);
        if (info == null || !info.isSupportWantType() || info.getWantFilesCount() == 0) {
            return null;
        }
        if (info.getOriginalFileName().toLowerCase().endsWith("." + wantType.toLowerCase())) {
            return info.getOriginalFileStream();
        }
        try {
            OutputType outType = OutputType.valueOf((String)wantType);
            return FileConverterService.getConvertedFileAsStream((String)key, (OutputType)outType);
        }
        catch (IllegalArgumentException e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u8f6c\u6362\u683c\u5f0f\uff1a{}", (Object)wantType);
            return null;
        }
    }

    public InputStream getFilePageAsStream(String key, String wantType, int page, boolean autoConvert) throws FileStoreException, FileConverterException {
        this.prepare();
        RequestDocInfo info = this.getFile(key, wantType, autoConvert);
        if (info == null || !info.isSupportWantType() || info.getWantFilesCount() == 0) {
            return null;
        }
        try {
            OutputType outType = OutputType.valueOf((String)wantType);
            return FileConverterService.getConvertedPageAsStream((String)key, (OutputType)outType, (int)page);
        }
        catch (IllegalArgumentException e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u8f6c\u6362\u683c\u5f0f\uff1a{}", (Object)wantType);
            return null;
        }
    }
}

