/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filemanager;

import com.kdgcsoft.power.fileconverter.OutputType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConvertStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AutoConvertStrategy.class);
    private Map<String, SortedSet<OutputType>> convertDefMap = new HashMap<String, SortedSet<OutputType>>();
    private static final String DEFAULT_STRATEGY = "doc/docx/ppt/pptx->pdf, xls/xlsx->html";

    private AutoConvertStrategy() {
    }

    public static AutoConvertStrategy parse(String strategyStr) {
        AutoConvertStrategy strategy = new AutoConvertStrategy();
        String[] rules = strategyStr.split(",");
        logger.info("\u8bbe\u7f6e\u81ea\u52a8\u8f6c\u6362\u7b56\u7565\uff1a");
        String[] stringArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            String[] convMap = rule.split("\\-\\>");
            if (convMap.length != 2) {
                logger.error("\u4e0d\u5408\u6cd5\u7684\u81ea\u52a8\u8f6c\u6362\u7b56\u7565\u5b9a\u4e49\uff1a{}", (Object)rule);
            } else {
                String srcExts = convMap[0].trim();
                String outExts = convMap[1].trim();
                String[] stringArray2 = srcExts.split("/");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String srcExt = stringArray2[n4];
                    String[] stringArray3 = outExts.split("/");
                    int n5 = stringArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String outExt = stringArray3[n6];
                        logger.info("{} -> {}", (Object)srcExt, (Object)outExt);
                        strategy.addStrategy(srcExt, outExt);
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return strategy;
    }

    public void addStrategy(String inputExt, String outExt) {
        if (inputExt == null) {
            return;
        }
        SortedSet<OutputType> typeList = this.convertDefMap.get(inputExt);
        if (typeList == null) {
            typeList = new TreeSet<OutputType>();
            this.convertDefMap.put(inputExt, typeList);
        }
        try {
            OutputType outType = OutputType.valueOf((String)outExt.trim().toLowerCase());
            typeList.add(outType);
        }
        catch (IllegalArgumentException e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u8f6c\u6362\u76ee\u6807\u6269\u5c55\u540d\uff1a{}", (Object)outExt);
        }
    }

    public void addStrategy(String srcExtName, OutputType outType) {
        SortedSet<OutputType> typeSet = this.convertDefMap.get(srcExtName);
        if (typeSet == null) {
            typeSet = new TreeSet<OutputType>();
            this.convertDefMap.put(srcExtName, typeSet);
        }
        typeSet.add(outType);
    }

    public Collection<OutputType> getConvertStrategy(String extName) {
        return this.convertDefMap.get(extName);
    }

    public static AutoConvertStrategy createDefaultStrategy() {
        return AutoConvertStrategy.parse(DEFAULT_STRATEGY);
    }
}

