package com.kdgcsoft.power.fileconverter.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 用来接收外部命令行程序的输出流
 * @author hling
 *
 */
public class StreamGobbler extends Thread {
	
	private static final Logger LOG = LoggerFactory.getLogger(StreamGobbler.class);
	
	private Logger logger;
	private InputStream is;
	private String printHeader;
	
	private static Charset defaultCharset;
	
	static {
		String charsetString = System.getProperty("sun.jnu.encoding");
		try {
			defaultCharset = Charset.forName(charsetString);
		} catch (Exception e) {
			defaultCharset = Charset.defaultCharset();
		}
	}

	public StreamGobbler(Logger logger, InputStream is, String printHeader) {
		this.logger = logger;
		this.is = is;
		this.printHeader = printHeader;
	}

	@Override
	public void run() {
		try {
			InputStreamReader isr = new InputStreamReader(is, defaultCharset);
			BufferedReader br = new BufferedReader(isr);
			String line = null;
			while ((line = br.readLine()) != null) {
				if (printHeader != null && !"".equals(printHeader)) {
					logger.info("{}>{}", printHeader, line);
				} else {
					logger.info(">{}", line);
				}
			}
				
		} catch (IOException ioe) {
			LOG.error("read console stream failed!", ioe);
		}
	}
}