package com.kdgcsoft.power.fileconverter.util;

import org.apache.commons.io.FilenameUtils;

/**
 * 处理文件扩展名的工具类
 * @author hling
 *
 */
public class FileExtensionUtil {
	
	private FileExtensionUtil() {
		// 工具类不需要new
	}
	
	/**
	 * 更改文件扩展名
	 * @param filename 原文件名。可以带有路径。
	 * @param newExtension 新扩展名，可以是 "doc"或".doc"格式
	 * @return 新文件名。如果原文件名带路径，返回文件名也带路径
	 */
	public static String replaceExtension(final String filename, final String newExtension) {
		if (newExtension.startsWith(".")) {
			return FilenameUtils.removeExtension(filename) + newExtension;
		} else {
			return FilenameUtils.removeExtension(filename) + "." + newExtension;
		}
	}
	
	/**
	 * 在原文件名后添加扩展名
	 * @param filename 原文件名
	 * @param newExtension 要添加的扩展名
	 * @return 新文件名
	 */
	public static String addExtension(final String filename, final String newExtension) {
		if (newExtension.startsWith(".")) {
			return filename + newExtension;
		} else {
			return filename + "." + newExtension;
		}
	}
}
