package com.kdgcsoft.power.fileconverter.impl;

import java.io.File;

import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdgcsoft.power.fileconverter.FileConverterSettings;
import com.kdgcsoft.power.fileconverter.IFileConverter;

/**
 * 基于JodConverter的转换器，能转换大多数文档格式到pdf、png、html(效果可能不好)
 * @author hling
 *
 */
public class JodOfficeConverter implements IFileConverter {
	
	private static final Logger logger = LoggerFactory.getLogger(JodOfficeConverter.class);

	@Override
	public File convert(final File srcFile, final File destFile, final FileConverterSettings settings) throws OfficeException {
        logger.info("开始使用LibreOffice/OpenOffice进行转换...");

		JodHelper.convert(srcFile, destFile, settings.getOpenOfficePath(), settings.getMaxConvertThread(), settings.getOpenOfficePorts());
		return destFile;
	}

}
